/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action;

import com.google.inject.Inject;
import java.io.IOException;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.ActionInvocationWorkflow;
import org.primeframework.mvc.action.result.ResultStore;
import org.primeframework.mvc.util.ReflectionUtils;
import org.primeframework.mvc.workflow.WorkflowChain;

public class DefaultActionInvocationWorkflow
implements ActionInvocationWorkflow {
    private final ActionInvocationStore actionInvocationStore;
    private final ResultStore resultStore;

    @Inject
    public DefaultActionInvocationWorkflow(ActionInvocationStore actionInvocationStore, ResultStore resultStore) {
        this.resultStore = resultStore;
        this.actionInvocationStore = actionInvocationStore;
    }

    @Override
    public void perform(WorkflowChain chain) throws IOException {
        ActionInvocation actionInvocation = this.actionInvocationStore.getCurrent();
        if (actionInvocation.action != null) {
            String resultCode = this.execute(actionInvocation);
            this.resultStore.set(resultCode);
        }
        chain.continueWorkflow();
    }

    protected String execute(ActionInvocation actionInvocation) {
        Object action = actionInvocation.action;
        String result = (String)ReflectionUtils.invoke(actionInvocation.method.method, action, new Object[0]);
        if (result == null) {
            throw new PrimeException("The action class [" + String.valueOf(action.getClass()) + "] returned null for the result code. Execute methods must never return null.");
        }
        return result;
    }
}

