/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import org.apache.commons.lang3.ArrayUtils;
import org.primeframework.mvc.MockConfiguration;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.converters.BooleanConverter;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BooleanConverterTest {
    @Test
    public void fromStrings() {
        BooleanConverter booleanConverter = new BooleanConverter((MVCConfiguration)new MockConfiguration());
        Boolean bl = (Boolean)booleanConverter.convertFromStrings(Boolean.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}));
        Assert.assertNull((Object)bl);
        bl = (Boolean)booleanConverter.convertFromStrings(Boolean.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}));
        Assert.assertFalse((boolean)bl);
        bl = (Boolean)booleanConverter.convertFromStrings(Boolean.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"true"}));
        Assert.assertTrue((boolean)bl);
        bl = (Boolean)booleanConverter.convertFromStrings(Boolean.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"yes"}));
        Assert.assertTrue((boolean)bl);
        bl = (Boolean)booleanConverter.convertFromStrings(Boolean.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"on"}));
        Assert.assertTrue((boolean)bl);
        bl = (Boolean)booleanConverter.convertFromStrings(Boolean.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"true"}));
        Assert.assertTrue((boolean)bl);
        bl = (Boolean)booleanConverter.convertFromStrings(Boolean.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"false"}));
        Assert.assertFalse((boolean)bl);
        bl = (Boolean)booleanConverter.convertFromStrings(Boolean.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"no"}));
        Assert.assertFalse((boolean)bl);
        bl = (Boolean)booleanConverter.convertFromStrings(Boolean.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"off"}));
        Assert.assertFalse((boolean)bl);
        bl = (Boolean)booleanConverter.convertFromStrings(Boolean.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"false"}));
        Assert.assertFalse((boolean)bl);
        bl = (Boolean)booleanConverter.convertFromStrings(Boolean.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"   "}));
        Assert.assertNull((Object)bl);
        bl = (Boolean)booleanConverter.convertFromStrings(Boolean.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"   "}));
        Assert.assertFalse((boolean)bl);
        Boolean[] booleanArray = (Boolean[])booleanConverter.convertFromStrings(Boolean[].class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"true", "false"}));
        Assert.assertTrue((boolean)booleanArray[0]);
        Assert.assertFalse((boolean)booleanArray[1]);
        boolean[] blArray = (boolean[])booleanConverter.convertFromStrings(boolean[].class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"true", "false"}));
        Assert.assertTrue((boolean)blArray[0]);
        Assert.assertFalse((boolean)blArray[1]);
        try {
            booleanConverter.convertFromStrings(Boolean.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"fals3"}));
            Assert.fail((String)"Should have failed");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    @Test
    public void toStrings() {
        BooleanConverter booleanConverter = new BooleanConverter((MVCConfiguration)new MockConfiguration());
        String string = booleanConverter.convertToString(Boolean.class, null, "testExpr", null);
        Assert.assertNull((Object)string);
        string = booleanConverter.convertToString(Boolean.class, null, "testExpr", (Object)Boolean.TRUE);
        Assert.assertEquals((String)string, (String)"true");
        string = booleanConverter.convertToString(Boolean.TYPE, null, "testExpr", (Object)Boolean.TRUE);
        Assert.assertEquals((String)string, (String)"true");
        string = booleanConverter.convertToString(Boolean.class, null, "testExpr", (Object)Boolean.FALSE);
        Assert.assertEquals((String)string, (String)"false");
        string = booleanConverter.convertToString(Boolean.TYPE, null, "testExpr", (Object)Boolean.FALSE);
        Assert.assertEquals((String)string, (String)"false");
    }
}

