/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security.csrf;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPRequest;
import java.util.concurrent.TimeUnit;
import org.primeframework.mvc.ErrorException;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.security.UserLoginSecurityContext;
import org.primeframework.mvc.security.csrf.CSRFProvider;
import org.primeframework.mvc.util.CookieTools;

public class DefaultEncryptionBasedTokenCSRFProvider
implements CSRFProvider {
    private final Encryptor encryptor;
    private final ObjectMapper objectMapper;
    private final UserLoginSecurityContext securityContext;
    private long nonceTimeout = TimeUnit.MINUTES.toMillis(15L);

    @Inject
    public DefaultEncryptionBasedTokenCSRFProvider(Encryptor encryptor, ObjectMapper objectMapper, UserLoginSecurityContext securityContext) {
        this.encryptor = encryptor;
        this.objectMapper = objectMapper;
        this.securityContext = securityContext;
    }

    @Override
    public String getToken(HTTPRequest request) {
        String csrfToken = (String)request.getAttribute(this.getParameterName());
        if (csrfToken == null) {
            String sessionId = this.securityContext.getSessionId();
            if (sessionId == null) {
                return null;
            }
            csrfToken = this.generateToken(sessionId);
            request.setAttribute(this.getParameterName(), (Object)csrfToken);
        }
        return csrfToken;
    }

    @Override
    public boolean validateRequest(HTTPRequest request) {
        CSRFToken token = this.decrypt(this.getTokenFromRequest(request));
        if (token == null) {
            return false;
        }
        String sessionId = this.securityContext.getSessionId();
        if (!token.sid.equals(sessionId)) {
            return false;
        }
        long now = System.currentTimeMillis();
        return token.instant + this.nonceTimeout >= now;
    }

    protected void setNonceTimeout(long nonceTimeout) {
        this.nonceTimeout = nonceTimeout;
    }

    private CSRFToken decrypt(String s) {
        try {
            return CookieTools.fromJSONCookie(s, CSRFToken.class, true, true, this.encryptor, this.objectMapper);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String generateToken(String sessionId) {
        try {
            CSRFToken token = new CSRFToken();
            token.sid = sessionId;
            token.instant = System.currentTimeMillis();
            return CookieTools.toJSONCookie(token, false, true, this.encryptor, this.objectMapper);
        }
        catch (Exception e) {
            throw new ErrorException("error", (Throwable)e, new Object[0]);
        }
    }

    private static class CSRFToken {
        public long instant;
        public String sid;

        private CSRFToken() {
        }
    }
}

