/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.google.inject.Inject;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPRequest;
import java.util.Arrays;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.AuthorizationMethodConfiguration;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.parameter.el.ExpressionException;
import org.primeframework.mvc.security.AuthorizeSchemeData;
import org.primeframework.mvc.security.SecurityScheme;
import org.primeframework.mvc.security.UnauthenticatedException;
import org.primeframework.mvc.security.UnauthorizedException;
import org.primeframework.mvc.security.VerifierProvider;
import org.primeframework.mvc.util.ReflectionUtils;

public class AuthorizeMethodScheme
implements SecurityScheme {
    protected final ActionInvocationStore actionInvocationStore;
    protected final HTTPRequest request;
    protected final VerifierProvider verifierProvider;

    @Inject
    public AuthorizeMethodScheme(ActionInvocationStore actionInvocationStore, HTTPRequest request, VerifierProvider verifierProvider) {
        this.actionInvocationStore = actionInvocationStore;
        this.request = request;
        this.verifierProvider = verifierProvider;
    }

    @Override
    public void handle(String[] constraints) {
        ActionInvocation actionInvocation = this.actionInvocationStore.getCurrent();
        Object[] parameters = new Object[]{};
        ActionConfiguration actionConfiguration = actionInvocation.configuration;
        HTTPMethod method = this.request.getMethod();
        if (!actionConfiguration.authorizationMethods.containsKey(method)) {
            throw new UnauthenticatedException();
        }
        for (AuthorizationMethodConfiguration methodConfig : actionConfiguration.authorizationMethods.get(method)) {
            try {
                Boolean authorized;
                if (methodConfig.method.getParameterCount() == 1) {
                    parameters = new Object[]{new AuthorizeSchemeData(Arrays.asList(constraints), method, this.request)};
                }
                if ((authorized = (Boolean)ReflectionUtils.invoke(methodConfig.method, actionInvocation.action, parameters)).booleanValue()) continue;
                throw new UnauthorizedException();
            }
            catch (ExpressionException e) {
                throw new PrimeException("Unable to invoke @AuthorizeMethod on the class [" + String.valueOf(actionConfiguration.actionClass) + "]", e);
            }
        }
    }
}

