/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.message.scope;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.primeframework.mvc.ErrorException;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.scope.FlashScope;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.util.CookieTools;

public class CookieFlashScope
implements FlashScope {
    private final Encryptor encryptor;
    private final List<Message> messages;
    private final String name;
    private final ObjectMapper objectMapper;
    private final HTTPRequest request;
    private final HTTPResponse response;

    @Inject
    public CookieFlashScope(Encryptor encryptor, MVCConfiguration configuration, ObjectMapper objectMapper, HTTPRequest request, HTTPResponse response) {
        this.encryptor = encryptor;
        this.name = configuration.messageFlashScopeCookieName();
        this.objectMapper = objectMapper;
        this.request = request;
        this.response = response;
        Cookie cookie = request.getCookie(this.name);
        this.messages = cookie != null ? this.deserialize(cookie.value) : new ArrayList<Message>();
    }

    @Override
    public void add(Message message) {
        this.addAll(List.of(message));
    }

    @Override
    public void addAll(Collection<Message> newMessages) {
        if (newMessages == null || newMessages.isEmpty()) {
            return;
        }
        this.messages.addAll(newMessages);
        try {
            String value = CookieTools.toJSONCookie(this.messages, true, true, this.encryptor, this.objectMapper);
            Cookie cookie = new Cookie(this.name, value);
            cookie.httpOnly = true;
            cookie.path = "/";
            cookie.secure = "https".equalsIgnoreCase(this.request.getScheme());
            this.response.addCookie(cookie);
        }
        catch (Exception e) {
            throw new ErrorException(e, new Object[0]);
        }
    }

    @Override
    public void clear() {
        Cookie cookie = this.request.getCookie(this.name);
        if (cookie != null) {
            cookie.value = null;
            cookie.maxAge = 0L;
            cookie.path = "/";
            this.response.addCookie(cookie);
            this.request.deleteCookie(this.name);
        }
        this.messages.clear();
    }

    @Override
    public List<Message> get() {
        return new ArrayList<Message>(this.messages);
    }

    private List<Message> deserialize(String s) {
        try {
            List<Message> messages = CookieTools.fromJSONCookie(s, new TypeReference<List<Message>>(this){}, true, true, this.encryptor, this.objectMapper);
            if (messages == null) {
                return new ArrayList<Message>();
            }
            return new ArrayList<Message>(messages);
        }
        catch (Exception e) {
            return new ArrayList<Message>();
        }
    }
}

