/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.el;

import com.google.inject.Inject;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.example.action.ExtensionInheritanceAction;
import org.example.domain.Action;
import org.example.domain.ActionField;
import org.example.domain.Address;
import org.example.domain.AddressField;
import org.example.domain.Covariant;
import org.example.domain.CustomObject;
import org.example.domain.GenericBean;
import org.example.domain.NestedDataUnwrappedAction;
import org.example.domain.User;
import org.example.domain.UserField;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.parameter.el.DefaultExpressionEvaluator;
import org.primeframework.mvc.parameter.el.InvalidExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultExpressionEvaluatorTest
extends PrimeBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExpressionEvaluatorTest.class);
    DefaultExpressionEvaluator evaluator;

    @Test
    public void charArrayCachePerformance() {
        String string = "user.address['work'].city";
        Instant instant = Instant.now();
        char c = '\u0000';
        for (int i = 0; i < 1000000; ++i) {
            char[] cArray = string.toCharArray();
            c = cArray[2];
        }
        logger.info(Character.toString(c));
        logger.info("Time for toCharArray: " + Math.abs(Duration.between(Instant.now(), instant).toMillis()));
        instant = Instant.now();
        c = '\u0000';
        logger.info(Character.toString(c));
        logger.info("Time for cache: " + Math.abs(Duration.between(Instant.now(), instant).toMillis()));
    }

    @Test
    public void covariantTypes() {
        Covariant covariant = new Covariant();
        covariant.value = "value";
        covariant.override = "base";
        Assert.assertEquals((String)((String)this.evaluator.getValue("abstract", (Object)covariant)), (String)"value");
        Assert.assertEquals((String)((String)this.evaluator.getValue("override", (Object)covariant)), (String)"value");
        this.evaluator.setValue("abstractNesting.name", (Object)covariant, (Object)"Brian Pontarelli");
        Assert.assertEquals((String)covariant.user.getName(), (String)"Brian Pontarelli");
        Assert.assertEquals((String)((String)this.evaluator.getValue("abstractNesting.name", (Object)covariant)), (String)"Brian Pontarelli");
        this.evaluator.setValue("interface.name", (Object)covariant, (Object)"Brian Pontarelli");
        Assert.assertEquals((String)((String)this.evaluator.getValue("interface.name", (Object)covariant)), (String)"Brian Pontarelli");
    }

    @Test
    public void expansion() {
        ActionField actionField = new ActionField();
        actionField.user = new UserField();
        actionField.user.name = "Fred";
        String string = this.evaluator.expand("My name is ${user.name}", (Object)actionField, false);
        Assert.assertEquals((String)string, (String)"My name is Fred");
        actionField.user.name = "/Fred";
        string = this.evaluator.expand("My name is ${user.name}", (Object)actionField, true);
        Assert.assertEquals((String)string, (String)"My name is %2FFred");
        actionField.user.age = 35;
        string = this.evaluator.expand("My age is ${user.age}", (Object)actionField, true);
        Assert.assertEquals((String)string, (String)"My age is 35");
        actionField.user.age = null;
        string = this.evaluator.expand("My age is ${user.age}", (Object)actionField, false);
        Assert.assertEquals((String)string, (String)"My age is ");
        actionField.user.age = null;
        string = this.evaluator.expand("My age is ${user.age}", (Object)actionField, true);
        Assert.assertEquals((String)string, (String)"My age is ");
    }

    @Test
    public void fieldGetting() {
        UserField userField;
        ActionField actionField = new ActionField();
        Assert.assertNull((Object)this.evaluator.getValue("user", (Object)actionField));
        actionField.user = userField = new UserField();
        Assert.assertSame((Object)userField, (Object)this.evaluator.getValue("user", (Object)actionField));
        actionField.user.age = 32;
        actionField.user.name = "Brian";
        actionField.user.active = true;
        Assert.assertEquals((Integer)((Integer)this.evaluator.getValue("user.age", (Object)actionField)), (Integer)32);
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.name", (Object)actionField)), (String)"Brian");
        Assert.assertTrue((boolean)((Boolean)this.evaluator.getValue("user.active", (Object)actionField)));
        AddressField addressField = new AddressField();
        addressField.city = "Broomfield";
        addressField.state = "CO";
        addressField.street = "Test";
        addressField.zipcode = "80020";
        actionField.user.addresses.put("home", addressField);
        Assert.assertNull((Object)this.evaluator.getValue("user.addresses['work']", (Object)actionField));
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.addresses['home'].city", (Object)actionField)), (String)"Broomfield");
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.addresses['home'].state", (Object)actionField)), (String)"CO");
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.addresses['home'].street", (Object)actionField)), (String)"Test");
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.addresses['home'].zipcode", (Object)actionField)), (String)"80020");
        UserField userField2 = new UserField();
        userField2.name = "Brett";
        userField2.age = 34;
        userField.siblings.add(userField2);
        Assert.assertEquals((Integer)((Integer)this.evaluator.getValue("user.siblings[0].age", (Object)actionField)), (Integer)34);
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.siblings[0].name", (Object)actionField)), (String)"Brett");
        userField.securityQuestions = new String[]{"What is your pet's name?", "What is your home town?"};
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.securityQuestions[0]", (Object)actionField)), (String)"What is your pet's name?");
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.securityQuestions[1]", (Object)actionField)), (String)"What is your home town?");
    }

    @Test
    public void fieldInheritance() {
        ExtensionInheritanceAction extensionInheritanceAction = new ExtensionInheritanceAction();
        extensionInheritanceAction.baseField = "bar";
        Assert.assertEquals((String)((String)this.evaluator.getValue("baseField", (Object)extensionInheritanceAction)), (String)"bar");
        this.evaluator.setValue("baseField", (Object)extensionInheritanceAction, (String[])ArrayUtils.toArray((Object[])new String[]{"baz"}), null);
        Assert.assertEquals((String)((String)this.evaluator.getValue("baseField", (Object)extensionInheritanceAction)), (String)"baz");
    }

    @Test
    public void fieldSetting() {
        ActionField actionField = new ActionField();
        this.evaluator.setValue("user.age", (Object)actionField, (String[])ArrayUtils.toArray((Object[])new String[]{"32"}), null);
        this.evaluator.setValue("user.name", (Object)actionField, (String[])ArrayUtils.toArray((Object[])new String[]{"Brian"}), null);
        this.evaluator.setValue("user.active", (Object)actionField, (String[])ArrayUtils.toArray((Object[])new String[]{"true"}), null);
        Assert.assertEquals((Integer)actionField.user.age, (Integer)32);
        Assert.assertEquals((String)actionField.user.name, (String)"Brian");
        Assert.assertTrue((boolean)actionField.user.active);
        actionField.user.addresses = null;
        this.evaluator.setValue("user.addresses['home'].city", (Object)actionField, (String[])ArrayUtils.toArray((Object[])new String[]{"Broomfield"}), null);
        this.evaluator.setValue("user.addresses['home'].state", (Object)actionField, (String[])ArrayUtils.toArray((Object[])new String[]{"CO"}), null);
        this.evaluator.setValue("user.addresses['home'].street", (Object)actionField, (String[])ArrayUtils.toArray((Object[])new String[]{"Test"}), null);
        this.evaluator.setValue("user.addresses['home'].zipcode", (Object)actionField, (String[])ArrayUtils.toArray((Object[])new String[]{"80020"}), null);
        Assert.assertEquals((int)actionField.user.addresses.size(), (int)1);
        Assert.assertNull((Object)actionField.user.addresses.get("work"));
        Assert.assertEquals((String)actionField.user.addresses.get((Object)"home").city, (String)"Broomfield");
        Assert.assertEquals((String)actionField.user.addresses.get((Object)"home").state, (String)"CO");
        Assert.assertEquals((String)actionField.user.addresses.get((Object)"home").street, (String)"Test");
        Assert.assertEquals((String)actionField.user.addresses.get((Object)"home").zipcode, (String)"80020");
        this.evaluator.setValue("user.siblings[0].age", (Object)actionField, (String[])ArrayUtils.toArray((Object[])new String[]{"34"}), null);
        this.evaluator.setValue("user.siblings[0].name", (Object)actionField, (String[])ArrayUtils.toArray((Object[])new String[]{"Brett"}), null);
        Assert.assertEquals((int)actionField.user.siblings.size(), (int)1);
        Assert.assertEquals((Integer)actionField.user.siblings.get((int)0).age, (Integer)34);
        Assert.assertEquals((String)actionField.user.siblings.get((int)0).name, (String)"Brett");
        this.evaluator.setValue("user.securityQuestions[0]", (Object)actionField, (String[])ArrayUtils.toArray((Object[])new String[]{"What is your pet's name?"}), null);
        this.evaluator.setValue("user.securityQuestions[1]", (Object)actionField, (String[])ArrayUtils.toArray((Object[])new String[]{"What is your home town?"}), null);
        Assert.assertEquals((int)actionField.user.securityQuestions.length, (int)2);
        Assert.assertEquals((String)actionField.user.securityQuestions[0], (String)"What is your pet's name?");
        Assert.assertEquals((String)actionField.user.securityQuestions[1], (String)"What is your home town?");
        actionField.user.securityQuestions = null;
        this.evaluator.setValue("user.securityQuestions", (Object)actionField, new String[]{"What is your pet's name?", "What is your home town?"}, null);
        Assert.assertEquals((int)actionField.user.securityQuestions.length, (int)2);
        Assert.assertEquals((String)actionField.user.securityQuestions[0], (String)"What is your pet's name?");
        Assert.assertEquals((String)actionField.user.securityQuestions[1], (String)"What is your home town?");
        this.evaluator.setValue("locales", (Object)actionField, (Object)ArrayUtils.toArray((Object[])new Locale[]{Locale.US}));
        Assert.assertEquals((int)actionField.locales.size(), (int)1);
        Assert.assertEquals((Object)actionField.locales.get(0), (Object)Locale.US);
        this.evaluator.setValue("names", (Object)actionField, (Object)ArrayUtils.toArray((Object[])new String[]{"Erlich", "Richard", "Monica"}));
        Assert.assertEquals((int)actionField.names.size(), (int)3);
        Assert.assertEquals((String)actionField.names.get(0), (String)"Erlich");
        Assert.assertEquals((String)actionField.names.get(1), (String)"Richard");
        Assert.assertEquals((String)actionField.names.get(2), (String)"Monica");
        this.evaluator.setValue("names", (Object)actionField, new ArrayList<String>(Arrays.asList("Erlich", "Richard", "Monica")));
        Assert.assertEquals((int)actionField.names.size(), (int)3);
        Assert.assertEquals((String)actionField.names.get(0), (String)"Erlich");
        Assert.assertEquals((String)actionField.names.get(1), (String)"Richard");
        Assert.assertEquals((String)actionField.names.get(2), (String)"Monica");
        this.evaluator.setValue("timeZones", (Object)actionField, (Object)ArrayUtils.toArray((Object[])new ZoneId[]{ZoneId.of("America/Denver")}));
        Assert.assertEquals((int)actionField.timeZones.size(), (int)1);
        Assert.assertEquals((Object)actionField.timeZones.get(0), (Object)ZoneId.of("America/Denver"));
        this.evaluator.setValue("timeZones", (Object)actionField, new ArrayList<ZoneId>(Collections.singletonList(ZoneId.of("America/Denver"))));
        Assert.assertEquals((int)actionField.timeZones.size(), (int)1);
        Assert.assertEquals((Object)actionField.timeZones.get(0), (Object)ZoneId.of("America/Denver"));
    }

    @Test
    public void fieldSettingWithCollectionSingleValue() {
        ActionField actionField = new ActionField();
        this.evaluator.setValue("user.name", (Object)actionField, List.of("Brian"));
        this.evaluator.setValue("user.active", (Object)actionField, (String[])ArrayUtils.toArray((Object[])new String[]{"true"}), null);
        Assert.assertEquals((String)actionField.user.name, (String)"Brian");
    }

    @Test
    public void fuzzing() {
        GenericBean genericBean = new GenericBean();
        try {
            this.evaluator.setValue("class.method", (Object)genericBean, (Object)"foo");
            Assert.fail((String)"Expected an [InvalidExpressionException] exception.");
        }
        catch (InvalidExpressionException invalidExpressionException) {
            Assert.assertEquals((String)invalidExpressionException.getMessage(), (String)"The expression string [class.method] is invalid.");
        }
        try {
            this.evaluator.getValue("class.name", (Object)genericBean);
            Assert.fail((String)"Expected an [InvalidExpressionException] exception.");
        }
        catch (InvalidExpressionException invalidExpressionException) {
            Assert.assertEquals((String)invalidExpressionException.getMessage(), (String)"The expression string [class.name] is invalid.");
        }
    }

    @Test
    public void genericInheritanceImplements() {
        GenericBean genericBean = new GenericBean();
        this.evaluator.setValue("mapSubclass['foo']", (Object)genericBean, (Object)"value");
        Assert.assertEquals((String)((String)genericBean.mapSubclass.get("foo")), (String)"value");
        this.evaluator.setValue("mapSubclass['foo']", (Object)genericBean, new String[]{"value"}, Collections.emptyMap());
        Assert.assertEquals((String)((String)genericBean.mapSubclass.get("foo")), (String)"value");
        this.evaluator.setValue("mapSubclassSubclass['foo']", (Object)genericBean, new String[]{"value"}, Collections.emptyMap());
        Assert.assertEquals((String)((String)genericBean.mapSubclassSubclass.get("foo")), (String)"value");
        this.evaluator.setValue("mapImplements['foo']", (Object)genericBean, (Object)"value");
        Assert.assertEquals((String)genericBean.mapImplements.get("foo"), (String)"value");
        this.evaluator.setValue("mapImplements['foo']", (Object)genericBean, new String[]{"value"}, Collections.emptyMap());
        Assert.assertEquals((String)genericBean.mapImplements.get("foo"), (String)"value");
    }

    @Test
    public void immutableList() {
        ActionField actionField = new ActionField();
        actionField.list = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList("value1", "value2")));
        try {
            this.evaluator.setValue("list", (Object)actionField, (Object)new String[]{"value3"});
            Assert.fail((String)"Expected this to fail!");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals(actionField.list, List.of("value1", "value2"));
        actionField.list = List.of("value1", "value2");
        try {
            this.evaluator.setValue("list", (Object)actionField, (Object)new String[]{"value3"});
            Assert.fail((String)"Expected this to fail!");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals(actionField.list, List.of("value1", "value2"));
        DefaultExpressionEvaluatorTest.configuration.allowUnknownParameters = true;
        try {
            this.evaluator.setValue("list", (Object)actionField, (Object)new String[]{"value3"});
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Assert.fail((String)"Unexpected exception", (Throwable)unsupportedOperationException);
        }
        Assert.assertEquals(actionField.list, List.of("value1", "value2"));
        actionField.list = List.of("value1", "value2");
        try {
            this.evaluator.setValue("list", (Object)actionField, (Object)new String[]{"value3"});
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Assert.fail((String)"Unexpected exception", (Throwable)unsupportedOperationException);
        }
        Assert.assertEquals(actionField.list, List.of("value1", "value2"));
    }

    @Test
    public void immutableMap() {
        ActionField actionField = new ActionField();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("key1", "value1");
        linkedHashMap.put("key2", "value2");
        actionField.map = Collections.unmodifiableMap(linkedHashMap);
        try {
            this.evaluator.setValue("map.key1", (Object)actionField, (Object)"newValue");
            Assert.fail((String)"Expected this to fail!");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((String)actionField.map.get("key1"), (String)"value1");
        actionField.map = Map.of("key1", "value1", "key2", "value2");
        try {
            this.evaluator.setValue("map.key1", (Object)actionField, (Object)"newValue");
            Assert.fail((String)"Expected this to fail!");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((String)actionField.map.get("key1"), (String)"value1");
        DefaultExpressionEvaluatorTest.configuration.allowUnknownParameters = true;
        try {
            this.evaluator.setValue("map.key1", (Object)actionField, (Object)"newValue");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Assert.fail((String)"Unexpected exception", (Throwable)unsupportedOperationException);
        }
        Assert.assertEquals((String)actionField.map.get("key1"), (String)"value1");
        actionField.map = Map.of("key1", "value1", "key2", "value2");
        try {
            this.evaluator.setValue("map.key1", (Object)actionField, (Object)"newValue");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Assert.fail((String)"Unexpected exception", (Throwable)unsupportedOperationException);
        }
        Assert.assertEquals((String)actionField.map.get("key1"), (String)"value1");
    }

    @Test
    public void longToken() {
        ActionField actionField = new ActionField();
        this.evaluator.setValue("reallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyLongFieldName", (Object)actionField, (String[])ArrayUtils.toArray((Object[])new String[]{"value"}), null);
        Assert.assertEquals((String)actionField.reallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyReallyLongFieldName, (String)"value");
    }

    @Test
    public void missingConverter() {
        CustomObject customObject = new CustomObject();
        try {
            this.evaluator.setValue("custom.value", (Object)customObject, new String[]{"foo"}, Collections.emptyMap());
            Assert.fail((String)"Expected an [ConverterStateException] exception.");
        }
        catch (ConverterStateException converterStateException) {
            Assert.assertEquals((String)converterStateException.getMessage(), (String)"While evaluating the expression [custom.value] in class [org.example.domain.CustomObject.Custom]. No type converter found for the type [java.lang.Class].");
        }
    }

    @Test
    public void nonStringKeyForMap() {
        Action action = new Action();
        action.setUser(null);
        this.evaluator.setValue("user.ids[0]", (Object)action, new String[]{"0"}, null);
        Assert.assertEquals((int)action.getUser().getIds().get(0), (int)0);
        ActionField actionField = new ActionField();
        actionField.user = null;
        this.evaluator.setValue("user.ids[0]", (Object)actionField, new String[]{"0"}, null);
        Assert.assertEquals((int)actionField.user.ids.get(0), (int)0);
    }

    @Test
    public void nullMapKeys() {
        ActionField actionField = new ActionField();
        actionField.user = new UserField();
        AddressField addressField = new AddressField();
        addressField.state = "CO";
        AddressField addressField2 = new AddressField();
        addressField2.state = "MN";
        actionField.user.addresses.put(null, addressField);
        actionField.user.addresses.put("", addressField2);
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.addresses[].state", (Object)actionField)), (String)"CO");
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.addresses[''].state", (Object)actionField)), (String)"MN");
        this.evaluator.setValue("user.addresses[].state", (Object)actionField, (Object)"MN");
        this.evaluator.setValue("user.addresses[''].state", (Object)actionField, (Object)"CO");
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.addresses[].state", (Object)actionField)), (String)"MN");
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.addresses[''].state", (Object)actionField)), (String)"CO");
    }

    @Test(enabled=false)
    public void performance() throws InterruptedException {
        int n;
        Object object = new ActionField();
        long l = System.currentTimeMillis();
        this.evaluator.setValue("user.age", object, (String[])ArrayUtils.toArray((Object[])new String[]{"32"}), null);
        long l2 = System.currentTimeMillis();
        System.out.println("Setting field time was " + (l2 - l));
        l = System.currentTimeMillis();
        this.evaluator.setValue("user.addresses['home'].zipcode", object, (String[])ArrayUtils.toArray((Object[])new String[]{"80020"}), null);
        l2 = System.currentTimeMillis();
        System.out.println("Setting field time was " + (l2 - l));
        object = new Action();
        l = System.currentTimeMillis();
        this.evaluator.setValue("user.age", object, (String[])ArrayUtils.toArray((Object[])new String[]{"32"}), null);
        l2 = System.currentTimeMillis();
        System.out.println("Setting property time was " + (l2 - l));
        l = System.currentTimeMillis();
        this.evaluator.setValue("user.addresses['home'].zipcode", object, (String[])ArrayUtils.toArray((Object[])new String[]{"80020"}), null);
        l2 = System.currentTimeMillis();
        System.out.println("Setting proeprty time was " + (l2 - l));
        object = new ActionField();
        ((ActionField)object).user = new UserField();
        ((ActionField)object).user.age = 10;
        l = System.currentTimeMillis();
        this.evaluator.getValue("user.age", object);
        l2 = System.currentTimeMillis();
        System.out.println("Getting field time was " + (l2 - l));
        ((ActionField)object).user = new UserField();
        ((ActionField)object).user.addresses.put("home", new AddressField());
        ((ActionField)object).user.addresses.get((Object)"home").zipcode = "80020";
        l = System.currentTimeMillis();
        this.evaluator.getValue("user.addresses['home'].zipcode", object);
        l2 = System.currentTimeMillis();
        System.out.println("Getting field time was " + (l2 - l));
        object = new Action();
        ((Action)object).setUser(new User());
        ((Action)object).getUser().setAge(10);
        l = System.currentTimeMillis();
        this.evaluator.getValue("user.age", object);
        l2 = System.currentTimeMillis();
        System.out.println("Getting property time was " + (l2 - l));
        ((Action)object).setUser(new User());
        ((Action)object).getUser().getAddresses().put("home", new Address());
        ((Action)object).getUser().getAddresses().get("home").setZipcode("80020");
        l = System.currentTimeMillis();
        this.evaluator.getValue("user.addresses['home'].zipcode", object);
        l2 = System.currentTimeMillis();
        System.out.println("Getting property time was " + (l2 - l));
        object = new ActionField();
        ((ActionField)object).user = new UserField();
        ((ActionField)object).user.addresses.put("home", new AddressField());
        ((ActionField)object).user.addresses.get((Object)"home").zipcode = "80020";
        l = System.currentTimeMillis();
        for (int i = 0; i < 50; ++i) {
            this.evaluator.getValue("user.addresses['home'].zipcode", object);
        }
        l2 = System.currentTimeMillis();
        System.out.println("50 times was " + (l2 - l));
        JCThread[] jCThreadArray = new JCThread[50];
        for (n = 0; n < 50; ++n) {
            jCThreadArray[n] = new JCThread();
            jCThreadArray[n].setName("" + n);
            jCThreadArray[n].start();
        }
        for (n = 0; n < 50; ++n) {
            jCThreadArray[n].join();
        }
    }

    @Test
    public void propertyGetting() {
        Action action = new Action();
        Assert.assertNull((Object)this.evaluator.getValue("user", (Object)action));
        User user = new User();
        action.setUser(user);
        Assert.assertSame((Object)user, (Object)this.evaluator.getValue("user", (Object)action));
        action.getUser().setAge(32);
        action.getUser().setName("Brian");
        action.getUser().setActive(true);
        Assert.assertEquals((Integer)((Integer)this.evaluator.getValue("user.age", (Object)action)), (Integer)32);
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.name", (Object)action)), (String)"Brian");
        Assert.assertTrue((boolean)((Boolean)this.evaluator.getValue("user.active", (Object)action)));
        Address address = new Address();
        address.setCity("Broomfield");
        address.setState("CO");
        address.setStreet("Test");
        address.setZipcode("80020");
        action.getUser().getAddresses().put("home", address);
        Assert.assertNull((Object)this.evaluator.getValue("user.addresses['work']", (Object)action));
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.addresses['home'].city", (Object)action)), (String)"Broomfield");
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.addresses['home'].state", (Object)action)), (String)"CO");
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.addresses['home'].street", (Object)action)), (String)"Test");
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.addresses['home'].zipcode", (Object)action)), (String)"80020");
        action.getUser().getAddresses().put("summer home", address);
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.addresses['summer home'].city", (Object)action)), (String)"Broomfield");
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.addresses['summer home'].state", (Object)action)), (String)"CO");
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.addresses['summer home'].street", (Object)action)), (String)"Test");
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.addresses['summer home'].zipcode", (Object)action)), (String)"80020");
        User user2 = new User();
        user2.setName("Brett");
        user2.setAge(34);
        user.getSiblings().add(user2);
        Assert.assertEquals((Integer)((Integer)this.evaluator.getValue("user.siblings[0].age", (Object)action)), (Integer)34);
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.siblings[0].name", (Object)action)), (String)"Brett");
        user.setSecurityQuestions("What is your pet's name?", "What is your home town?");
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.securityQuestions[0]", (Object)action)), (String)"What is your pet's name?");
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.securityQuestions[1]", (Object)action)), (String)"What is your home town?");
        Assert.assertNull((Object)this.evaluator.getValue("user.address['work']", (Object)action));
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.address['home'].city", (Object)action)), (String)"Broomfield");
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.address['home'].state", (Object)action)), (String)"CO");
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.address['home'].street", (Object)action)), (String)"Test");
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.address['home'].zipcode", (Object)action)), (String)"80020");
        Assert.assertEquals((Integer)((Integer)this.evaluator.getValue("user.sibling[0].age", (Object)action)), (Integer)34);
        Assert.assertEquals((String)((String)this.evaluator.getValue("user.sibling[0].name", (Object)action)), (String)"Brett");
    }

    @Test
    public void propertyGettingAndSettingInUnwrappedField() {
        NestedDataUnwrappedAction nestedDataUnwrappedAction = new NestedDataUnwrappedAction();
        nestedDataUnwrappedAction.bean1.data1.bar = "bing";
        nestedDataUnwrappedAction.bean1.data1.baz = "boom";
        Assert.assertEquals((String)((String)this.evaluator.getValue("bean1.bar", (Object)nestedDataUnwrappedAction)), (String)"bing");
        Assert.assertEquals((String)((String)this.evaluator.getValue("bean1.baz", (Object)nestedDataUnwrappedAction)), (String)"boom");
        nestedDataUnwrappedAction.bean3.bing = "kabam";
        Assert.assertEquals((String)((String)this.evaluator.getValue("bing", (Object)nestedDataUnwrappedAction)), (String)"kabam");
        nestedDataUnwrappedAction.bean4.bam = "kapow";
        Assert.assertEquals((String)((String)this.evaluator.getValue("bam", (Object)nestedDataUnwrappedAction)), (String)"kapow");
        this.evaluator.setValue("bean1.bar", (Object)nestedDataUnwrappedAction, (String[])ArrayUtils.toArray((Object[])new String[]{"bada-bing"}), null);
        this.evaluator.setValue("bean1.baz", (Object)nestedDataUnwrappedAction, (String[])ArrayUtils.toArray((Object[])new String[]{"bada-boom"}), null);
        Assert.assertEquals((String)((String)this.evaluator.getValue("bean1.bar", (Object)nestedDataUnwrappedAction)), (String)"bada-bing");
        Assert.assertEquals((String)((String)this.evaluator.getValue("bean1.baz", (Object)nestedDataUnwrappedAction)), (String)"bada-boom");
        Assert.assertNull((Object)this.evaluator.getValue("bean2.user", (Object)nestedDataUnwrappedAction));
        Assert.assertNull((Object)this.evaluator.getValue("bean2.user.name", (Object)nestedDataUnwrappedAction));
        Assert.assertNull((Object)this.evaluator.getValue("bean2.bar", (Object)nestedDataUnwrappedAction));
        Assert.assertNull((Object)this.evaluator.getValue("bean2.baz", (Object)nestedDataUnwrappedAction));
        this.evaluator.setValue("bean2.user.name", (Object)nestedDataUnwrappedAction, (String[])ArrayUtils.toArray((Object[])new String[]{"Art Vandelay"}), null);
        this.evaluator.setValue("bean2.bar", (Object)nestedDataUnwrappedAction, (String[])ArrayUtils.toArray((Object[])new String[]{"bing"}), null);
        this.evaluator.setValue("bean2.baz", (Object)nestedDataUnwrappedAction, (String[])ArrayUtils.toArray((Object[])new String[]{"boom"}), null);
        Assert.assertEquals((String)((String)this.evaluator.getValue("bean2.user.name", (Object)nestedDataUnwrappedAction)), (String)"Art Vandelay");
        Assert.assertEquals((String)((String)this.evaluator.getValue("bean2.bar", (Object)nestedDataUnwrappedAction)), (String)"bing");
        Assert.assertEquals((String)((String)this.evaluator.getValue("bean2.baz", (Object)nestedDataUnwrappedAction)), (String)"boom");
        this.evaluator.setValue("bing", (Object)nestedDataUnwrappedAction, (String[])ArrayUtils.toArray((Object[])new String[]{"Art Vandelay"}), null);
        Assert.assertEquals((String)((String)this.evaluator.getValue("bing", (Object)nestedDataUnwrappedAction)), (String)"Art Vandelay");
        this.evaluator.setValue("bam", (Object)nestedDataUnwrappedAction, (String[])ArrayUtils.toArray((Object[])new String[]{"Art Vandelay"}), null);
        Assert.assertEquals((String)((String)this.evaluator.getValue("bam", (Object)nestedDataUnwrappedAction)), (String)"Art Vandelay");
        try {
            this.evaluator.setValue("womp", (Object)nestedDataUnwrappedAction, (String[])ArrayUtils.toArray((Object[])new String[]{"Art Vandelay"}), null);
            Assert.assertEquals((String)((String)this.evaluator.getValue("womp", (Object)nestedDataUnwrappedAction)), (String)"Art Vandelay");
            Assert.fail((String)"This should not happen - this is failing, it would be nice if it did not. But it may be a large change.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void propertySetting() {
        Action action = new Action();
        action.setUser(null);
        this.evaluator.setValue("user.age", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"32"}), null);
        this.evaluator.setValue("user.name", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"Brian"}), null);
        this.evaluator.setValue("user.active", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"true"}), null);
        this.evaluator.setValue("user.male", (Object)action, null, null);
        Assert.assertEquals((Integer)action.getUser().getAge(), (Integer)32);
        Assert.assertEquals((String)action.getUser().getName(), (String)"Brian");
        Assert.assertTrue((boolean)action.getUser().isActive());
        Assert.assertFalse((boolean)action.getUser().isMale());
        action.getUser().setAddresses(null);
        this.evaluator.setValue("user.addresses['home'].city", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"Broomfield"}), null);
        this.evaluator.setValue("user.addresses['home'].state", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"CO"}), null);
        this.evaluator.setValue("user.addresses['home'].street", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"Test"}), null);
        this.evaluator.setValue("user.addresses['home'].zipcode", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"80020"}), null);
        Assert.assertEquals((int)action.getUser().getAddresses().size(), (int)1);
        Assert.assertNull((Object)action.getUser().getAddresses().get("work"));
        Assert.assertEquals((String)action.getUser().getAddresses().get("home").getCity(), (String)"Broomfield");
        Assert.assertEquals((String)action.getUser().getAddresses().get("home").getState(), (String)"CO");
        Assert.assertEquals((String)action.getUser().getAddresses().get("home").getStreet(), (String)"Test");
        Assert.assertEquals((String)action.getUser().getAddresses().get("home").getZipcode(), (String)"80020");
        action.getUser().setAddresses(null);
        this.evaluator.setValue("user.addresses.home.city", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"Broomfield"}), null);
        this.evaluator.setValue("user.addresses.home.state", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"CO"}), null);
        this.evaluator.setValue("user.addresses.home.street", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"Test"}), null);
        this.evaluator.setValue("user.addresses.home.zipcode", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"80020"}), null);
        Assert.assertEquals((int)action.getUser().getAddresses().size(), (int)1);
        Assert.assertNull((Object)action.getUser().getAddresses().get("work"));
        Assert.assertEquals((String)action.getUser().getAddresses().get("home").getCity(), (String)"Broomfield");
        Assert.assertEquals((String)action.getUser().getAddresses().get("home").getState(), (String)"CO");
        Assert.assertEquals((String)action.getUser().getAddresses().get("home").getStreet(), (String)"Test");
        Assert.assertEquals((String)action.getUser().getAddresses().get("home").getZipcode(), (String)"80020");
        this.evaluator.setValue("user.addresses['home'].zipcode", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{""}), null);
        Assert.assertNull((Object)action.getUser().getAddresses().get("home").getZipcode());
        this.evaluator.setValue("user.addresses[].zipcode", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"80020"}), null);
        Assert.assertEquals((String)action.getUser().getAddresses().get(null).getZipcode(), (String)"80020");
        this.evaluator.setValue("user.addresses[''].zipcode", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"80020"}), null);
        Assert.assertEquals((String)action.getUser().getAddresses().get(null).getZipcode(), (String)"80020");
        action.getUser().setSiblings(null);
        this.evaluator.setValue("user.siblings[0].age", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"34"}), null);
        this.evaluator.setValue("user.siblings[0].name", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"Brett"}), null);
        Assert.assertTrue((boolean)(action.getUser().getSiblings() instanceof ArrayList));
        Assert.assertEquals((int)action.getUser().getSiblings().size(), (int)1);
        Assert.assertEquals((Integer)action.getUser().getSiblings().get(0).getAge(), (Integer)34);
        Assert.assertEquals((String)action.getUser().getSiblings().get(0).getName(), (String)"Brett");
        this.evaluator.setValue("user.securityQuestions[0]", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"What is your pet's name?"}), null);
        this.evaluator.setValue("user.securityQuestions[1]", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"What is your home town?"}), null);
        Assert.assertEquals((int)action.getUser().getSecurityQuestions().length, (int)2);
        Assert.assertEquals((String)action.getUser().getSecurityQuestions()[0], (String)"What is your pet's name?");
        Assert.assertEquals((String)action.getUser().getSecurityQuestions()[1], (String)"What is your home town?");
        action.getUser().setSecurityQuestions(new String[0]);
        this.evaluator.setValue("user.securityQuestions", (Object)action, new String[]{"What is your pet's name?", "What is your home town?"}, null);
        Assert.assertEquals((String)action.getUser().getSecurityQuestions()[0], (String)"What is your pet's name?");
        Assert.assertEquals((String)action.getUser().getSecurityQuestions()[1], (String)"What is your home town?");
        action.getUser().setAddresses(new HashMap<String, Address>());
        this.evaluator.setValue("user.address['home'].city", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"Broomfield"}), null);
        this.evaluator.setValue("user.address['home'].state", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"CO"}), null);
        this.evaluator.setValue("user.address['home'].street", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"Test"}), null);
        this.evaluator.setValue("user.address['home'].zipcode", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"80020"}), null);
        Assert.assertEquals((int)action.getUser().getAddresses().size(), (int)1);
        Assert.assertNull((Object)action.getUser().getAddresses().get("work"));
        Assert.assertEquals((String)action.getUser().getAddresses().get("home").getCity(), (String)"Broomfield");
        Assert.assertEquals((String)action.getUser().getAddresses().get("home").getState(), (String)"CO");
        Assert.assertEquals((String)action.getUser().getAddresses().get("home").getStreet(), (String)"Test");
        Assert.assertEquals((String)action.getUser().getAddresses().get("home").getZipcode(), (String)"80020");
        action.getUser().setSiblings(new ArrayList<User>());
        this.evaluator.setValue("user.sibling[0].age", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"34"}), null);
        this.evaluator.setValue("user.sibling[0].name", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"Brett"}), null);
        Assert.assertEquals((int)action.getUser().getSiblings().size(), (int)1);
        Assert.assertEquals((Integer)action.getUser().getSiblings().get(0).getAge(), (Integer)34);
        Assert.assertEquals((String)action.getUser().getSiblings().get(0).getName(), (String)"Brett");
        this.evaluator.setValue("roleIds", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"1", "2", "3"}), null);
        this.evaluator.setValue("choices['ids']", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"1", "2", "3"}), null);
        Assert.assertEquals((int)action.getRoleIds().length, (int)3);
        Assert.assertEquals((int)action.getRoleIds()[0], (int)1);
        Assert.assertEquals((int)action.getRoleIds()[1], (int)2);
        Assert.assertEquals((int)action.getRoleIds()[2], (int)3);
        Assert.assertEquals((int)action.getChoices().get("ids").size(), (int)3);
        Assert.assertEquals((int)action.getChoices().get("ids").get(0), (int)1);
        Assert.assertEquals((int)action.getChoices().get("ids").get(1), (int)2);
        Assert.assertEquals((int)action.getChoices().get("ids").get(2), (int)3);
        this.evaluator.setValue("associations['ids']", (Object)action, (String[])ArrayUtils.toArray((Object[])new String[]{"1", "2", "3"}), null);
        Assert.assertEquals((int)action.getAssociations().get("ids").length, (int)3);
        Assert.assertEquals((int)action.getAssociations().get("ids")[0], (int)1);
        Assert.assertEquals((int)action.getAssociations().get("ids")[1], (int)2);
        Assert.assertEquals((int)action.getAssociations().get("ids")[2], (int)3);
    }

    @Inject
    public void setEvaluator(DefaultExpressionEvaluator defaultExpressionEvaluator) {
        this.evaluator = defaultExpressionEvaluator;
    }

    public class JCThread
    extends Thread {
        @Override
        public void run() {
            ActionField actionField = new ActionField();
            actionField.user = new UserField();
            actionField.user.addresses.put("home", new AddressField());
            actionField.user.addresses.get((Object)"home").zipcode = "80020";
            long l = System.currentTimeMillis();
            for (int i = 0; i < 50000; ++i) {
                DefaultExpressionEvaluatorTest.this.evaluator.getValue("user.addresses['home'].zipcode", (Object)actionField);
            }
            long l2 = System.currentTimeMillis();
            System.out.println("50000 times for " + this.getName() + " was " + (l2 - l) + " should be around 6500ms");
        }
    }
}

