/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import java.time.LocalDate;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.primeframework.mvc.MockConfiguration;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.GlobalConverter;
import org.primeframework.mvc.parameter.convert.converters.LocalDateConverter;
import org.primeframework.mvc.util.MapBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LocalDateConverterTest
extends PrimeBaseTest {
    @Test
    public void fromStrings() {
        LocalDateConverter localDateConverter = new LocalDateConverter((MVCConfiguration)new MockConfiguration());
        LocalDate localDate = (LocalDate)localDateConverter.convertFromStrings(LocalDate.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}));
        Assert.assertNull((Object)localDate);
        localDate = (LocalDate)localDateConverter.convertFromStrings(Locale.class, MapBuilder.asMap((Object[])new String[]{"dateTimeFormat", "MM-dd-yyyy"}), "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"07-08-2008"}));
        Assert.assertEquals((int)localDate.getMonthValue(), (int)7);
        Assert.assertEquals((int)localDate.getDayOfMonth(), (int)8);
        Assert.assertEquals((int)localDate.getYear(), (int)2008);
        LocalDateConverterTest.expectException(ConversionException.class, () -> LocalDateConverterTest.lambda$fromStrings$0((GlobalConverter)localDateConverter));
        localDateConverter.convertFromStrings(Locale.class, MapBuilder.asMap((Object[])new String[]{"dateTimeFormat", "[MM-dd-yyyy][MM/dd/yyyy]"}), "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"07-08-2008"}));
        localDateConverter.convertFromStrings(Locale.class, MapBuilder.asMap((Object[])new String[]{"dateTimeFormat", "[MM-dd-yyyy][MM/dd/yyyy]"}), "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"07/08/2008"}));
        LocalDateConverterTest.expectException(ConversionException.class, () -> LocalDateConverterTest.lambda$fromStrings$1((GlobalConverter)localDateConverter));
    }

    @Test
    public void toStrings() {
        LocalDateConverter localDateConverter = new LocalDateConverter((MVCConfiguration)new MockConfiguration());
        String string = localDateConverter.convertToString(LocalDate.class, null, "testExpr", null);
        Assert.assertNull((Object)string);
        string = localDateConverter.convertToString(LocalDate.class, MapBuilder.asMap((Object[])new String[]{"dateTimeFormat", "MM-dd-yyyy"}), "testExpr", (Object)LocalDate.of(2008, 7, 8));
        Assert.assertEquals((String)string, (String)"07-08-2008");
        string = localDateConverter.convertToString(LocalDate.class, MapBuilder.asMap((Object[])new String[]{"dateTimeFormat", "[MM-dd-yyyy][MM/dd/yyyy]"}), "testExpr", (Object)LocalDate.of(2008, 7, 8));
        Assert.assertEquals((String)string, (String)"07-08-2008");
        string = localDateConverter.convertToString(LocalDate.class, MapBuilder.asMap((Object[])new String[]{"dateTimeFormat", "[MM/dd/yyyy][MM-dd-yyyy]"}), "testExpr", (Object)LocalDate.of(2008, 7, 8));
        Assert.assertEquals((String)string, (String)"07/08/2008");
    }

    private static /* synthetic */ void lambda$fromStrings$1(GlobalConverter globalConverter) throws Exception {
        globalConverter.convertFromStrings(Locale.class, MapBuilder.asMap((Object[])new String[]{"dateTimeFormat", "[MM-dd-yyyy][MM/dd/yyyy]"}), "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"07_08_2008"}));
    }

    private static /* synthetic */ void lambda$fromStrings$0(GlobalConverter globalConverter) throws Exception {
        globalConverter.convertFromStrings(Locale.class, MapBuilder.asMap((Object[])new String[]{"dateTimeFormat", "MM-dd-yyyy"}), "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"07/08/2008"}));
    }
}

