/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.form;

import com.google.inject.Inject;
import org.example.action.user.EditAction;
import org.example.domain.User;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.control.Control;
import org.primeframework.mvc.control.ControlBaseTest;
import org.primeframework.mvc.control.form.NumberInput;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleFieldMessage;
import org.testng.annotations.Test;

public class NumberInputTest
extends ControlBaseTest {
    @Inject
    public NumberInput number;

    @Test
    public void action() {
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setAge(42);
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/number", null, null));
        new ControlBaseTest.ControlTester((Control)this.number).attr("name", "user.age").go("<input type=\"hidden\" name=\"user.age@param\" value=\"param-value\"/>\n<div class=\"text input control\">\n<div class=\"label-container\"><label for=\"user_age\" class=\"label\">Your age</label></div>\n<div class=\"control-container\"><input type=\"number\" id=\"user_age\" name=\"user.age\" value=\"42\"/></div>\n</div>\n");
    }

    @Test
    public void actionLess() {
        this.ais.setCurrent(new ActionInvocation(null, null, "/number", null, null));
        new ControlBaseTest.ControlTester((Control)this.number).attr("name", "test").attr("class", "css-class").go("<input type=\"hidden\" name=\"test@param\" value=\"param-value\"/>\n<div class=\"css-class-text css-class-input css-class-control text input control\">\n<div class=\"label-container\"><label for=\"test\" class=\"label\">Test</label></div>\n<div class=\"control-container\"><input type=\"number\" class=\"css-class\" id=\"test\" name=\"test\"/></div>\n</div>\n");
    }

    @Test
    public void defaultValue() {
        EditAction editAction = new EditAction();
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/number", null, null));
        new ControlBaseTest.ControlTester((Control)this.number).attr("name", "user.age").attr("defaultValue", "0").go("<input type=\"hidden\" name=\"user.age@param\" value=\"param-value\"/>\n<div class=\"text input control\">\n<div class=\"label-container\"><label for=\"user_age\" class=\"label\">Your age</label></div>\n<div class=\"control-container\"><input type=\"number\" id=\"user_age\" name=\"user.age\" value=\"0\"/></div>\n</div>\n");
    }

    @Test
    public void fieldErrors() {
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setAge(42);
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/number", null, null));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "user.age", "code1", "fieldError1"));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "user.age", "code2", "fieldError2"));
        new ControlBaseTest.ControlTester((Control)this.number).attr("name", "user.age").go("<input type=\"hidden\" name=\"user.age@param\" value=\"param-value\"/>\n<div class=\"text input control\">\n<div class=\"label-container\"><label for=\"user_age\" class=\"label\"><span class=\"error\">Your age (fieldError1, fieldError2)</span></label></div>\n<div class=\"control-container\"><input type=\"number\" id=\"user_age\" name=\"user.age\" value=\"42\"/></div>\n</div>\n");
    }

    @Test
    public void labelKey() {
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setAge(42);
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/number", null, null));
        new ControlBaseTest.ControlTester((Control)this.number).attr("name", "user.age").attr("labelKey", "label-key").go("<input type=\"hidden\" name=\"user.age@param\" value=\"param-value\"/>\n<div class=\"text input control\">\n<div class=\"label-container\"><label for=\"user_age\" class=\"label\">Foo bar</label></div>\n<div class=\"control-container\"><input type=\"number\" id=\"user_age\" name=\"user.age\" value=\"42\"/></div>\n</div>\n");
    }
}

