/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.form;

import com.google.inject.Inject;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.example.action.user.EditAction;
import org.example.domain.Address;
import org.example.domain.User;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.control.Control;
import org.primeframework.mvc.control.ControlBaseTest;
import org.primeframework.mvc.control.form.CheckboxList;
import org.primeframework.mvc.control.form.Pair;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleFieldMessage;
import org.primeframework.mvc.util.MapBuilder;
import org.testng.annotations.Test;

public class CheckboxListTest
extends ControlBaseTest {
    @Inject
    public CheckboxList checkboxList;

    @Test
    public void action() {
        Address address = new Address();
        address.setCountry("US");
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setAddress("work", address);
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/checkbox-list", null, null));
        new ControlBaseTest.ControlTester((Control)this.checkboxList).attr("name", "user.addresses['work'].country").attr("items", MapBuilder.lmap((Object[])new String[]{"US", "United States", "DE", "Germany"})).go("<input type=\"hidden\" name=\"user.addresses[&#39;work&#39;].country@param\" value=\"param-value\"/>\n<div class=\"checkbox-list input control\">\n<div class=\"label-container\"><label for=\"user_addresses[&#39;work&#39;]_country\" class=\"label\">Country</label></div>\n<div class=\"control-container\">\n<div class=\"control-item-container\">\n<input type=\"checkbox\" checked=\"checked\" value=\"US\" name=\"user.addresses[&#39;work&#39;].country\"/><span class=\"checkbox-text\">United States</span>\n</div>\n<div class=\"control-item-container\">\n<input type=\"checkbox\" value=\"DE\" name=\"user.addresses[&#39;work&#39;].country\"/><span class=\"checkbox-text\">Germany</span>\n</div>\n</div>\n</div>\n");
    }

    @Test
    public void actionLess() {
        this.ais.setCurrent(new ActionInvocation(null, null, "/checkbox-list", null, null));
        new ControlBaseTest.ControlTester((Control)this.checkboxList).attr("name", "test").attr("class", "css-class").attr("items", Arrays.asList("one", "two", "three")).go("<input type=\"hidden\" name=\"test@param\" value=\"param-value\"/>\n<div class=\"css-class-checkbox-list css-class-input css-class-control checkbox-list input control\">\n<div class=\"label-container\"><label for=\"test\" class=\"label\">Test</label></div>\n<div class=\"control-container\">\n<div class=\"control-item-container\">\n<input type=\"checkbox\" value=\"one\" class=\"css-class\" name=\"test\"/><span class=\"checkbox-text\">one</span>\n</div>\n<div class=\"control-item-container\">\n<input type=\"checkbox\" value=\"two\" class=\"css-class\" name=\"test\"/><span class=\"checkbox-text\">two</span>\n</div>\n<div class=\"control-item-container\">\n<input type=\"checkbox\" value=\"three\" class=\"css-class\" name=\"test\"/><span class=\"checkbox-text\">three</span>\n</div>\n</div>\n</div>\n");
    }

    @Test
    public void expressions() {
        Address address = new Address();
        address.setCountry("US");
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setAddress("work", address);
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/checkbox-list", null, null));
        Pair pair = new Pair("US", "United States");
        Pair pair2 = new Pair("DE", "Germany");
        new ControlBaseTest.ControlTester((Control)this.checkboxList).attr("name", "user.addresses['work'].country").attr("valueExpr", "left").attr("textExpr", "right").attr("items", ArrayUtils.toArray((Object[])new Pair[]{pair, pair2})).go("<input type=\"hidden\" name=\"user.addresses[&#39;work&#39;].country@param\" value=\"param-value\"/>\n<div class=\"checkbox-list input control\">\n<div class=\"label-container\"><label for=\"user_addresses[&#39;work&#39;]_country\" class=\"label\">Country</label></div>\n<div class=\"control-container\">\n<div class=\"control-item-container\">\n<input type=\"checkbox\" checked=\"checked\" value=\"US\" name=\"user.addresses[&#39;work&#39;].country\"/><span class=\"checkbox-text\">United States</span>\n</div>\n<div class=\"control-item-container\">\n<input type=\"checkbox\" value=\"DE\" name=\"user.addresses[&#39;work&#39;].country\"/><span class=\"checkbox-text\">Germany</span>\n</div>\n</div>\n</div>\n");
    }

    @Test
    public void fieldErrors() {
        Address address = new Address();
        address.setCountry("US");
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setAddress("work", address);
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/checkbox-list", null, null));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "user.addresses['work'].country", "code1", "Country is required"));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "user.addresses['work'].country", "code2", "Country must be cool"));
        new ControlBaseTest.ControlTester((Control)this.checkboxList).attr("name", "user.addresses['work'].country").attr("items", MapBuilder.lmap((Object[])new String[]{"US", "United States", "DE", "Germany"})).go("<input type=\"hidden\" name=\"user.addresses[&#39;work&#39;].country@param\" value=\"param-value\"/>\n<div class=\"checkbox-list input control\">\n<div class=\"label-container\"><label for=\"user_addresses[&#39;work&#39;]_country\" class=\"label\"><span class=\"error\">Country (Country is required, Country must be cool)</span></label></div>\n<div class=\"control-container\">\n<div class=\"control-item-container\">\n<input type=\"checkbox\" checked=\"checked\" value=\"US\" name=\"user.addresses[&#39;work&#39;].country\"/><span class=\"checkbox-text\">United States</span>\n</div>\n<div class=\"control-item-container\">\n<input type=\"checkbox\" value=\"DE\" name=\"user.addresses[&#39;work&#39;].country\"/><span class=\"checkbox-text\">Germany</span>\n</div>\n</div>\n</div>\n");
    }

    @Test
    public void html() {
        Address address = new Address();
        address.setCountry("<US>");
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setAddress("work", address);
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/checkbox-list", null, null));
        new ControlBaseTest.ControlTester((Control)this.checkboxList).attr("name", "user.addresses['work'].country").attr("items", MapBuilder.lmap((Object[])new String[]{"<US>", "<United States>", "DE", "Germany"})).go("<input type=\"hidden\" name=\"user.addresses[&#39;work&#39;].country@param\" value=\"param-value\"/>\n<div class=\"checkbox-list input control\">\n<div class=\"label-container\"><label for=\"user_addresses[&#39;work&#39;]_country\" class=\"label\">Country</label></div>\n<div class=\"control-container\">\n<div class=\"control-item-container\">\n<input type=\"checkbox\" checked=\"checked\" value=\"&lt;US&gt;\" name=\"user.addresses[&#39;work&#39;].country\"/><span class=\"checkbox-text\">&lt;United States&gt;</span>\n</div>\n<div class=\"control-item-container\">\n<input type=\"checkbox\" value=\"DE\" name=\"user.addresses[&#39;work&#39;].country\"/><span class=\"checkbox-text\">Germany</span>\n</div>\n</div>\n</div>\n");
    }
}

