/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import java.nio.file.Path;
import java.util.ArrayList;
import org.example.action.patch.PatchActionRequest;
import org.example.action.patch.TestAction;
import org.primeframework.mvc.PrimeBaseTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JSONPatchTest
extends PrimeBaseTest {
    private Path jsonDir;

    @BeforeClass
    public void beforeClass() {
        this.jsonDir = Path.of("src/test/resources/json", new String[0]);
    }

    @Override
    @BeforeMethod
    public void beforeMethod() {
        super.beforeMethod();
        TestAction.db = null;
    }

    @Test
    public void json_patch_rfc6902() throws Exception {
        TestAction.db = new PatchActionRequest.CoolObject();
        TestAction.db.email = "jim@example.com";
        TestAction.db.name = "Jim Bob";
        TestAction.db.addresses = new ArrayList<PatchActionRequest.Address>();
        this.test.simulate(() -> simulator.test("/patch/test-disabled").withContentType("application/json-patch+json").withBody("[\n  {\n    \"op\": \"replace\",\n    \"path\": \"/data/email\",\n    \"value\": \"robotdan@fusionauth.io\"\n  }\n]\n").patch().assertStatusCode(400).assertJSON("{\n  \"fieldErrors\" : { },\n  \"generalErrors\" : [ {\n    \"code\" : \"[PatchNotSupported]\",\n    \"message\" : \"The [Content-Type] HTTP request header value of [application/json-patch+json] is not supported for this request.\"\n  } ]\n}\n"));
        this.test.simulate(() -> simulator.test("/patch/test").withContentType("application/json-patch+json").withBody("[\n  {\n    \"op\": \"replace\",\n    \"path\": \"/data/email\",\n    \"value\": \"robotdan@fusionauth.io\"\n  }\n]\n").patch().assertStatusCode(200).assertJSON("{\n  \"data\" : {\n    \"addresses\" : [ ],\n    \"email\" : \"robotdan@fusionauth.io\",\n    \"name\" : \"Jim Bob\"\n  }\n}\n")).simulate(() -> simulator.test("/patch/test").withContentType("application/json-patch+json").withBody("[\n  {\n    \"op\": \"remove\",\n    \"path\": \"/data/email\"\n  }\n]\n").patch().assertStatusCode(200).assertJSON("{\n  \"data\" : {\n    \"addresses\" : [ ],\n    \"name\" : \"Jim Bob\"\n  }\n}\n")).simulate(() -> simulator.test("/patch/test").withContentType("application/json-patch+json").withBody("[\n  {\n    \"op\": \"add\",\n    \"path\": \"/data/email\",\n    \"value\": \"robotdan@fusionauth.io\"\n  }\n]\n").patch().assertStatusCode(200).assertJSON(" {\n  \"data\" : {\n    \"addresses\" : [ ],\n    \"email\" : \"robotdan@fusionauth.io\",\n    \"name\" : \"Jim Bob\"\n  }\n}\n")).simulate(() -> simulator.test("/patch/test").withContentType("application/json-patch+json").withBody("[\n  {\n    \"op\": \"test\",\n    \"path\": \"/data/email\",\n    \"value\": \"jim@example.com\"\n  }\n]\n").patch().assertStatusCode(200).assertJSON(" {\n  \"data\" : {\n    \"addresses\" : [ ],\n    \"email\" : \"jim@example.com\",\n    \"name\" : \"Jim Bob\"\n  }\n}\n")).simulate(() -> simulator.test("/patch/test").withContentType("application/json-patch+json").withBody("[\n  {\n    \"op\": \"test\",\n    \"path\": \"/data/email\",\n    \"value\": \"james@example.com\"\n  }\n]\n").patch().assertStatusCode(400).assertJSON("{\n  \"fieldErrors\" : { },\n  \"generalErrors\" : [ {\n    \"code\" : \"[JSONPatchTestFailed]\",\n    \"message\" : \"A requested test operation has failed. The value is not equal to the expected value. No changes were made to the requested resource.\"\n  } ]\n}\n"));
    }

    @Test(enabled=false)
    public void json_patch_rfc6902_SCIM_patch() throws Exception {
        TestAction.db = new PatchActionRequest.CoolObject();
        TestAction.db.email = "jim@example.com";
        TestAction.db.name = "Jim Bob";
        TestAction.db.addresses = new ArrayList<PatchActionRequest.Address>();
        TestAction.db.addresses.add(new PatchActionRequest.Address());
        TestAction.db.addresses.get((int)0).city = "Denver";
        TestAction.db.addresses.get((int)0).state = "CO";
        TestAction.db.addresses.get((int)0).zipCode = 80202;
        TestAction.db.addresses.get((int)0).type = "work";
        this.test.simulate(() -> simulator.test("/patch/test").withContentType("application/json-patch+json").withBody("[\n  {\n    \"op\": \"replace\",\n    \"path\": \"/data/addresses[type eq \\\"work\\\"].city\",\n    \"value\": \"Broomfield\"\n  },\n  {\n    \"op\": \"replace\",\n    \"path\": \"/data/addresses[type eq \\\"work\\\"].zipcode\",\n    \"value\": 80021\n  }\n]\n").patch().assertStatusCode(200).assertJSON("{\n  \"data\" : {\n    \"addresses\" : [ {\n      \"city\" : \"Broomfield\",\n      \"state\" : \"CO\",\n      \"type\" : \"work\",\n      \"zipCode\" : 80021\n    } ],\n    \"email\" : \"robotdan@fusionauth.io\",\n    \"name\" : \"Jim Bob\"\n  }\n}\n"));
    }

    @Test
    public void json_patch_rfc7386() throws Exception {
        TestAction.db = new PatchActionRequest.CoolObject();
        TestAction.db.email = "jim@example.com";
        TestAction.db.name = "Jim Bob";
        TestAction.db.addresses = new ArrayList<PatchActionRequest.Address>();
        this.test.simulate(() -> simulator.test("/patch/test-disabled").withContentType("application/merge-patch+json").withBody("[\n  {\n    \"op\": \"replace\",\n    \"path\": \"/data/email\",\n    \"value\": \"robotdan@fusionauth.io\"\n  }\n]\n").patch().assertStatusCode(400).assertJSON("{\n  \"fieldErrors\" : { },\n  \"generalErrors\" : [ {\n    \"code\" : \"[PatchNotSupported]\",\n    \"message\" : \"The [Content-Type] HTTP request header value of [application/merge-patch+json] is not supported for this request.\"\n  } ]\n}\n"));
        this.test.simulate(() -> simulator.test("/patch/test").withContentType("application/merge-patch+json").withBody("{\n   \"data\" : {\n     \"email\" : \"robotdan@fusionauth.io\"\n   }\n }\n").patch().assertStatusCode(200).assertJSON("{\n  \"data\" : {\n    \"addresses\" : [ ],\n    \"email\" : \"robotdan@fusionauth.io\",\n    \"name\" : \"Jim Bob\"\n  }\n}\n")).simulate(() -> simulator.test("/patch/test").withContentType("application/merge-patch+json").withBody("  {\n    \"data\" : {\n      \"email\" : null\n    }\n  }\n").patch().assertStatusCode(200).assertJSON("{\n  \"data\" : {\n    \"addresses\" : [ ],\n    \"name\" : \"Jim Bob\"\n  }\n}\n")).simulate(() -> simulator.test("/patch/test").withContentType("application/merge-patch+json").withBody("{\n   \"data\" : {\n     \"email\" : \"robotdan@fusionauth.io\"\n   }\n }\n").patch().assertStatusCode(200).assertJSON(" {\n  \"data\" : {\n    \"addresses\" : [ ],\n    \"email\" : \"robotdan@fusionauth.io\",\n    \"name\" : \"Jim Bob\"\n  }\n}\n"));
    }

    @Test(dataProvider="methodOverrides")
    public void patch_MethodOverride(String string) throws Exception {
        simulator.test("/patch/test").withJSONFile(Path.of("src/test/resources/json/patch/test-patch.json", new String[0]), new Object[0]).withHeader(string, "PATCH").post().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertJSONFile(this.jsonDir.resolve("patch/test-response.json"), "config", "patched");
    }

    @Test
    public void patch_testing() throws Exception {
        simulator.test("/patch/test").withJSONFile(Path.of("src/test/resources/json/patch/test.json", new String[0]), "config", "post").post().assertStatusCode(200).assertJSONFile(this.jsonDir.resolve("patch/test-response.json"), "config", "post");
        simulator.test("/patch/test").withJSONFile(Path.of("src/test/resources/json/patch/test.json", new String[0]), "config", "put").put().assertStatusCode(200).assertJSONFile(this.jsonDir.resolve("patch/test-response.json"), "config", "put");
        simulator.test("/patch/test").withJSONFile(Path.of("src/test/resources/json/patch/test-patch.json", new String[0]), new Object[0]).patch().assertStatusCode(200).assertJSONFile(this.jsonDir.resolve("patch/test-response.json"), "config", "patched");
    }
}

