/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.primeframework.mvc.test.BodyTools;
import org.primeframework.mvc.test.RequestResult;
import org.testng.Assert;

public class JSONBuilder {
    public ObjectMapper objectMapper;
    public ObjectNode root;

    public JSONBuilder(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public JSONBuilder(JsonNode jsonNode) {
        this.root = (ObjectNode)jsonNode;
        this.objectMapper = new ObjectMapper();
    }

    public JSONBuilder add(String string2, Object object) throws Exception {
        return this.addValue(string2, (objectNode, string) -> objectNode.put(string, object.toString()), arrayNode -> arrayNode.add(object.toString()));
    }

    public JSONBuilder add(String string2, List<String> list) throws Exception {
        return this.addValue(string2, (objectNode, string) -> {
            ArrayNode arrayNode = objectNode.putArray(string);
            list.forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
        }, arrayNode -> list.forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0)));
    }

    public JSONBuilder add(String string2, Map<String, Object> map) throws Exception {
        byte[] byArray = this.objectMapper.writeValueAsBytes(map);
        JsonNode jsonNode = this.objectMapper.readTree(byArray);
        return this.addValue(string2, (objectNode, string) -> objectNode.putObject(string).setAll((ObjectNode)jsonNode), arrayNode -> arrayNode.add(jsonNode));
    }

    public JSONBuilder add(String string2, boolean bl) throws Exception {
        return this.addValue(string2, (objectNode, string) -> objectNode.put(string, bl), arrayNode -> arrayNode.add(bl));
    }

    public JSONBuilder add(String string2, long l) throws Exception {
        return this.addValue(string2, (objectNode, string) -> objectNode.put(string, l), arrayNode -> arrayNode.add(l));
    }

    public JSONBuilder add(String string2, int n) throws Exception {
        return this.addValue(string2, (objectNode, string) -> objectNode.put(string, n), arrayNode -> arrayNode.add(n));
    }

    public String build() throws JsonProcessingException {
        return this.objectMapper.writeValueAsString((Object)this.root);
    }

    public JSONBuilder remove(String ... stringArray) {
        for (String string : stringArray) {
            JSONPointer jSONPointer = this.parseFieldName(string);
            JsonNode jsonNode = this.root.at(jSONPointer.parent);
            if (jsonNode.isObject()) {
                ((ObjectNode)jsonNode).remove(jSONPointer.field);
                continue;
            }
            if (!jsonNode.isArray()) continue;
            int n = Integer.parseInt(jSONPointer.field);
            ((ArrayNode)jsonNode).remove(n);
        }
        return this;
    }

    public JSONBuilder withJSON(Map<String, Object> map) throws IOException {
        byte[] byArray = this.objectMapper.writeValueAsBytes(map);
        this.root = (ObjectNode)this.objectMapper.readTree(byArray);
        return this;
    }

    public JSONBuilder withJSON(String string) throws IOException {
        this.root = (ObjectNode)this.objectMapper.readTree(string);
        return this;
    }

    public JSONBuilder withJSONFile(Path path, Object ... objectArray) throws IOException {
        this.root = (ObjectNode)this.objectMapper.readTree(BodyTools.processTemplate(path, objectArray));
        return this;
    }

    private JSONBuilder addValue(String string, RequestResult.ThrowingBiConsumer<ObjectNode, String> throwingBiConsumer, RequestResult.ThrowingConsumer<ArrayNode> throwingConsumer) throws Exception {
        JsonNode jsonNode;
        JsonNode jsonNode2;
        JSONPointer jSONPointer = this.parseFieldName(string);
        this.createNestedObjectPaths(jSONPointer);
        if (this.root == null) {
            this.root = (ObjectNode)this.objectMapper.readTree("{}".getBytes(StandardCharsets.UTF_8));
        }
        if ((jsonNode2 = (jsonNode = this.root.at(jSONPointer.parent)).path(jSONPointer.field)) instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode2;
            throwingConsumer.accept(arrayNode);
            return this;
        }
        if (jsonNode.isMissingNode()) {
            Assert.fail((String)("Node not found. [" + string + "]"));
        }
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            throwingBiConsumer.accept(objectNode, jSONPointer.field);
        } else if (jsonNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            throwingConsumer.accept(arrayNode);
        } else {
            throw new UnsupportedOperationException("Not expecting this. Node is [" + jsonNode.getClass().getSimpleName() + "]");
        }
        return this;
    }

    private void createNestedObjectPaths(JSONPointer jSONPointer) {
        if (jSONPointer.parent == null || jSONPointer.parent.equals("")) {
            return;
        }
        Object object = "/";
        ObjectNode objectNode = this.root;
        for (String string : jSONPointer.parent.substring(1).split("/")) {
            if (this.root.at((String)(object = (String)object + (((String)object).endsWith("/") ? "" : "/") + string)).isMissingNode()) {
                if (objectNode instanceof ObjectNode) {
                    ObjectNode objectNode2 = objectNode;
                    objectNode2.set(string, (JsonNode)JsonNodeFactory.instance.objectNode());
                    objectNode = this.root.at((String)object);
                    continue;
                }
                throw new UnsupportedOperationException("Not expecting this. Node is [" + objectNode.getClass().getSimpleName() + "]");
            }
            objectNode = this.root.at((String)object);
        }
    }

    private JSONPointer parseFieldName(String string) {
        String string2 = "/" + string.replaceAll("\\.", "/").replaceAll("\\[(.*?)\\]", "/$1");
        String string3 = string2.substring(string2.lastIndexOf(47) + 1);
        return new JSONPointer(string3, string2.substring(0, string2.indexOf(string3) - 1));
    }

    public static class JSONPointer {
        public String field;
        public String parent;

        public JSONPointer(String string, String string2) {
            this.field = string;
            this.parent = string2;
        }
    }
}

