/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.el;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.TypeVariable;
import java.util.List;
import org.primeframework.mvc.parameter.convert.ConverterProvider;
import org.primeframework.mvc.parameter.el.Accessor;
import org.primeframework.mvc.parameter.el.Expression;
import org.primeframework.mvc.parameter.el.MemberAccessor;
import org.primeframework.mvc.util.TypeTools;

public class IndexedCollectionAccessor
extends Accessor {
    Integer index;
    MemberAccessor memberAccessor;

    public IndexedCollectionAccessor(ConverterProvider converterProvider, Accessor accessor, Integer index, MemberAccessor memberAccessor) {
        super(converterProvider, accessor);
        this.index = index;
        this.type = TypeTools.componentType(this.type, memberAccessor.toString());
        if (this.type instanceof TypeVariable) {
            this.type = TypeTools.resolveGenericType(memberAccessor.declaringClass, this.currentClass, (TypeVariable)this.type);
        }
        this.memberAccessor = memberAccessor;
    }

    @Override
    public Object get(Expression expression) {
        return this.getValueFromCollection(this.index);
    }

    @Override
    public MemberAccessor getMemberAccessor() {
        return this.memberAccessor;
    }

    @Override
    public boolean isIndexed() {
        return false;
    }

    @Override
    public void set(String[] values, Expression expression) {
        this.set(this.convert(expression, this.memberAccessor.field, values), expression);
    }

    @Override
    public void set(Object value, Expression expression) {
        if (value instanceof String[] && ((String[])value).length == 1) {
            expression.setCurrentValue(((String[])value)[0]);
        } else {
            this.object = this.pad(this.object, expression);
            this.setValueIntoCollection(this.index, value);
        }
    }

    @Override
    protected <T extends Annotation> T getAnnotation(Class<T> type) {
        return this.memberAccessor.getAnnotation(type);
    }

    private Object pad(Object object, Expression expression) {
        int length;
        if (object instanceof List) {
            List list = (List)object;
            int length2 = list.size();
            if (length2 <= this.index) {
                for (int i = length2; i <= this.index; ++i) {
                    list.add(null);
                }
            }
        } else if (object.getClass().isArray() && (length = Array.getLength(object)) <= this.index) {
            Object newArray = Array.newInstance(object.getClass().getComponentType(), this.index + 1);
            System.arraycopy(object, 0, newArray, 0, length);
            object = newArray;
            this.memberAccessor.update(newArray, expression);
        }
        return object;
    }
}

