/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.el;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.primeframework.mvc.parameter.convert.AnnotationConverter;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.ConverterProvider;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.parameter.convert.GlobalConverter;
import org.primeframework.mvc.parameter.convert.annotation.ConverterAnnotation;
import org.primeframework.mvc.parameter.el.Expression;
import org.primeframework.mvc.parameter.el.MemberAccessor;
import org.primeframework.mvc.parameter.el.UpdateExpressionException;
import org.primeframework.mvc.util.TypeTools;

public abstract class Accessor {
    protected final ConverterProvider converterProvider;
    protected Class<?> currentClass;
    protected Object object;
    protected Type type;

    public Accessor(ConverterProvider converterProvider, Accessor accessor) {
        this.converterProvider = converterProvider;
        this.type = accessor.type;
        this.currentClass = accessor.currentClass;
    }

    protected Accessor(ConverterProvider converterProvider) {
        this.converterProvider = converterProvider;
    }

    public final Object get(Object object, Expression expression) {
        this.object = object;
        return this.get(expression);
    }

    public abstract MemberAccessor getMemberAccessor();

    public abstract boolean isIndexed();

    public final void set(Object object, Object value, Expression expression) {
        this.object = object;
        this.set(value, expression);
    }

    public final void set(Object object, String[] values, Expression expression) {
        this.object = object;
        this.set(values, expression);
    }

    public String toString() {
        return "declaring class [" + String.valueOf(this.currentClass) + "]";
    }

    public void update(Object value, Expression expression) {
        if (this.object == null) {
            throw new UpdateExpressionException("The object is null, unable to update.");
        }
        this.set(this.object, value, expression);
    }

    protected Object convert(Expression expression, AccessibleObject accessibleObject, String ... values) throws ConversionException {
        Class<?> typeClass;
        Object newValue = values;
        if (accessibleObject != null) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = accessibleObject.getAnnotations()) {
                ConverterAnnotation converterAnnotation = annotation.annotationType().getAnnotation(ConverterAnnotation.class);
                if (converterAnnotation == null) continue;
                AnnotationConverter converter = this.converterProvider.lookup(annotation);
                return converter.convertFromStrings(annotation, values, this.type, expression.getAttributes(), expression.getExpression());
            }
        }
        if (!(typeClass = TypeTools.rawType(this.type)).isInstance(values)) {
            GlobalConverter converter = this.converterProvider.lookup(typeClass);
            if (converter == null) {
                String className = this.currentClass != null ? this.currentClass.getCanonicalName() : "unknown";
                throw new ConverterStateException("While evaluating the expression [" + expression.getExpression() + "] in class [" + className + "]. No type converter found for the type [" + typeClass.getName() + "].");
            }
            newValue = converter.convertFromStrings(this.type, expression.getAttributes(), expression.getExpression(), values);
        }
        return newValue;
    }

    protected Object createValue(Object key) {
        Cloneable value;
        block22: {
            Class<?> typeClass = TypeTools.rawType(this.type);
            value = null;
            if (Map.class == typeClass) {
                value = new HashMap();
            } else if (List.class == typeClass) {
                value = new ArrayList();
            } else if (Set.class == typeClass) {
                value = new HashSet();
            } else if (Queue.class == typeClass) {
                value = new LinkedList();
            } else if (Deque.class == typeClass) {
                value = new ArrayDeque();
            } else if (SortedSet.class == typeClass) {
                value = new TreeSet();
            } else if (typeClass.isArray()) {
                if (key == null) {
                    throw new UpdateExpressionException("Attempting to create an array, but there isn't an index available to determine the size of the array");
                }
                value = Array.newInstance(typeClass.getComponentType(), Integer.parseInt(key.toString()) + 1);
            } else {
                try {
                    if (typeClass == Object.class) {
                        if (key instanceof String) {
                            try {
                                Integer.parseInt((String)key);
                                value = new ArrayList();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (value == null) {
                            value = new HashMap();
                        }
                        break block22;
                    }
                    value = this.newInstance(key, typeClass);
                }
                catch (Exception e) {
                    throw new UpdateExpressionException("Unable to instantiate object [" + typeClass.getName() + "]");
                }
            }
        }
        return value;
    }

    protected abstract Object get(Expression var1);

    protected abstract <T extends Annotation> T getAnnotation(Class<T> var1);

    protected Object getValueFromCollection(int index) {
        if (this.object.getClass().isArray()) {
            if (Array.getLength(this.object) <= index) {
                return null;
            }
            return Array.get(this.object, index);
        }
        Object object = this.object;
        if (object instanceof List) {
            List l = (List)object;
            if (l.size() <= index) {
                return null;
            }
            return l.get(index);
        }
        Iterator iter = ((Collection)this.object).iterator();
        Object value = null;
        for (int i = 0; i < index; ++i) {
            if (!iter.hasNext()) {
                return null;
            }
            value = iter.next();
        }
        return value;
    }

    protected Object newInstance(Object atom, Class<?> clazz) throws IllegalAccessException, InstantiationException {
        return clazz.newInstance();
    }

    protected abstract void set(Object var1, Expression var2);

    protected abstract void set(String[] var1, Expression var2);

    protected void setValueIntoCollection(int index, Object value) {
        if (this.object.getClass().isArray()) {
            Array.set(this.object, index, value);
        } else if (this.object instanceof List) {
            List l = (List)this.object;
            l.set(index, value);
        } else {
            throw new UpdateExpressionException("You can only set values into arrays and Lists. You are setting a parameter into [" + String.valueOf(this.getMemberAccessor()) + "] which is of type [" + String.valueOf(this.object.getClass()) + "]");
        }
    }
}

