/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.freemarker.guice;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import freemarker.template.TemplateModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TemplateModelFactory {
    private static final Map<String, Map<String, Class<? extends TemplateModel>>> bindings = new HashMap<String, Map<String, Class<? extends TemplateModel>>>();
    private final Injector injector;

    @Inject
    public TemplateModelFactory(Injector injector) {
        this.injector = injector;
    }

    public static void addModel(Binder binder, String prefix, String name, Class<? extends TemplateModel> modelType) {
        binder.bind(modelType);
        Map models = bindings.computeIfAbsent(prefix, k -> new HashMap());
        models.put(name, modelType);
    }

    public static void addSingletonModel(Binder binder, String prefix, String name, Class<? extends TemplateModel> modelType) {
        binder.bind(modelType).asEagerSingleton();
        Map models = bindings.computeIfAbsent(prefix, k -> new HashMap());
        models.put(name, modelType);
    }

    public TemplateModel build(String prefix, String name) {
        Map<String, Class<? extends TemplateModel>> controls = bindings.get(prefix);
        if (controls == null) {
            throw new IllegalArgumentException("Unbound TemplateModel prefix [" + prefix + "]");
        }
        Class<? extends TemplateModel> modelType = controls.get(name);
        if (modelType == null) {
            throw new IllegalArgumentException("TemplateModel named [" + name + "] is not bound in the prefix [" + prefix + "]");
        }
        return (TemplateModel)this.injector.getInstance(modelType);
    }

    public Set<String> controlNames(String prefix) {
        return bindings.get(prefix).keySet();
    }

    public Set<String> prefixes() {
        return bindings.keySet();
    }
}

