/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.form;

import com.google.inject.Inject;
import io.fusionauth.http.HTTPMethod;
import java.io.Writer;
import java.util.Map;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.ActionMapper;
import org.primeframework.mvc.action.config.ActionConfigurationProvider;
import org.primeframework.mvc.control.AbstractControl;
import org.primeframework.mvc.control.annotation.ControlAttribute;
import org.primeframework.mvc.control.annotation.ControlAttributes;
import org.primeframework.mvc.control.form.FormPreparer;
import org.primeframework.mvc.parameter.ParameterHandler;
import org.primeframework.mvc.parameter.ParameterParser;
import org.primeframework.mvc.parameter.PostParameterHandler;
import org.primeframework.mvc.scope.ScopeRetriever;

@ControlAttributes(required={@ControlAttribute(name="action", types={String.class})})
public class Form
extends AbstractControl {
    private final ActionConfigurationProvider actionConfigurationProvider;
    private final ActionInvocationStore actionInvocationStore;
    private final ActionMapper actionMapper;
    private final FormPreparer formPreparer;
    private final ParameterHandler parameterHandler;
    private final ParameterParser parameterParser;
    private final PostParameterHandler postParameterHandler;
    private final ScopeRetriever scopeRetriever;
    private boolean differentURI = false;

    @Inject
    public Form(ActionConfigurationProvider actionConfigurationProvider, FormPreparer formPreparer, ActionInvocationStore actionInvocationStore, ActionMapper actionMapper, ParameterParser parameterParser, ParameterHandler parameterHandler, PostParameterHandler postParameterHandler, ScopeRetriever scopeRetriever) {
        this.actionConfigurationProvider = actionConfigurationProvider;
        this.formPreparer = formPreparer;
        this.actionInvocationStore = actionInvocationStore;
        this.actionMapper = actionMapper;
        this.parameterHandler = parameterHandler;
        this.parameterParser = parameterParser;
        this.postParameterHandler = postParameterHandler;
        this.scopeRetriever = scopeRetriever;
    }

    @Override
    public void renderEnd(Writer writer) {
        if (this.differentURI) {
            this.actionInvocationStore.removeCurrent();
            this.differentURI = false;
        }
        super.renderEnd(writer);
    }

    @Override
    public void renderStart(Writer writer, Map<String, Object> attributes, Map<String, String> dynamicAttributes) {
        boolean fullyQualified;
        Object action = (String)attributes.get("action");
        boolean bl = fullyQualified = ((String)action).startsWith("http://") || ((String)action).startsWith("https://");
        if (!((String)action).startsWith("/") && !fullyQualified) {
            String currentURI = this.currentInvocation().uri();
            int index = currentURI.lastIndexOf(47);
            if (index >= 0) {
                action = currentURI.substring(0, index) + "/" + (String)action;
            } else if (currentURI.equals("")) {
                action = "/" + (String)action;
            }
        }
        if (!fullyQualified) {
            String method = (String)attributes.get("method");
            HTTPMethod httpMethod = HTTPMethod.GET;
            if (method != null && !method.equalsIgnoreCase("GET") && !method.equalsIgnoreCase("POST")) {
                throw new PrimeException("Invalid method [" + method + "] for form. Only standard GET and POST methods are allowed.");
            }
            if (method != null) {
                httpMethod = HTTPMethod.of((String)method);
            }
            ActionInvocation current = this.actionInvocationStore.getCurrent();
            ActionInvocation actionInvocation = this.actionConfigurationProvider.lookup((String)action);
            if (current == null || current.action == null || actionInvocation == null || actionInvocation.configuration == null || current.action.getClass() != actionInvocation.configuration.actionClass) {
                actionInvocation = this.actionMapper.map(httpMethod, (String)action);
                if (actionInvocation == null || actionInvocation.action == null) {
                    throw new PrimeException("The form action [" + (String)action + "] is not a valid URI that maps to an action class by the Prime MVC.");
                }
                this.actionInvocationStore.setCurrent(actionInvocation);
                this.prepareActionInvocation(actionInvocation);
                this.differentURI = true;
            }
        }
        this.formPreparer.prepare();
        String contextPath = this.request.getContextPath();
        if (contextPath.length() > 0 && !fullyQualified) {
            action = contextPath + (String)action;
        }
        attributes.put("action", action);
        super.renderStart(writer, attributes, dynamicAttributes);
    }

    @Override
    protected String endTemplateName() {
        return "form-end.ftl";
    }

    @Override
    protected String startTemplateName() {
        return "form-start.ftl";
    }

    private void prepareActionInvocation(ActionInvocation actionInvocation) {
        this.scopeRetriever.setScopedValues(actionInvocation);
        ParameterParser.Parameters parameters = this.parameterParser.parse();
        parameters.optional.putAll(parameters.required);
        parameters.required.clear();
        parameters.files.clear();
        this.parameterHandler.handle(parameters);
        this.postParameterHandler.handle(actionInvocation);
    }
}

