/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import com.google.inject.Inject;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.result.ActionResultDefinition;
import org.primeframework.mvc.action.result.ForwardResult;
import org.primeframework.mvc.action.result.RedirectResult;
import org.primeframework.mvc.action.result.ResourceLocator;
import org.primeframework.mvc.action.result.Result;
import org.primeframework.mvc.action.result.ResultFactory;
import org.primeframework.mvc.action.result.ResultInvocationWorkflow;
import org.primeframework.mvc.action.result.ResultStore;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.util.ReflectionUtils;
import org.primeframework.mvc.workflow.WorkflowChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResultInvocationWorkflow
implements ResultInvocationWorkflow {
    private static final Logger logger = LoggerFactory.getLogger(DefaultResultInvocationWorkflow.class);
    private final ActionInvocationStore actionInvocationStore;
    private final MVCConfiguration configuration;
    private final Map<String, ActionResultDefinition> defaultResultMappings;
    private final ResultFactory factory;
    private final ResourceLocator resourceLocator;
    private final ResultStore resultStore;

    @Inject
    public DefaultResultInvocationWorkflow(ActionInvocationStore actionInvocationStore, MVCConfiguration configuration, Map<String, ActionResultDefinition> defaultResults, ResultStore resultStore, ResourceLocator resourceLocator, ResultFactory factory) {
        this.actionInvocationStore = actionInvocationStore;
        this.configuration = configuration;
        this.defaultResultMappings = defaultResults;
        this.resultStore = resultStore;
        this.resourceLocator = resourceLocator;
        this.factory = factory;
    }

    @Override
    public void perform(WorkflowChain chain) throws IOException {
        ActionInvocation actionInvocation = this.actionInvocationStore.getCurrent();
        if (actionInvocation.executeResult) {
            List<Method> preRenderMethods;
            Annotation annotation = null;
            String resultCode = "success";
            if (actionInvocation.action != null) {
                resultCode = this.resultStore.get();
                annotation = actionInvocation.configuration.resultConfigurations.get(resultCode);
            }
            if (annotation == null) {
                ActionResultDefinition defaultMapping = this.defaultResultMappings.get(resultCode);
                if (defaultMapping != null) {
                    annotation = defaultMapping.getAnnotation(resultCode);
                }
                if (annotation == null) {
                    if (actionInvocation.action != null && (annotation = actionInvocation.configuration.resultConfigurations.get("*")) != null) {
                        annotation = this.newProxyInstance(annotation, resultCode);
                        logger.debug("Missing result annotation for action class [{}] URI [{}] for result code [{}]. A default mapping of [@{}] was configured using the [*] result code. This is not an error. This message is provided in case you do wish to define an explicit mapping.", new Object[]{actionInvocation.configuration.actionClass.getName(), actionInvocation.uri(), resultCode, annotation.annotationType().getSimpleName()});
                    }
                    if (annotation == null) {
                        annotation = new ForwardResult.ForwardImpl("", resultCode);
                        if (actionInvocation.action != null) {
                            logger.debug("Missing result annotation for action class [{}] URI [{}] for result code [{}]. The default mapping of [@{}] was used. This is not an error. This message is provided in case you do wish to define an explicit mapping.", new Object[]{actionInvocation.configuration.actionClass.getName(), actionInvocation.uri(), resultCode, annotation.annotationType().getSimpleName()});
                        }
                    }
                }
            }
            if (actionInvocation.action != null && actionInvocation.configuration.preRenderMethods != null && (preRenderMethods = actionInvocation.configuration.preRenderMethods.get(annotation.annotationType())) != null) {
                ReflectionUtils.invokeAll(actionInvocation.action, preRenderMethods);
            }
            long start = System.currentTimeMillis();
            Result<? extends Annotation> result = this.factory.build(annotation.annotationType());
            boolean handled = result.execute(annotation);
            if (logger.isDebugEnabled()) {
                logger.debug("Result execute took [{}]", (Object)(System.currentTimeMillis() - start));
            }
            if (!handled) {
                this.handleContinueOrRedirect(chain);
            }
        }
    }

    private void handleContinueOrRedirect(WorkflowChain chain) throws IOException {
        String uri = this.resourceLocator.locateIndex(this.configuration.templateDirectory());
        if (uri != null) {
            RedirectResult.RedirectImpl annotation = new RedirectResult.RedirectImpl(uri, "success", true, false);
            Result<? extends Annotation> redirectResult = this.factory.build(annotation.annotationType());
            redirectResult.execute(annotation);
            return;
        }
        chain.continueWorkflow();
    }

    private Annotation newProxyInstance(Annotation annotation, String resultCode) {
        try {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            return (Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, (InvocationHandler)new AnnotationInvocationHandler(annotation, resultCode));
        }
        catch (Exception e) {
            throw new PrimeException("Unable to proxy the default result code [*]. This is unexpected.", e);
        }
    }

    public static class AnnotationInvocationHandler
    implements InvocationHandler {
        private final Annotation annotation;
        private final String resultCode;

        public AnnotationInvocationHandler(Annotation annotation, String resultCode) {
            this.annotation = annotation;
            this.resultCode = resultCode;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("code")) {
                return this.resultCode;
            }
            return method.invoke((Object)this.annotation, args);
        }
    }
}

