/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.config;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.annotation.Action;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.action.config.ActionConfigurationBuilder;
import org.primeframework.mvc.action.config.ActionConfigurationProvider;
import org.primeframework.mvc.util.ClassClasspathResolver;
import org.primeframework.mvc.util.URITools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultActionConfigurationProvider
implements ActionConfigurationProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultActionConfigurationProvider.class);
    private final List<ActionConfiguration> actionConfigurations = new ArrayList<ActionConfiguration>();
    private final Node root = new Node();

    @Inject
    public DefaultActionConfigurationProvider(ActionConfigurationBuilder builder) {
        Set actionClasses;
        ClassClasspathResolver resolver = new ClassClasspathResolver();
        try {
            actionClasses = resolver.findByLocators(new ClassClasspathResolver.AnnotatedWith(Action.class), true, null, "action");
        }
        catch (IOException e) {
            throw new PrimeException("Error discovering action classes", e);
        }
        for (Class actionClass : actionClasses) {
            if (!this.inClassLoaderOrParentClassLoader(Action.class.getClassLoader(), actionClass)) continue;
            ActionConfiguration actionConfiguration = builder.build(actionClass);
            this.actionConfigurations.add(actionConfiguration);
            String uri = actionConfiguration.uri;
            Node current = this.root;
            String[] uriParts = uri.substring(1).split("/");
            for (int i = 0; i < uriParts.length; ++i) {
                if (i == uriParts.length - 1) {
                    current = this.processPrefixParameters(actionConfiguration, current);
                    current = current.actions.compute(uriParts[i], (k, v) -> new Node(actionConfiguration));
                    continue;
                }
                current = current.packages.computeIfAbsent(uriParts[i], k -> new Node());
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Added action configuration for [{}] and the uri [{}]", actionClass, (Object)actionConfiguration.uri);
        }
    }

    @Override
    public List<ActionConfiguration> getActionConfigurations() {
        return new ArrayList<ActionConfiguration>(this.actionConfigurations);
    }

    @Override
    public ActionInvocation lookup(String uri) {
        TraversalState state;
        boolean addIndexURIPart;
        String extension = URITools.determineExtension((String)uri);
        if (extension != null) {
            uri = ((String)uri).substring(0, ((String)uri).length() - extension.length() - 1);
        }
        if (addIndexURIPart = ((String)uri).endsWith("/")) {
            uri = (String)uri + "index";
        }
        ActionInvocation invocation = new ActionInvocation(null, null, (String)uri, extension, null);
        String[] uriParts = ((String)uri).substring(1).split("/");
        boolean result = this.traverse(this.root, uriParts, 0, state = new TraversalState(), addIndexURIPart);
        if (result) {
            invocation.actionURI = state.actionConfiguration.uri;
            invocation.configuration = state.actionConfiguration;
            invocation.uriParameters.putAll(state.uriParameters.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        return invocation;
    }

    protected boolean canHandle(ActionConfiguration actionConfiguration, String[] remainingURIParts, TraversalState state) {
        HashMap<String, List> uriParameters = new HashMap<String, List>();
        for (int i = 0; i < remainingURIParts.length; ++i) {
            String name;
            String uriPart = remainingURIParts[i];
            if (i >= actionConfiguration.patternParts.length) break;
            if (actionConfiguration.patternParts[i].startsWith("{*")) {
                if (!actionConfiguration.patternParts[i].endsWith("}")) {
                    throw new PrimeException("Action annotation in class [" + String.valueOf(actionConfiguration.actionClass) + "] contains an invalid URI parameter pattern [" + actionConfiguration.pattern + "]. A curly bracket is unclosed. If you want to include a curly bracket that is not a URI parameter capture, you need to escape it like \\{");
                }
                if (i != actionConfiguration.patternParts.length - 1) {
                    throw new PrimeException("Action annotation in class [" + String.valueOf(actionConfiguration.actionClass) + "] contains an invalid URI parameter pattern [" + actionConfiguration.pattern + "]. You cannot have a wildcard capture (i.e. {*foo}) in the middle of the pattern. It must be on the end of the pattern.");
                }
                name = actionConfiguration.patternParts[i].substring(2, actionConfiguration.patternParts[i].length() - 1);
                String[] parts = Arrays.copyOfRange(remainingURIParts, i, remainingURIParts.length);
                List params = uriParameters.computeIfAbsent(name, k -> new ArrayList());
                for (String part : parts) {
                    params.add(URITools.decodeURIPathSegment(part));
                }
                break;
            }
            if (actionConfiguration.patternParts[i].startsWith("{")) {
                if (!actionConfiguration.patternParts[i].endsWith("}")) {
                    throw new PrimeException("Action annotation in class [" + String.valueOf(actionConfiguration.actionClass) + "] contains an invalid URI parameter pattern [" + actionConfiguration.pattern + "]. A curly bracket is unclosed. If you want to include a curly bracket that is not a URI parameter capture, you need to escape it like \\{");
                }
                name = actionConfiguration.patternParts[i].substring(1, actionConfiguration.patternParts[i].length() - 1);
                uriParameters.computeIfAbsent(name, k -> new ArrayList()).add(URITools.decodeURIPathSegment(uriPart));
                continue;
            }
            String patternPart = this.normalize(actionConfiguration.patternParts[i]);
            if (uriPart.equals(patternPart)) continue;
            return false;
        }
        for (String key : uriParameters.keySet()) {
            state.uriParameters.computeIfAbsent(key, k -> new ArrayList()).addAll((Collection)uriParameters.get(key));
        }
        return true;
    }

    protected String normalize(String pattern) {
        return pattern.replace("\\{", "{").replace("\\}", "}");
    }

    protected boolean traverse(Node node, String[] uriParts, int currentIndex, TraversalState state, boolean addedIndexURIPart) {
        if (currentIndex == uriParts.length) {
            return false;
        }
        String uriPart = uriParts[currentIndex];
        if (node.packages.containsKey(uriPart) && this.traverse(node.packages.get(uriPart), uriParts, currentIndex + 1, state, addedIndexURIPart)) {
            return true;
        }
        if (node.parameters.size() > 0) {
            for (String parameterName : node.parameters.keySet()) {
                state.uriParameters.computeIfAbsent(parameterName, k -> new ArrayList()).add(uriPart);
                if (this.traverse(node.parameters.get(parameterName), uriParts, currentIndex + 1, state, addedIndexURIPart)) {
                    return true;
                }
                state.uriParameters.get(parameterName).remove(uriPart);
            }
        }
        if (node.actions.containsKey(uriPart)) {
            int endIndex = addedIndexURIPart ? uriParts.length - 1 : uriParts.length;
            String[] remainingURIParts = endIndex < currentIndex + 1 ? new String[]{} : Arrays.copyOfRange(uriParts, currentIndex + 1, endIndex);
            Node actionNode = node.actions.get(uriPart);
            if (this.canHandle(actionNode.actionConfiguration, remainingURIParts, state)) {
                state.actionConfiguration = actionNode.actionConfiguration;
                return true;
            }
        }
        return false;
    }

    private boolean inClassLoaderOrParentClassLoader(ClassLoader classLoader, Class<?> actionClass) {
        for (ClassLoader actionClassClassLoader = actionClass.getClassLoader(); actionClassClassLoader != null; actionClassClassLoader = actionClassClassLoader.getParent()) {
            if (!classLoader.equals(actionClassClassLoader)) continue;
            return true;
        }
        return false;
    }

    private Node processPrefixParameters(ActionConfiguration actionConfiguration, Node current) {
        if (!actionConfiguration.annotation.prefixParameters().equals("")) {
            String[] prefixParameters;
            for (String prefix : prefixParameters = actionConfiguration.annotation.prefixParameters().split("/")) {
                String prefixName = prefix.substring(1, prefix.length() - 1);
                current = current.parameters.computeIfAbsent(prefixName, k -> new Node(prefixName));
            }
        }
        return current;
    }

    private static class Node {
        public ActionConfiguration actionConfiguration;
        public Map<String, Node> actions = new TreeMap<String, Node>();
        public Map<String, Node> packages = new TreeMap<String, Node>();
        public String parameterName;
        public Map<String, Node> parameters = new TreeMap<String, Node>();

        public Node() {
        }

        public Node(String parameterName) {
            this.parameterName = parameterName;
        }

        public Node(ActionConfiguration actionConfiguration) {
            this.actionConfiguration = actionConfiguration;
        }
    }

    private static class TraversalState {
        public ActionConfiguration actionConfiguration;
        public Map<String, List<String>> uriParameters = new TreeMap<String, List<String>>();

        private TraversalState() {
        }
    }
}

