/*
 * Copyright (c) 2025, Inversoft Inc., All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package org.primeframework.mvc;

import io.fusionauth.http.server.ExceptionHandlerContext;
import io.fusionauth.http.server.HTTPUnexpectedExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Daniel DeGroff
 */
public class PrimeMVCUnexpectedExceptionHandler implements HTTPUnexpectedExceptionHandler {
  private static final Logger logger = LoggerFactory.getLogger(PrimeMVCUnexpectedExceptionHandler.class);

  @Override
  public void handle(ExceptionHandlerContext context) {
    logger.error("Error encountered", context.getThrowable());
  }
}
