/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import io.fusionauth.http.BaseTest;
import io.fusionauth.http.server.CountingInstrumenter;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPServer;
import io.fusionauth.http.server.Instrumenter;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ParameterTest
extends BaseTest {
    @Test(dataProvider="schemes")
    public void form(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            Assert.assertEquals((String)hTTPRequest.getPath(), (String)"/api/system/version");
            Assert.assertEquals((Collection)((Collection)hTTPRequest.getURLParameters().get("one")), List.of("two"));
            Assert.assertEquals((Collection)((Collection)hTTPRequest.getURLParameters().get("three")), List.of("four"));
            Assert.assertEquals((Collection)((Collection)hTTPRequest.getFormData().get("five")), List.of("six"));
            Assert.assertEquals((Collection)((Collection)hTTPRequest.getFormData().get("seven")), List.of("eight"));
            Assert.assertEquals((Collection)((Collection)hTTPRequest.getParameters().get("one")), List.of("two", "again"));
            Assert.assertEquals((Collection)((Collection)hTTPRequest.getParameters().get("three")), List.of("four"));
            Assert.assertEquals((Collection)((Collection)hTTPRequest.getParameters().get("five")), List.of("six"));
            Assert.assertEquals((Collection)((Collection)hTTPRequest.getParameters().get("seven")), List.of("eight"));
            hTTPResponse.setStatus(200);
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            URI uRI = this.makeURI(string, "?one=two&three=four");
            HttpClient httpClient = this.makeClient(string, null);
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString("one=again&five=six&seven=eight")).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((long)countingInstrumenter.getServers(), (long)1L);
            Assert.assertEquals((long)countingInstrumenter.getConnections(), (long)1L);
        }
    }

    @Test(dataProvider="schemes")
    public void urlParameters(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            Assert.assertEquals((String)hTTPRequest.getPath(), (String)"/api/system/version");
            Assert.assertEquals((String)hTTPRequest.getURLParameter("one"), (String)"two");
            Assert.assertEquals((String)hTTPRequest.getURLParameter("three"), (String)"four");
            hTTPResponse.setStatus(200);
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();
             HttpClient httpClient = this.makeClient(string, null);){
            URI uRI = this.makeURI(string, "?one=two&three=four");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((long)countingInstrumenter.getServers(), (long)1L);
            Assert.assertEquals((long)countingInstrumenter.getConnections(), (long)1L);
        }
    }
}

