/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import io.fusionauth.http.BaseTest;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.server.CountingInstrumenter;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPServer;
import io.fusionauth.http.server.Instrumenter;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CookieTest
extends BaseTest {
    @Test
    public void cookieInjection() throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            Assert.assertNull((Object)hTTPRequest.getCookie("injected"));
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
            hTTPResponse.getOutputStream().close();
        };
        try (HTTPServer hTTPServer = this.makeServer("http", hTTPHandler).start();){
            URI uRI = URI.create("http://localhost:4242/%0d%0aSet-Cookie:injected=true%0d%0a?client_id=foo");
            CookieManager cookieManager = new CookieManager();
            HttpClient httpClient = this.makeClient("http", cookieManager);
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(uRI).GET().build();
            HttpResponse httpResponse = httpClient.send(httpRequest, responseInfo -> HttpResponse.BodySubscribers.discarding());
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            List<HttpCookie> list = cookieManager.getCookieStore().get(uRI);
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertNull(httpResponse.headers().firstValue("Set-Cookie").orElse(null));
            Assert.assertEquals((int)list.size(), (int)0);
        }
    }

    @Test
    public void fromRequestHeader() {
        List list = Cookie.fromRequestHeader((String)"foo=bar; baz=fred");
        Assert.assertEquals((int)list.size(), (int)2);
        Assert.assertEquals(list.get(0), (Object)new Cookie("foo", "bar"));
        Assert.assertEquals(list.get(1), (Object)new Cookie("baz", "fred"));
        list = Cookie.fromRequestHeader((String)"foo=bar==; baz=fred==");
        Assert.assertEquals((int)list.size(), (int)2);
        Assert.assertEquals(list.get(0), (Object)new Cookie("foo", "bar=="));
        Assert.assertEquals(list.get(1), (Object)new Cookie("baz", "fred=="));
        list = Cookie.fromRequestHeader((String)"foo=; baz=");
        Assert.assertEquals((int)list.size(), (int)0);
        list = Cookie.fromRequestHeader((String)"foo=");
        Assert.assertEquals((int)list.size(), (int)0);
        list = Cookie.fromRequestHeader((String)"=");
        Assert.assertEquals((int)list.size(), (int)0);
        list = Cookie.fromRequestHeader((String)"=bar");
        Assert.assertEquals((int)list.size(), (int)0);
        list = Cookie.fromRequestHeader((String)";");
        Assert.assertEquals((int)list.size(), (int)0);
        list = Cookie.fromRequestHeader((String)";;;;;");
        Assert.assertEquals((int)list.size(), (int)0);
    }

    @Test
    public void fromResponseHeader() {
        Cookie cookie = Cookie.fromResponseHeader((String)"foo=bar; Path=/foo/bar; Domain=fusionauth.io; Max-Age=1; Secure; HttpOnly; SameSite=Lax");
        Assert.assertEquals((String)cookie.domain, (String)"fusionauth.io");
        Assert.assertNull((Object)cookie.expires);
        Assert.assertTrue((boolean)cookie.httpOnly);
        Assert.assertEquals((long)cookie.maxAge, (long)1L);
        Assert.assertEquals((String)cookie.name, (String)"foo");
        Assert.assertEquals((String)cookie.path, (String)"/foo/bar");
        Assert.assertEquals((Object)cookie.sameSite, (Object)Cookie.SameSite.Lax);
        Assert.assertTrue((boolean)cookie.secure);
        Assert.assertEquals((String)cookie.value, (String)"bar");
        cookie = Cookie.fromResponseHeader((String)"foo=bar; Domain=fusionauth.io; Expires=Wed, 21 Oct 2015 07:28:00 GMT; SameSite=None");
        Assert.assertEquals((String)cookie.domain, (String)"fusionauth.io");
        Assert.assertEquals((Object)cookie.expires, (Object)ZonedDateTime.of(2015, 10, 21, 7, 28, 0, 0, ZoneOffset.UTC));
        Assert.assertFalse((boolean)cookie.httpOnly);
        Assert.assertNull((Object)cookie.maxAge);
        Assert.assertEquals((String)cookie.name, (String)"foo");
        Assert.assertNull((Object)cookie.path);
        Assert.assertEquals((Object)cookie.sameSite, (Object)Cookie.SameSite.None);
        Assert.assertFalse((boolean)cookie.secure);
        Assert.assertEquals((String)cookie.value, (String)"bar");
        cookie = Cookie.fromResponseHeader((String)"     foo=bar;    \nDomain=fusionauth.io;   \t Expires=Wed, 21 Oct 2015 07:28:00 GMT;      \rSameSite=None");
        Assert.assertEquals((String)cookie.domain, (String)"fusionauth.io");
        Assert.assertEquals((Object)cookie.expires, (Object)ZonedDateTime.of(2015, 10, 21, 7, 28, 0, 0, ZoneOffset.UTC));
        Assert.assertFalse((boolean)cookie.httpOnly);
        Assert.assertNull((Object)cookie.maxAge);
        Assert.assertEquals((String)cookie.name, (String)"foo");
        Assert.assertNull((Object)cookie.path);
        Assert.assertEquals((Object)cookie.sameSite, (Object)Cookie.SameSite.None);
        Assert.assertFalse((boolean)cookie.secure);
        Assert.assertEquals((String)cookie.value, (String)"bar");
        cookie = Cookie.fromResponseHeader((String)"foo=slkjsdoiuewljklk==");
        Assert.assertNull((Object)cookie.domain);
        Assert.assertNull((Object)cookie.expires);
        Assert.assertFalse((boolean)cookie.httpOnly);
        Assert.assertNull((Object)cookie.maxAge);
        Assert.assertEquals((String)cookie.name, (String)"foo");
        Assert.assertNull((Object)cookie.path);
        Assert.assertNull((Object)cookie.sameSite);
        Assert.assertFalse((boolean)cookie.secure);
        Assert.assertEquals((String)cookie.value, (String)"slkjsdoiuewljklk==");
        cookie = Cookie.fromResponseHeader((String)"foo=bar;Domain=fusionauth.io;Expires=Wed, 21 Oct 2015 07:28:00 GMT;SameSite=None");
        Assert.assertEquals((String)cookie.domain, (String)"fusionauth.io");
        Assert.assertEquals((Object)cookie.expires, (Object)ZonedDateTime.of(2015, 10, 21, 7, 28, 0, 0, ZoneOffset.UTC));
        Assert.assertFalse((boolean)cookie.httpOnly);
        Assert.assertNull((Object)cookie.maxAge);
        Assert.assertEquals((String)cookie.name, (String)"foo");
        Assert.assertNull((Object)cookie.path);
        Assert.assertEquals((Object)cookie.sameSite, (Object)Cookie.SameSite.None);
        Assert.assertFalse((boolean)cookie.secure);
        Assert.assertEquals((String)cookie.value, (String)"bar");
        cookie = Cookie.fromResponseHeader((String)"foo=bar;Domain=;Expires=;SameSite=");
        Assert.assertEquals((String)cookie.domain, (String)"");
        Assert.assertNull((Object)cookie.expires);
        Assert.assertFalse((boolean)cookie.httpOnly);
        Assert.assertNull((Object)cookie.maxAge);
        Assert.assertEquals((String)cookie.name, (String)"foo");
        Assert.assertNull((Object)cookie.path);
        Assert.assertNull((Object)cookie.sameSite);
        Assert.assertFalse((boolean)cookie.secure);
        Assert.assertEquals((String)cookie.value, (String)"bar");
        cookie = Cookie.fromResponseHeader((String)"foo=\"bar\";");
        Assert.assertNull((Object)cookie.domain);
        Assert.assertNull((Object)cookie.expires);
        Assert.assertFalse((boolean)cookie.httpOnly);
        Assert.assertNull((Object)cookie.maxAge);
        Assert.assertEquals((String)cookie.name, (String)"foo");
        Assert.assertNull((Object)cookie.path);
        Assert.assertNull((Object)cookie.sameSite);
        Assert.assertFalse((boolean)cookie.secure);
        Assert.assertEquals((String)cookie.value, (String)"bar");
        cookie = Cookie.fromResponseHeader((String)"foo=\"bar\"; SameSite=");
        Assert.assertNull((Object)cookie.domain);
        Assert.assertNull((Object)cookie.expires);
        Assert.assertFalse((boolean)cookie.httpOnly);
        Assert.assertNull((Object)cookie.maxAge);
        Assert.assertEquals((String)cookie.name, (String)"foo");
        Assert.assertNull((Object)cookie.path);
        Assert.assertNull((Object)cookie.sameSite);
        Assert.assertFalse((boolean)cookie.secure);
        Assert.assertEquals((String)cookie.value, (String)"bar");
        cookie = Cookie.fromResponseHeader((String)"foo=\"bar; SameSite=");
        Assert.assertNull((Object)cookie.domain);
        Assert.assertNull((Object)cookie.expires);
        Assert.assertFalse((boolean)cookie.httpOnly);
        Assert.assertNull((Object)cookie.maxAge);
        Assert.assertEquals((String)cookie.name, (String)"foo");
        Assert.assertNull((Object)cookie.path);
        Assert.assertNull((Object)cookie.sameSite);
        Assert.assertFalse((boolean)cookie.secure);
        Assert.assertEquals((String)cookie.value, (String)"bar");
        cookie = Cookie.fromResponseHeader((String)"foo=bar\"; SameSite=");
        Assert.assertNull((Object)cookie.domain);
        Assert.assertNull((Object)cookie.expires);
        Assert.assertFalse((boolean)cookie.httpOnly);
        Assert.assertNull((Object)cookie.maxAge);
        Assert.assertEquals((String)cookie.name, (String)"foo");
        Assert.assertNull((Object)cookie.path);
        Assert.assertNull((Object)cookie.sameSite);
        Assert.assertFalse((boolean)cookie.secure);
        Assert.assertEquals((String)cookie.value, (String)"bar");
        cookie = Cookie.fromResponseHeader((String)"foo=bar;  =fusionauth.io; =Wed, 21 Oct 2015 07:28:00 GMT; =1; =Lax");
        Assert.assertNull((Object)cookie.domain);
        Assert.assertNull((Object)cookie.expires);
        Assert.assertFalse((boolean)cookie.httpOnly);
        Assert.assertNull((Object)cookie.maxAge);
        Assert.assertEquals((String)cookie.name, (String)"foo");
        Assert.assertNull((Object)cookie.path);
        Assert.assertNull((Object)cookie.sameSite);
        Assert.assertFalse((boolean)cookie.secure);
        Assert.assertEquals((String)cookie.value, (String)"bar");
        cookie = Cookie.fromResponseHeader((String)"a=");
        Assert.assertNull((Object)cookie.domain);
        Assert.assertNull((Object)cookie.expires);
        Assert.assertFalse((boolean)cookie.httpOnly);
        Assert.assertNull((Object)cookie.maxAge);
        Assert.assertEquals((String)cookie.name, (String)"a");
        Assert.assertNull((Object)cookie.path);
        Assert.assertNull((Object)cookie.sameSite);
        Assert.assertFalse((boolean)cookie.secure);
        Assert.assertEquals((String)cookie.value, (String)"");
        cookie = Cookie.fromResponseHeader((String)"a=; Max-Age=1");
        Assert.assertNull((Object)cookie.domain);
        Assert.assertNull((Object)cookie.expires);
        Assert.assertFalse((boolean)cookie.httpOnly);
        Assert.assertEquals((long)cookie.maxAge, (long)1L);
        Assert.assertEquals((String)cookie.name, (String)"a");
        Assert.assertNull((Object)cookie.path);
        Assert.assertNull((Object)cookie.sameSite);
        Assert.assertFalse((boolean)cookie.secure);
        Assert.assertEquals((String)cookie.value, (String)"");
        cookie = Cookie.fromResponseHeader((String)"foo=;Domain=;SameSite=");
        Assert.assertEquals((String)cookie.domain, (String)"");
        Assert.assertNull((Object)cookie.expires);
        Assert.assertFalse((boolean)cookie.httpOnly);
        Assert.assertNull((Object)cookie.maxAge);
        Assert.assertEquals((String)cookie.name, (String)"foo");
        Assert.assertNull((Object)cookie.path);
        Assert.assertNull((Object)cookie.sameSite);
        Assert.assertFalse((boolean)cookie.secure);
        Assert.assertEquals((String)cookie.value, (String)"");
        cookie = Cookie.fromResponseHeader((String)"foo;Domain;Expires;Max-Age;SameSite");
        Assert.assertNull((Object)cookie);
        cookie = Cookie.fromResponseHeader((String)"   =bar;  =fusionauth.io; =Wed, 21 Oct 2015 07:28:00 GMT; =1; =Lax");
        Assert.assertNull((Object)cookie);
        cookie = Cookie.fromResponseHeader((String)"=bar;=fusionauth.io;Expires;Max-Age;SameSite");
        Assert.assertNull((Object)cookie);
        cookie = Cookie.fromResponseHeader((String)"=;");
        Assert.assertNull((Object)cookie);
        cookie = Cookie.fromResponseHeader((String)";");
        Assert.assertNull((Object)cookie);
        cookie = Cookie.fromResponseHeader((String)";;;;;");
        Assert.assertNull((Object)cookie);
        cookie = Cookie.fromResponseHeader((String)"");
        Assert.assertNull((Object)cookie);
        cookie = Cookie.fromResponseHeader((String)"=");
        Assert.assertNull((Object)cookie);
        cookie = Cookie.fromResponseHeader((String)"=a");
        Assert.assertNull((Object)cookie);
        cookie = Cookie.fromResponseHeader((String)"foo=%2Fbar; Path=/; Secure; HTTPonly;");
        Assert.assertNull((Object)cookie.domain);
        Assert.assertNull((Object)cookie.expires);
        Assert.assertTrue((boolean)cookie.httpOnly);
        Assert.assertNull((Object)cookie.maxAge);
        Assert.assertEquals((String)cookie.name, (String)"foo");
        Assert.assertEquals((String)cookie.path, (String)"/");
        Assert.assertNull((Object)cookie.sameSite);
        Assert.assertTrue((boolean)cookie.secure);
        Assert.assertEquals((String)cookie.value, (String)"%2Fbar");
        cookie = Cookie.fromResponseHeader((String)"foo=;utm=123");
        Assert.assertEquals((String)cookie.name, (String)"foo");
        Assert.assertEquals((String)cookie.getAttribute("utm"), (String)"123");
        cookie = Cookie.fromResponseHeader((String)"foo=;utm=");
        Assert.assertEquals((String)cookie.name, (String)"foo");
        Assert.assertEquals((String)cookie.getAttribute("utm"), (String)"");
        cookie = Cookie.fromResponseHeader((String)"foo=;utm");
        Assert.assertEquals((String)cookie.name, (String)"foo");
        Assert.assertEquals((String)cookie.getAttribute("utm"), (String)"");
        cookie = Cookie.fromResponseHeader((String)"foo=;foo=bar;bar=baz;bing=boom");
        Assert.assertEquals((String)cookie.name, (String)"foo");
        Assert.assertEquals((String)cookie.getAttribute("foo"), (String)"bar");
        Assert.assertEquals((String)cookie.getAttribute("bar"), (String)"baz");
        Assert.assertEquals((String)cookie.getAttribute("bing"), (String)"boom");
        cookie = Cookie.fromResponseHeader((String)"foo=;foo=bar;bar=baz;bing=boom");
        Assert.assertTrue((boolean)cookie.hasAttribute("foo"));
        Assert.assertTrue((boolean)cookie.hasAttribute("bar"));
        Assert.assertTrue((boolean)cookie.hasAttribute("bing"));
        Assert.assertFalse((boolean)cookie.hasAttribute("booya"));
        Assert.assertFalse((boolean)cookie.hasAttribute("baz"));
        Assert.assertFalse((boolean)cookie.hasAttribute("boom"));
    }

    @Test(dataProvider="schemes")
    public void roundTripMultiple(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            Assert.assertEquals((String)hTTPRequest.getPath(), (String)"/api/system/version");
            Assert.assertEquals((String)hTTPRequest.getCookie((String)"request").value, (String)"request-value");
            Assert.assertEquals((String)hTTPRequest.getCookie((String)"request-2").value, (String)"request-value-2");
            hTTPResponse.addCookie((Cookie)new Cookie("response", "response-value").with(cookie -> cookie.setSameSite(Cookie.SameSite.Lax)));
            hTTPResponse.addCookie((Cookie)new Cookie("response-2", "response-value-2").with(cookie -> cookie.setMaxAge(Long.valueOf(42L))));
            hTTPResponse.setStatus(200);
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            URI uRI = this.makeURI(string, "");
            CookieManager cookieManager = new CookieManager();
            HttpClient httpClient = this.makeClient(string, cookieManager);
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Cookie", "request=request-value").header("Cookie", "request-2=request-value-2").header("Content-Type", "application/json").GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            List<HttpCookie> list = cookieManager.getCookieStore().get(uRI);
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((int)list.size(), (int)2);
            Assert.assertEquals((String)list.stream().filter(httpCookie -> httpCookie.getName().equals("response")).findFirst().orElseThrow().getValue(), (String)"response-value");
            Assert.assertEquals((String)list.stream().filter(httpCookie -> httpCookie.getName().equals("response-2")).findFirst().orElseThrow().getValue(), (String)"response-value-2");
            Assert.assertTrue((boolean)httpResponse.headers().allValues("Set-Cookie").contains("response=response-value; SameSite=Lax"));
            Assert.assertTrue((boolean)httpResponse.headers().allValues("Set-Cookie").contains("response-2=response-value-2; Max-Age=42"));
        }
    }

    @Test(dataProvider="schemes")
    public void roundTripSingle(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            Assert.assertEquals((String)hTTPRequest.getPath(), (String)"/api/system/version");
            Assert.assertEquals((String)hTTPRequest.getCookie((String)"request").value, (String)"request-value");
            hTTPResponse.addCookie((Cookie)new Cookie("response", "response-value").with(cookie -> cookie.setSameSite(Cookie.SameSite.Lax)));
            hTTPResponse.setStatus(200);
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            URI uRI = this.makeURI(string, "");
            CookieManager cookieManager = new CookieManager();
            HttpClient httpClient = this.makeClient(string, cookieManager);
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Cookie", "request=request-value").header("Content-Type", "application/json").GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            List<HttpCookie> list = cookieManager.getCookieStore().get(uRI);
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((int)list.size(), (int)1);
            Assert.assertEquals((String)list.get(0).getName(), (String)"response");
            Assert.assertEquals((String)list.get(0).getValue(), (String)"response-value");
            Assert.assertEquals((String)httpResponse.headers().firstValue("Set-Cookie").orElse(null), (String)"response=response-value; SameSite=Lax");
        }
    }

    @Test
    public void toRequestHeader() {
        Assert.assertEquals((String)"foo=bar", (String)new Cookie("foo", "bar").toRequestHeader());
    }
}

