/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.util;

import io.fusionauth.http.util.HTTPTools;

public enum RequestPreambleState {
    RequestMethod{

        @Override
        public RequestPreambleState next(byte by) {
            if (by == 32) {
                return RequestMethodSP;
            }
            if (HTTPTools.isTokenCharacter(by)) {
                return RequestMethod;
            }
            throw HTTPTools.makeParseException(by, this);
        }

        @Override
        public boolean store() {
            return true;
        }
    }
    ,
    RequestMethodSP{

        @Override
        public RequestPreambleState next(byte by) {
            if (by == 32) {
                return RequestMethodSP;
            }
            if (HTTPTools.isURICharacter(by)) {
                return RequestPath;
            }
            throw HTTPTools.makeParseException(by, this);
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    RequestPath{

        @Override
        public RequestPreambleState next(byte by) {
            if (by == 32) {
                return RequestPathSP;
            }
            if (HTTPTools.isURICharacter(by)) {
                return RequestPath;
            }
            throw HTTPTools.makeParseException(by, this);
        }

        @Override
        public boolean store() {
            return true;
        }
    }
    ,
    RequestPathSP{

        @Override
        public RequestPreambleState next(byte by) {
            if (by == 32) {
                return RequestPathSP;
            }
            if (HTTPTools.isURICharacter(by)) {
                return RequestProtocol;
            }
            throw HTTPTools.makeParseException(by, this);
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    RequestProtocol{

        @Override
        public RequestPreambleState next(byte by) {
            if (by == 72 || by == 84 || by == 80 || by == 47 || by == 46 || by >= 48 && by <= 57) {
                return RequestProtocol;
            }
            if (by == 13) {
                return RequestCR;
            }
            throw HTTPTools.makeParseException(by, this);
        }

        @Override
        public boolean store() {
            return true;
        }
    }
    ,
    RequestCR{

        @Override
        public RequestPreambleState next(byte by) {
            if (by == 10) {
                return RequestLF;
            }
            throw HTTPTools.makeParseException(by, this);
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    RequestLF{

        @Override
        public RequestPreambleState next(byte by) {
            if (by == 13) {
                return PreambleCR;
            }
            if (HTTPTools.isTokenCharacter(by)) {
                return HeaderName;
            }
            throw HTTPTools.makeParseException(by, this);
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    HeaderName{

        @Override
        public RequestPreambleState next(byte by) {
            if (HTTPTools.isTokenCharacter(by)) {
                return HeaderName;
            }
            if (by == 58) {
                return HeaderColon;
            }
            throw HTTPTools.makeParseException(by, this);
        }

        @Override
        public boolean store() {
            return true;
        }
    }
    ,
    HeaderColon{

        @Override
        public RequestPreambleState next(byte by) {
            if (by == 32) {
                return HeaderColon;
            }
            if (by == 13) {
                return HeaderCR;
            }
            return HeaderValue;
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    HeaderValue{

        @Override
        public RequestPreambleState next(byte by) {
            if (by == 13) {
                return HeaderCR;
            }
            if (HTTPTools.isValueCharacter(by)) {
                return HeaderValue;
            }
            throw HTTPTools.makeParseException(by, this);
        }

        @Override
        public boolean store() {
            return true;
        }
    }
    ,
    HeaderCR{

        @Override
        public RequestPreambleState next(byte by) {
            if (by == 10) {
                return HeaderLF;
            }
            throw HTTPTools.makeParseException(by, this);
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    HeaderLF{

        @Override
        public RequestPreambleState next(byte by) {
            if (by == 13) {
                return PreambleCR;
            }
            if (HTTPTools.isTokenCharacter(by)) {
                return HeaderName;
            }
            throw HTTPTools.makeParseException(by, this);
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    PreambleCR{

        @Override
        public RequestPreambleState next(byte by) {
            if (by == 10) {
                return Complete;
            }
            throw HTTPTools.makeParseException(by, this);
        }

        @Override
        public boolean store() {
            return false;
        }
    }
    ,
    Complete{

        @Override
        public RequestPreambleState next(byte by) {
            return null;
        }

        @Override
        public boolean store() {
            return false;
        }
    };


    public abstract RequestPreambleState next(byte var1);

    public abstract boolean store();
}

