/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server.io;

import io.fusionauth.http.io.ChunkedOutputStream;
import io.fusionauth.http.server.HTTPResponse;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.Instrumenter;
import io.fusionauth.http.server.internal.HTTPBuffers;
import io.fusionauth.http.util.HTTPTools;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class HTTPOutputStream
extends OutputStream {
    private final List<String> acceptEncodings;
    private final HTTPBuffers buffers;
    private final Instrumenter instrumenter;
    private final HTTPResponse response;
    private final ServerToSocketOutputStream serverToSocket;
    private boolean committed;
    private boolean compress;
    private OutputStream delegate;
    private boolean wroteOneByteToClient;

    public HTTPOutputStream(HTTPServerConfiguration hTTPServerConfiguration, List<String> list, HTTPResponse hTTPResponse, OutputStream outputStream, HTTPBuffers hTTPBuffers, Runnable runnable) {
        this.acceptEncodings = list;
        this.response = hTTPResponse;
        this.buffers = hTTPBuffers;
        this.compress = hTTPServerConfiguration.isCompressByDefault();
        this.instrumenter = hTTPServerConfiguration.getInstrumenter();
        this.serverToSocket = new ServerToSocketOutputStream(outputStream, hTTPBuffers, runnable);
        this.delegate = this.serverToSocket;
    }

    @Override
    public void close() throws IOException {
        this.commit(true);
        this.delegate.close();
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    public void forceFlush() throws IOException {
        this.commit(false);
        this.delegate.flush();
        this.serverToSocket.forceFlush();
    }

    public boolean isCommitted() {
        return this.wroteOneByteToClient;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean bl) {
        if (this.committed) {
            throw new IllegalStateException("The HTTPResponse compression configuration cannot be modified once bytes have been written to it.");
        }
        this.compress = bl;
    }

    public void reset() {
        if (this.wroteOneByteToClient) {
            throw new IllegalStateException("The HTTPOutputStream can't be reset after it has been committed, meaning at least one byte was written back to the client.");
        }
        this.serverToSocket.reset();
        this.committed = false;
        this.compress = false;
        this.delegate = this.serverToSocket;
    }

    public boolean willCompress() {
        if (this.compress) {
            for (String string : this.acceptEncodings) {
                if (string.equalsIgnoreCase("gzip")) {
                    return true;
                }
                if (!string.equalsIgnoreCase("deflate")) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.commit(false);
        this.delegate.write(byArray, n, n2);
        if (this.instrumenter != null) {
            this.instrumenter.wroteToClient(n2);
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.commit(false);
        this.delegate.write(n);
        if (this.instrumenter != null) {
            this.instrumenter.wroteToClient(1L);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    private void commit(boolean bl) throws IOException {
        if (this.committed) {
            return;
        }
        this.committed = true;
        boolean bl2 = this.response.getStatus() == 204;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (bl && !bl2) {
            this.response.setContentLength(0L);
        } else {
            if (this.compress && !bl2) {
                for (String string : this.acceptEncodings) {
                    if (string.equalsIgnoreCase("gzip")) {
                        this.response.setHeader("Content-Encoding", "gzip");
                        this.response.setHeader("Vary", "Accept-Encoding");
                        this.response.removeHeader("Content-Length");
                        bl3 = true;
                        break;
                    }
                    if (!string.equalsIgnoreCase("deflate")) continue;
                    this.response.setHeader("Content-Encoding", "deflate");
                    this.response.setHeader("Vary", "Accept-Encoding");
                    this.response.removeHeader("Content-Length");
                    bl4 = true;
                    break;
                }
            }
            if (this.response.getContentLength() == null && !bl2) {
                this.response.setHeader("Transfer-Encoding", "chunked");
                bl5 = true;
            }
        }
        HTTPTools.writeResponsePreamble(this.response, this.delegate);
        if (bl || bl2) {
            return;
        }
        if (bl5) {
            this.delegate = new ChunkedOutputStream(this.delegate, this.buffers.chunkBuffer(), this.buffers.chuckedOutputStream());
            if (this.instrumenter != null) {
                this.instrumenter.chunkedResponse();
            }
        }
        if (bl3) {
            try {
                this.delegate = new GZIPOutputStream(this.delegate, true);
                this.response.setHeader("Content-Encoding", "gzip");
                this.response.setHeader("Vary", "Accept-Encoding");
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        } else if (bl4) {
            this.delegate = new DeflaterOutputStream(this.delegate, true);
        }
    }

    private class ServerToSocketOutputStream
    extends OutputStream {
        private final byte[] buffer;
        private final OutputStream delegate;
        private final byte[] intsAreDumb = new byte[1];
        private final Runnable writeObserver;
        private int bufferIndex;

        public ServerToSocketOutputStream(OutputStream outputStream, HTTPBuffers hTTPBuffers, Runnable runnable) {
            this.delegate = outputStream;
            this.buffer = hTTPBuffers.responseBuffer();
            this.bufferIndex = 0;
            this.writeObserver = runnable;
        }

        @Override
        public void close() throws IOException {
            this.forceFlush();
        }

        @Override
        public void flush() throws IOException {
            if (this.buffer == null || (double)this.bufferIndex >= (double)this.buffer.length * 0.9) {
                this.forceFlush();
            }
        }

        public void forceFlush() throws IOException {
            if (this.buffer == null || this.bufferIndex == 0) {
                return;
            }
            HTTPOutputStream.this.wroteOneByteToClient = true;
            this.delegate.write(this.buffer, 0, this.bufferIndex);
            this.delegate.flush();
            this.bufferIndex = 0;
        }

        public void reset() {
            this.bufferIndex = 0;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.writeObserver.run();
            if (this.buffer == null) {
                this.delegate.write(byArray, n, n2);
            } else {
                do {
                    int n3 = this.buffer.length - this.bufferIndex;
                    int n4 = Math.min(n3, n2);
                    System.arraycopy(byArray, n, this.buffer, this.bufferIndex, n4);
                    this.bufferIndex += n4;
                    n += n4;
                    n2 -= n4;
                    if (this.bufferIndex < this.buffer.length) continue;
                    this.forceFlush();
                } while (n2 > 0);
            }
        }

        @Override
        public void write(int n) throws IOException {
            this.intsAreDumb[0] = (byte)n;
            this.write(this.intsAreDumb, 0, 1);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }
    }
}

