/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server.internal;

import io.fusionauth.http.HTTPProcessingException;
import io.fusionauth.http.ParseException;
import io.fusionauth.http.io.MultipartConfiguration;
import io.fusionauth.http.io.MultipartFileManager;
import io.fusionauth.http.io.MultipartStreamProcessor;
import io.fusionauth.http.io.PushbackInputStream;
import io.fusionauth.http.log.Logger;
import io.fusionauth.http.server.ExceptionHandlerContext;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.Instrumenter;
import io.fusionauth.http.server.internal.HTTPBuffers;
import io.fusionauth.http.server.io.ConnectionClosedException;
import io.fusionauth.http.server.io.HTTPInputStream;
import io.fusionauth.http.server.io.HTTPOutputStream;
import io.fusionauth.http.server.io.Throughput;
import io.fusionauth.http.server.io.ThroughputInputStream;
import io.fusionauth.http.server.io.ThroughputOutputStream;
import io.fusionauth.http.server.io.TooManyBytesToDrainException;
import io.fusionauth.http.util.HTTPTools;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;

public class HTTPWorker
implements Runnable {
    private final HTTPBuffers buffers;
    private final HTTPServerConfiguration configuration;
    private final PushbackInputStream inputStream;
    private final Instrumenter instrumenter;
    private final HTTPListenerConfiguration listener;
    private final Logger logger;
    private final Socket socket;
    private final long startInstant;
    private final Throughput throughput;
    private long handledRequests;
    private volatile State state;

    public HTTPWorker(Socket socket, HTTPServerConfiguration hTTPServerConfiguration, Instrumenter instrumenter, HTTPListenerConfiguration hTTPListenerConfiguration, Throughput throughput) throws IOException {
        this.socket = socket;
        this.configuration = hTTPServerConfiguration;
        this.instrumenter = instrumenter;
        this.listener = hTTPListenerConfiguration;
        this.throughput = throughput;
        this.buffers = new HTTPBuffers(hTTPServerConfiguration);
        this.logger = hTTPServerConfiguration.getLoggerFactory().getLogger(HTTPWorker.class);
        this.inputStream = new PushbackInputStream(new ThroughputInputStream(socket.getInputStream(), throughput), instrumenter);
        this.state = State.Read;
        this.startInstant = System.currentTimeMillis();
        this.logger.trace("[{}] Starting HTTP worker.", Thread.currentThread().threadId());
    }

    public long getHandledRequests() {
        return this.handledRequests;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public long getStartInstant() {
        return this.startInstant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Object object;
        Object object2;
        HTTPRequest hTTPRequest = null;
        HTTPResponse hTTPResponse = null;
        try {
            if (this.instrumenter != null) {
                this.instrumenter.workerStarted();
            }
            while (true) {
                boolean bl;
                HTTPInputStream hTTPInputStream;
                block46: {
                    Iterator<Path> iterator;
                    int n;
                    this.logger.trace("[{}] Running HTTP worker. Block while we wait to read the preamble", Thread.currentThread().threadId());
                    hTTPRequest = new HTTPRequest(this.configuration.getContextPath(), this.listener.getCertificate() != null ? "https" : "http", this.listener.getPort(), this.socket.getInetAddress().getHostAddress());
                    hTTPRequest.getMultiPartStreamProcessor().setMultipartConfiguration(new MultipartConfiguration(this.configuration.getMultipartConfiguration()));
                    ThroughputOutputStream throughputOutputStream = new ThroughputOutputStream(this.socket.getOutputStream(), this.throughput);
                    hTTPResponse = new HTTPResponse();
                    object2 = new HTTPOutputStream(this.configuration, hTTPRequest.getAcceptEncodings(), hTTPResponse, throughputOutputStream, this.buffers, () -> {
                        this.state = State.Write;
                    });
                    hTTPResponse.setOutputStream((HTTPOutputStream)object2);
                    object = this.buffers.requestBuffer();
                    HTTPTools.parseRequestPreamble(this.inputStream, this.configuration.getMaxRequestHeaderSize(), hTTPRequest, (byte[])object, () -> {
                        this.state = State.Read;
                    });
                    if (this.logger.isTraceEnabled() && (n = this.inputStream.getAvailableBufferedBytesRemaining()) != 0) {
                        this.logger.trace("[{}] Preamble parser had [{}] left over bytes. These will be used in the HTTPInputStream.", n);
                    }
                    ++this.handledRequests;
                    if (this.instrumenter != null) {
                        this.instrumenter.acceptedRequest();
                    }
                    n = HTTPTools.getMaxRequestBodySize(hTTPRequest.getContentType(), this.configuration.getMaxRequestBodySize());
                    hTTPInputStream = new HTTPInputStream(this.configuration, hTTPRequest, this.inputStream, n);
                    hTTPRequest.setInputStream(hTTPInputStream);
                    hTTPResponse.setHeader("Connection", hTTPRequest.isKeepAlive() ? "keep-alive" : "close");
                    Integer n2 = this.validatePreamble(hTTPRequest);
                    if (n2 != null) {
                        this.closeSocketOnError(hTTPResponse, n2);
                        return;
                    }
                    String string = hTTPRequest.getHeader("Expect");
                    if (string != null && string.equalsIgnoreCase("100-continue")) {
                        this.state = State.Write;
                        bl = this.handleExpectContinue(hTTPRequest);
                        if (!bl) {
                            this.closeSocketOnly(CloseSocketReason.Expected);
                            return;
                        }
                        this.state = State.Read;
                    }
                    this.state = State.Process;
                    this.logger.trace("[{}] Set state [{}]. Call the request handler.", new Object[]{Thread.currentThread().threadId(), this.state});
                    try {
                        this.configuration.getHandler().handle(hTTPRequest, hTTPResponse);
                        this.logger.trace("[{}] Handler completed successfully", Thread.currentThread().threadId());
                        MultipartStreamProcessor multipartStreamProcessor = hTTPRequest.getMultiPartStreamProcessor();
                        if (!multipartStreamProcessor.getMultiPartConfiguration().isDeleteTemporaryFiles()) break block46;
                        MultipartFileManager multipartFileManager = multipartStreamProcessor.getMultipartFileManager();
                        iterator = multipartFileManager.getTemporaryFiles().iterator();
                    }
                    catch (Throwable throwable) {
                        MultipartStreamProcessor multipartStreamProcessor = hTTPRequest.getMultiPartStreamProcessor();
                        if (!multipartStreamProcessor.getMultiPartConfiguration().isDeleteTemporaryFiles()) throw throwable;
                        MultipartFileManager multipartFileManager2 = multipartStreamProcessor.getMultipartFileManager();
                        Iterator<Path> iterator2 = multipartFileManager2.getTemporaryFiles().iterator();
                        while (iterator2.hasNext()) {
                            Path path = iterator2.next();
                            try {
                                this.logger.debug("Delete temporary file [{}]", path);
                                Files.deleteIfExists(path);
                            }
                            catch (Exception exception) {
                                this.logger.error("Unable to delete temporary file. [" + String.valueOf(path) + "]", exception);
                            }
                        }
                        throw throwable;
                    }
                    while (iterator.hasNext()) {
                        Path path = iterator.next();
                        try {
                            this.logger.debug("Delete temporary file [{}]", path);
                            Files.deleteIfExists(path);
                        }
                        catch (Exception exception) {
                            this.logger.error("Unable to delete temporary file. [" + String.valueOf(path) + "]", exception);
                        }
                    }
                }
                if (this.handledRequests >= (long)this.configuration.getMaxRequestsPerConnection()) {
                    this.logger.trace("[{}] Maximum requests per connection has been reached. Turn off Keep-Alive.", Thread.currentThread().threadId());
                    hTTPResponse.setHeader("Connection", "close");
                }
                hTTPResponse.close();
                bl = this.keepSocketAlive(hTTPRequest, hTTPResponse);
                if (!bl) {
                    this.logger.trace("[{}] Closing socket. No Keep-Alive.", Thread.currentThread().threadId());
                    this.closeSocketOnly(CloseSocketReason.Expected);
                    return;
                }
                this.state = State.KeepAlive;
                int n = (int)this.configuration.getKeepAliveTimeoutDuration().toMillis();
                this.logger.trace("[{}] Enter Keep-Alive state [{}] Reset socket timeout [{}].", new Object[]{Thread.currentThread().threadId(), this.state, n});
                this.socket.setSoTimeout(n);
                long l = System.currentTimeMillis();
                int n3 = hTTPInputStream.drain();
                if (n3 <= 0 || !this.logger.isTraceEnabled()) continue;
                long l2 = System.currentTimeMillis() - l;
                this.logger.trace("[{}] Drained [{}] bytes from the InputStream. Duration [{}] ms.", Thread.currentThread().threadId(), n3, l2);
                continue;
                break;
            }
        }
        catch (ConnectionClosedException connectionClosedException) {
            this.logger.trace("[{}] Closing socket. Client closed the connection. Reason [{}].", Thread.currentThread().threadId(), connectionClosedException.getMessage());
            this.closeSocketOnly(CloseSocketReason.Expected);
            return;
        }
        catch (HTTPProcessingException hTTPProcessingException) {
            this.logger.debug("[{}] Closing socket with status [{}]. An unhandled [{}] exception was taken. Reason [{}].", Thread.currentThread().threadId(), hTTPProcessingException.getStatus(), hTTPProcessingException.getClass().getSimpleName(), hTTPProcessingException.getMessage());
            this.closeSocketOnError(hTTPResponse, hTTPProcessingException.getStatus());
            return;
        }
        catch (TooManyBytesToDrainException tooManyBytesToDrainException) {
            this.logger.debug("[{}] Closing socket [{}]. Too many bytes remaining in the InputStream. Drained [{}] bytes. Configured maximum bytes [{}].", new Object[]{Thread.currentThread().threadId(), this.state, tooManyBytesToDrainException.getDrainedBytes(), tooManyBytesToDrainException.getMaximumDrainedBytes()});
            this.closeSocketOnly(CloseSocketReason.Expected);
            return;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            object2 = this.state == State.KeepAlive ? CloseSocketReason.Expected : CloseSocketReason.Unexpected;
            Object object3 = object = this.state == State.Read ? "Initial read timeout" : "Keep-Alive expired";
            if (object2 == CloseSocketReason.Expected) {
                this.logger.trace("[{}] Closing socket [{}]. {}.", new Object[]{Thread.currentThread().threadId(), this.state, object});
            } else {
                this.logger.debug("[{}] Closing socket [{}]. {}.", new Object[]{Thread.currentThread().threadId(), this.state, object});
            }
            this.closeSocketOnly((CloseSocketReason)((Object)object2));
            return;
        }
        catch (ParseException parseException) {
            this.logger.debug("[{}] Closing socket with status [{}]. Bad request, failed to parse request. Reason [{}] Parser state [{}]", Thread.currentThread().threadId(), 400, parseException.getMessage(), parseException.getState());
            this.closeSocketOnError(hTTPResponse, 400);
            return;
        }
        catch (SocketException socketException) {
            if (Thread.currentThread().isInterrupted()) {
                this.logger.debug("[{}] Closing socket. Server is shutting down.", Thread.currentThread().threadId());
            } else {
                this.logger.debug("[{}] Closing socket. The socket was closed by a client, proxy or otherwise.", Thread.currentThread().threadId());
            }
            this.closeSocketOnly(CloseSocketReason.Expected);
            return;
        }
        catch (IOException iOException) {
            this.logger.debug(String.format("[%s] Closing socket with status [%d]. An IO exception was thrown during processing. These are pretty common.", Thread.currentThread().threadId(), 500), iOException);
            this.closeSocketOnError(hTTPResponse, 500);
            return;
        }
        catch (Throwable throwable) {
            object2 = new ExceptionHandlerContext(this.logger, hTTPRequest, 500, throwable);
            try {
                this.configuration.getUnexpectedExceptionHandler().handle((ExceptionHandlerContext)object2);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            this.closeSocketOnError(hTTPResponse, ((ExceptionHandlerContext)object2).getStatusCode());
            return;
        }
        finally {
            if (this.instrumenter != null) {
                this.instrumenter.workerStopped();
            }
        }
    }

    public State state() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocketOnError(HTTPResponse hTTPResponse, int n) {
        if (n >= 400 && n <= 499 && this.instrumenter != null) {
            this.instrumenter.badRequest();
        }
        try {
            if (hTTPResponse != null && !hTTPResponse.isCommitted()) {
                hTTPResponse.reset();
                hTTPResponse.setHeader("Connection", "close");
                hTTPResponse.setStatus(n);
                hTTPResponse.setContentLength(0L);
                hTTPResponse.close();
            }
        }
        catch (IOException iOException) {
            this.logger.debug(String.format("[%s] Could not close the HTTP response.", Thread.currentThread().threadId()), iOException);
        }
        finally {
            this.closeSocketOnly(CloseSocketReason.Unexpected);
        }
    }

    private void closeSocketOnly(CloseSocketReason closeSocketReason) {
        if (closeSocketReason == CloseSocketReason.Unexpected && this.instrumenter != null) {
            this.instrumenter.connectionClosed();
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            this.logger.debug(String.format("[%s] Could not close the socket.", Thread.currentThread().threadId()), iOException);
        }
    }

    private boolean handleExpectContinue(HTTPRequest hTTPRequest) throws IOException {
        HTTPResponse hTTPResponse = new HTTPResponse();
        this.configuration.getExpectValidator().validate(hTTPRequest, hTTPResponse);
        OutputStream outputStream = this.socket.getOutputStream();
        HTTPTools.writeResponsePreamble(hTTPResponse, outputStream);
        outputStream.flush();
        return hTTPResponse.getStatus() == 100;
    }

    private boolean keepSocketAlive(HTTPRequest hTTPRequest, HTTPResponse hTTPResponse) {
        String string = hTTPResponse.getHeader("Connection");
        return hTTPRequest.getProtocol().equals("HTTP/1.1") ? !"close".equalsIgnoreCase(string) : "keep-alive".equalsIgnoreCase(string);
    }

    private Integer validatePreamble(HTTPRequest hTTPRequest) {
        List<String> list;
        boolean bl = this.logger.isDebugEnabled();
        String string = hTTPRequest.getProtocol();
        if (string == null) {
            this.logger.debug("Invalid request. Missing HTTP Protocol");
            return 400;
        }
        if (!string.startsWith("HTTP/")) {
            if (bl) {
                this.logger.debug("Invalid request. Invalid protocol [{}]. Supported versions [{}].", string, "HTTP/1.1");
            }
            return 400;
        }
        if (!string.equals("HTTP/1.0") && !string.equals("HTTP/1.1")) {
            if (bl) {
                this.logger.debug("Invalid request. Unsupported HTTP version [{}]. Supported versions [{}].", string, "HTTP/1.1");
            }
            return 505;
        }
        String string2 = hTTPRequest.getRawHost();
        if (string2 == null) {
            this.logger.debug("Invalid request. Missing Host header.");
            return 400;
        }
        List<String> list2 = hTTPRequest.getHeaders("Host");
        if (list2.size() != 1) {
            if (bl) {
                this.logger.debug("Invalid request. Duplicate Host headers. [{}]", String.join((CharSequence)", ", list2));
            }
            return 400;
        }
        if (hTTPRequest.getHeader("Transfer-Encoding") == null) {
            list = hTTPRequest.getHeaders("Content-Length");
            if (list != null) {
                if (list.size() != 1) {
                    if (bl) {
                        this.logger.debug("Invalid request. Duplicate Content-Length headers. [{}]", String.join((CharSequence)", ", list));
                    }
                    return 400;
                }
                Long l = hTTPRequest.getContentLength();
                if (l == null || l < 0L) {
                    if (bl) {
                        this.logger.debug("Invalid request. The Content-Length must be >= 0 and <= 9,223,372,036,854,775,807. [{}]", list.getFirst());
                    }
                    return 400;
                }
            }
        } else {
            hTTPRequest.setContentLength(null);
            hTTPRequest.removeHeader("Content-Length");
        }
        list = hTTPRequest.getContentEncodings();
        for (String string3 : list) {
            if (string3.equalsIgnoreCase("gzip") || string3.equalsIgnoreCase("deflate")) continue;
            String string4 = hTTPRequest.getHeaders("Content-Encoding").getLast();
            this.logger.debug("Invalid request. The Content-Type header contains an un-supported value. [{}]", string4);
            return 415;
        }
        return null;
    }

    public static enum State {
        Read,
        Process,
        Write,
        KeepAlive;

    }

    private static enum CloseSocketReason {
        Expected,
        Unexpected;

    }

    private static class Status {
        public static final int BadRequest = 400;
        public static final int HTTPVersionNotSupported = 505;
        public static final int InternalServerError = 500;
        public static final int UnsupportedMediaType = 415;

        private Status() {
        }
    }
}

