/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.log.Logger;
import io.fusionauth.http.server.Configurable;
import io.fusionauth.http.server.HTTPContext;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.internal.HTTPServerThread;
import io.fusionauth.http.util.HTTPTools;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;

public class HTTPServer
implements Closeable,
Configurable<HTTPServer> {
    private final List<HTTPServerThread> servers = new ArrayList<HTTPServerThread>();
    private HTTPServerConfiguration configuration = new HTTPServerConfiguration();
    private volatile HTTPContext context;
    private Logger logger;

    @Override
    public void close() {
        long l = System.currentTimeMillis();
        long l2 = this.configuration.getShutdownDuration().toMillis();
        this.logger.info("HTTP server shutdown requested. Attempting to close each listener. Wait up to [{}] ms.", l2);
        for (HTTPServerThread thread : this.servers) {
            thread.shutdown();
        }
        for (Thread thread : this.servers) {
            try {
                thread.join(l2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() - l <= l2) continue;
            break;
        }
        this.logger.info("HTTP server shutdown successfully.");
    }

    @Override
    public HTTPServerConfiguration configuration() {
        return this.configuration;
    }

    public HTTPContext getContext() {
        return this.context;
    }

    public HTTPServer start() {
        if (this.context != null) {
            return this;
        }
        this.logger = this.configuration.getLoggerFactory().getLogger(HTTPServer.class);
        HTTPTools.initialize(this.configuration().getLoggerFactory());
        this.logger.info("Starting the HTTP server. Buckle up!");
        this.context = new HTTPContext(this.configuration.getBaseDir());
        try {
            for (HTTPListenerConfiguration hTTPListenerConfiguration : this.configuration.getListeners()) {
                HTTPServerThread hTTPServerThread = new HTTPServerThread(this.configuration, hTTPListenerConfiguration);
                this.servers.add(hTTPServerThread);
                hTTPServerThread.start();
                this.logger.info("HTTP server listening on port [{}]", hTTPListenerConfiguration.getPort());
            }
            this.logger.info("HTTP server started successfully");
        }
        catch (Exception exception) {
            this.logger.error("Unable to start the HTTP server because one of the listeners threw an exception.", exception);
            this.close();
        }
        return this;
    }

    public HTTPServer withConfiguration(HTTPServerConfiguration hTTPServerConfiguration) {
        this.configuration = hTTPServerConfiguration;
        this.logger = hTTPServerConfiguration.getLoggerFactory().getLogger(HTTPServer.class);
        return this;
    }
}

