/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.security.SecurityTools;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class HTTPListenerConfiguration {
    private final InetAddress bindAddress;
    private final Certificate[] certificateChain;
    private final int port;
    private final PrivateKey privateKey;
    private final boolean tls;

    public HTTPListenerConfiguration(int n) {
        this.bindAddress = this.allInterfaces();
        this.port = n;
        this.tls = false;
        this.certificateChain = null;
        this.privateKey = null;
    }

    public HTTPListenerConfiguration(int n, String string, String string2) throws GeneralSecurityException {
        Objects.requireNonNull(string);
        Objects.requireNonNull(string2);
        this.bindAddress = this.allInterfaces();
        this.port = n;
        this.tls = true;
        this.certificateChain = SecurityTools.parseCertificates(string);
        this.privateKey = SecurityTools.parsePrivateKey(string2);
    }

    public HTTPListenerConfiguration(int n, Certificate certificate, PrivateKey privateKey) {
        Objects.requireNonNull(certificate);
        Objects.requireNonNull(privateKey);
        this.bindAddress = this.allInterfaces();
        this.port = n;
        this.tls = true;
        this.certificateChain = new Certificate[]{certificate};
        this.privateKey = privateKey;
    }

    public HTTPListenerConfiguration(int n, Certificate[] certificateArray, PrivateKey privateKey) {
        Objects.requireNonNull(certificateArray);
        Objects.requireNonNull(privateKey);
        this.bindAddress = this.allInterfaces();
        this.port = n;
        this.tls = true;
        this.certificateChain = certificateArray;
        this.privateKey = privateKey;
    }

    public HTTPListenerConfiguration(InetAddress inetAddress, int n) {
        Objects.requireNonNull(inetAddress);
        this.bindAddress = inetAddress;
        this.port = n;
        this.tls = false;
        this.certificateChain = null;
        this.privateKey = null;
    }

    public HTTPListenerConfiguration(InetAddress inetAddress, int n, String string, String string2) throws GeneralSecurityException {
        Objects.requireNonNull(inetAddress);
        Objects.requireNonNull(string);
        Objects.requireNonNull(string2);
        this.bindAddress = inetAddress;
        this.port = n;
        this.tls = true;
        this.certificateChain = SecurityTools.parseCertificates(string);
        this.privateKey = SecurityTools.parsePrivateKey(string2);
    }

    public HTTPListenerConfiguration(InetAddress inetAddress, int n, Certificate certificate, PrivateKey privateKey) {
        Objects.requireNonNull(inetAddress);
        Objects.requireNonNull(certificate);
        Objects.requireNonNull(privateKey);
        this.bindAddress = inetAddress;
        this.port = n;
        this.tls = true;
        this.certificateChain = new Certificate[]{certificate};
        this.privateKey = privateKey;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public Certificate getCertificate() {
        if (this.certificateChain != null && this.certificateChain.length > 0) {
            return this.certificateChain[0];
        }
        return null;
    }

    public Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    public int getPort() {
        return this.port;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public boolean isTLS() {
        return this.tls;
    }

    private InetAddress allInterfaces() {
        try {
            boolean bl = Collections.list(NetworkInterface.getNetworkInterfaces()).stream().map(NetworkInterface::getInterfaceAddresses).flatMap(Collection::stream).map(InterfaceAddress::getAddress).anyMatch(inetAddress -> !inetAddress.isLoopbackAddress() && inetAddress instanceof Inet6Address);
            if (bl) {
                return InetAddress.getByName("::");
            }
            return InetAddress.getByName("0.0.0.0");
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }
}

