/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.log;

import io.fusionauth.http.log.Level;
import io.fusionauth.http.log.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;

public abstract class BaseLogger
implements Logger {
    protected Level level = Level.Info;

    @Override
    public void debug(String string) {
        if (this.getLevelOrdinal() <= Level.Debug.ordinal()) {
            this.handleMessage(this.format(string, new Object[0]));
        }
    }

    @Override
    public void debug(String string, Object ... objectArray) {
        if (this.getLevelOrdinal() <= Level.Debug.ordinal()) {
            this.handleMessage(this.format(string, objectArray));
        }
    }

    @Override
    public void debug(String string, Throwable throwable) {
        if (this.getLevelOrdinal() <= Level.Debug.ordinal()) {
            this.handleMessage(this.format(string, throwable));
        }
    }

    @Override
    public void error(String string, Throwable throwable) {
        if (this.getLevelOrdinal() <= Level.Error.ordinal()) {
            this.handleMessage(this.format(string, throwable));
        }
    }

    @Override
    public void error(String string) {
        if (this.getLevelOrdinal() <= Level.Error.ordinal()) {
            this.handleMessage(this.format(string, new Object[0]));
        }
    }

    @Override
    public void info(String string) {
        if (this.getLevelOrdinal() <= Level.Info.ordinal()) {
            this.handleMessage(this.format(string, new Object[0]));
        }
    }

    @Override
    public void info(String string, Object ... objectArray) {
        if (this.getLevelOrdinal() <= Level.Info.ordinal()) {
            this.handleMessage(this.format(string, objectArray));
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLevelOrdinal() <= Level.Debug.ordinal();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.getLevelOrdinal() <= Level.Error.ordinal();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.getLevelOrdinal() <= Level.Info.ordinal();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLevelOrdinal() <= Level.Trace.ordinal();
    }

    @Override
    public void setLevel(Level level) {
        this.level = level;
    }

    @Override
    public void trace(String string, Object ... objectArray) {
        if (this.getLevelOrdinal() <= Level.Trace.ordinal()) {
            this.handleMessage(this.format(string, objectArray));
        }
    }

    @Override
    public void trace(String string) {
        if (this.getLevelOrdinal() <= Level.Trace.ordinal()) {
            this.handleMessage(this.format(string, new Object[0]));
        }
    }

    protected String format(String string, Throwable throwable) {
        if (throwable == null) {
            return string;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return this.timestamp() + string + "\n" + String.valueOf(stringWriter);
    }

    protected String format(String string, Object ... objectArray) {
        for (Object object : objectArray) {
            String string2 = object != null ? object.toString() : "null";
            string = string.replaceFirst("\\{}", Matcher.quoteReplacement(string2));
        }
        return this.timestamp() + string;
    }

    protected int getLevelOrdinal() {
        return this.level.ordinal();
    }

    protected abstract void handleMessage(String var1);

    protected String timestamp() {
        return System.currentTimeMillis() + " ";
    }
}

