/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.ParseException;
import io.fusionauth.http.io.ChunkException;
import io.fusionauth.http.io.PushbackInputStream;
import io.fusionauth.http.util.HTTPTools;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private final byte[] b1 = new byte[1];
    private final byte[] buffer;
    private final PushbackInputStream delegate;
    private final StringBuilder headerSizeHex = new StringBuilder();
    private int bufferIndex;
    private int bufferLength;
    private int chunkBytesRead;
    private int chunkBytesRemaining;
    private int chunkSize;
    private ChunkedBodyState state = ChunkedBodyState.ChunkSize;

    public ChunkedInputStream(PushbackInputStream pushbackInputStream, int n) {
        this.delegate = pushbackInputStream;
        this.buffer = new byte[n];
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n;
        block2: while (n4 < n2) {
            if (this.state == ChunkedBodyState.Complete) {
                this.pushBackOverReadBytes();
                break;
            }
            if (this.bufferIndex >= this.bufferLength) {
                this.bufferIndex = 0;
                this.bufferLength = this.delegate.read(this.buffer);
            }
            while (this.bufferIndex < this.bufferLength) {
                int n5;
                ChunkedBodyState chunkedBodyState;
                try {
                    chunkedBodyState = this.state.next(this.buffer[this.bufferIndex], this.chunkSize, this.chunkBytesRead);
                }
                catch (ParseException parseException) {
                    parseException.setIndex(this.bufferIndex);
                    throw parseException;
                }
                if (this.state == ChunkedBodyState.Complete) {
                    this.state = chunkedBodyState;
                    ++this.bufferIndex;
                    this.pushBackOverReadBytes();
                    continue block2;
                }
                if (chunkedBodyState == ChunkedBodyState.ChunkSize) {
                    this.headerSizeHex.appendCodePoint(this.buffer[this.bufferIndex]);
                    this.state = chunkedBodyState;
                    ++this.bufferIndex;
                    continue;
                }
                if (this.state != ChunkedBodyState.Chunk && chunkedBodyState == ChunkedBodyState.Chunk) {
                    if (this.headerSizeHex.isEmpty()) {
                        throw new ChunkException("Chunk size is missing");
                    }
                    this.chunkSize = (int)Long.parseLong(this.headerSizeHex, 0, this.headerSizeHex.length(), 16);
                    this.chunkBytesRead = 0;
                    this.chunkBytesRemaining = this.chunkSize;
                    this.headerSizeHex.delete(0, this.headerSizeHex.length());
                    if (this.chunkSize == 0) {
                        this.state = chunkedBodyState;
                        continue;
                    }
                }
                if (this.chunkBytesRemaining > 0) {
                    int n6 = this.bufferLength - this.bufferIndex;
                    n5 = Math.min(Math.min(this.chunkBytesRemaining, n6), n2 - n4);
                    if (n5 == 0) {
                        this.state = chunkedBodyState;
                        ++this.bufferIndex;
                        return n4 - n;
                    }
                } else {
                    this.state = chunkedBodyState;
                    ++this.bufferIndex;
                    continue;
                }
                System.arraycopy(this.buffer, this.bufferIndex, byArray, n4, n5);
                this.bufferIndex += n5;
                this.chunkBytesRead += n5;
                this.chunkBytesRemaining -= n5;
                this.state = chunkedBodyState;
                if ((n4 += n5) != n2) continue;
                continue block2;
            }
        }
        return (n3 = n4 - n) == 0 ? -1 : n3;
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.b1);
        if (n <= 0) {
            return n;
        }
        return this.b1[0] & 0xFF;
    }

    private void pushBackOverReadBytes() {
        int n = this.bufferLength - this.bufferIndex;
        if (n > 0) {
            this.delegate.push(this.buffer, this.bufferIndex, n);
            this.bufferIndex = this.bufferLength;
        }
    }

    public static enum ChunkedBodyState {
        ChunkExtensionStart{

            @Override
            public ChunkedBodyState next(byte by, long l, long l2) {
                if (by == 13) {
                    return ChunkExtensionCR;
                }
                if (HTTPTools.isTokenCharacter(by)) {
                    return ChunkExtensionName;
                }
                throw HTTPTools.makeParseException(by, this);
            }
        }
        ,
        ChunkExtensionName{

            @Override
            public ChunkedBodyState next(byte by, long l, long l2) {
                if (by == 13) {
                    return ChunkExtensionCR;
                }
                if (by == 61) {
                    return ChunkExtensionValueSep;
                }
                if (by == 59) {
                    return ChunkExtensionStart;
                }
                if (HTTPTools.isTokenCharacter(by)) {
                    return ChunkExtensionName;
                }
                throw HTTPTools.makeParseException(by, this);
            }
        }
        ,
        ChunkExtensionValueSep{

            @Override
            public ChunkedBodyState next(byte by, long l, long l2) {
                if (by == 13) {
                    return ChunkExtensionCR;
                }
                if (by == 59) {
                    return ChunkExtensionStart;
                }
                if (HTTPTools.isTokenCharacter(by)) {
                    return ChunkExtensionValue;
                }
                throw HTTPTools.makeParseException(by, this);
            }
        }
        ,
        ChunkExtensionValue{

            @Override
            public ChunkedBodyState next(byte by, long l, long l2) {
                if (by == 13) {
                    return ChunkExtensionCR;
                }
                if (by == 59) {
                    return ChunkExtensionStart;
                }
                if (HTTPTools.isTokenCharacter(by)) {
                    return ChunkExtensionValue;
                }
                throw HTTPTools.makeParseException(by, this);
            }
        }
        ,
        ChunkExtensionCR{

            @Override
            public ChunkedBodyState next(byte by, long l, long l2) {
                if (by == 10) {
                    return ChunkExtensionLF;
                }
                throw HTTPTools.makeParseException(by, this);
            }
        }
        ,
        ChunkExtensionLF{

            @Override
            public ChunkedBodyState next(byte by, long l, long l2) {
                return Chunk;
            }
        }
        ,
        ChunkSize{

            @Override
            public ChunkedBodyState next(byte by, long l, long l2) {
                if (by == 13) {
                    return ChunkSizeCR;
                }
                if (by == 59) {
                    return ChunkExtensionStart;
                }
                if (HTTPTools.isHexadecimalCharacter(by)) {
                    return ChunkSize;
                }
                throw HTTPTools.makeParseException(by, this);
            }
        }
        ,
        ChunkSizeCR{

            @Override
            public ChunkedBodyState next(byte by, long l, long l2) {
                if (by == 10) {
                    return ChunkSizeLF;
                }
                throw HTTPTools.makeParseException(by, this);
            }
        }
        ,
        ChunkSizeLF{

            @Override
            public ChunkedBodyState next(byte by, long l, long l2) {
                return Chunk;
            }
        }
        ,
        Chunk{

            @Override
            public ChunkedBodyState next(byte by, long l, long l2) {
                if (l == 0L) {
                    if (HTTPTools.isURICharacter(by)) {
                        return Trailer;
                    }
                    return Complete;
                }
                if (l2 == l && by == 13) {
                    return ChunkCR;
                }
                if (l2 < l) {
                    return Chunk;
                }
                throw HTTPTools.makeParseException(by, this);
            }
        }
        ,
        ChunkCR{

            @Override
            public ChunkedBodyState next(byte by, long l, long l2) {
                if (by == 10) {
                    return l == 0L ? Complete : ChunkLF;
                }
                throw HTTPTools.makeParseException(by, this);
            }
        }
        ,
        ChunkLF{

            @Override
            public ChunkedBodyState next(byte by, long l, long l2) {
                if (l == 0L) {
                    return Complete;
                }
                if (HTTPTools.isHexadecimalCharacter(by)) {
                    return ChunkSize;
                }
                throw HTTPTools.makeParseException(by, this);
            }
        }
        ,
        Complete{

            @Override
            public ChunkedBodyState next(byte by, long l, long l2) {
                return Complete;
            }
        }
        ,
        Trailer{

            @Override
            public ChunkedBodyState next(byte by, long l, long l2) {
                if (by == 13) {
                    return TrailerCR;
                }
                return Trailer;
            }
        }
        ,
        TrailerCR{

            @Override
            public ChunkedBodyState next(byte by, long l, long l2) {
                if (by == 10) {
                    return TrailerLF;
                }
                throw HTTPTools.makeParseException(by, this);
            }
        }
        ,
        TrailerLF{

            @Override
            public ChunkedBodyState next(byte by, long l, long l2) {
                if (HTTPTools.isURICharacter(by)) {
                    return Trailer;
                }
                return Complete;
            }
        };


        public abstract ChunkedBodyState next(byte var1, long var2, long var4);
    }
}

