/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.security;

import io.fusionauth.http.BaseTest;
import io.fusionauth.http.security.SecurityTools;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SecurityToolsTest
extends BaseTest {
    private static Path projectDir;

    @BeforeClass
    public static void setUp() {
        projectDir = Path.of("", new String[0]);
    }

    @Test
    public void securityContextMangling() throws Exception {
        SecurityToolsTest.setupCertificates();
        SecurityTools.clientContext((Certificate)certificate);
        SecurityTools.serverContext((Certificate)certificate, (PrivateKey)keyPair.getPrivate());
        try (HttpClient httpClient = HttpClient.newHttpClient();){
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create("https://fusionauth.io")).GET().build();
            HttpResponse httpResponse = httpClient.send(httpRequest, responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
        }
    }

    @Test
    public void testParseCertificateChain() throws Exception {
        String string = Files.readString(projectDir.resolve("src/test/resources/test-intermediate-server-combined.pem"));
        String string2 = Files.readString(projectDir.resolve("src/test/resources/test-root-ca.pem"));
        Certificate[] certificateArray = SecurityTools.parseCertificates((String)string);
        Certificate certificate = SecurityTools.parseCertificate((String)string2);
        Assert.assertEquals((int)certificateArray.length, (int)3);
        this.validateCertPath(certificate, certificateArray);
    }
}

