/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.FileInfo;
import io.fusionauth.http.ParseException;
import io.fusionauth.http.io.DefaultMultipartFileManager;
import io.fusionauth.http.io.MultipartConfiguration;
import io.fusionauth.http.io.MultipartFileManager;
import io.fusionauth.http.io.MultipartFileUploadPolicy;
import io.fusionauth.http.io.MultipartStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.testng.Assert;
import org.testng.FileAssert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class MultipartStreamTest {
    private MultipartFileManager fileManager;

    @AfterTest
    public void afterTest() {
        for (Path path : this.fileManager.getTemporaryFiles()) {
            try {
                Files.deleteIfExists(path);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    @DataProvider(name="badBoundary")
    public Object[][] badBoundary() {
        return new Object[][]{{"------WebKitFormBoundaryTWfMVJErBoLURJIe\r\nContent-Disposition: form-data; name=\"foo\"\r\n\r\nbar----WebKitFormBoundaryTWfMVJErBoLURJIe--"}, {"------WebKitFormBoundaryTWfMVJErBoLURJIe\r\nContent-Disposition: form-data; name=\"foo\"\r\n\r\nbar------WebKitFormBoundaryTWfMVJErBoLURJIe--"}};
    }

    @Test(dataProvider="badBoundary", expectedExceptions={ParseException.class}, expectedExceptionsMessageRegExp="Invalid multipart body. Ran out of data while processing.")
    public void bad_boundaryParameter(String string) throws IOException {
        new MultipartStream((InputStream)new ByteArrayInputStream(string.getBytes()), "----WebKitFormBoundaryTWfMVJErBoLURJIe".getBytes(), this.fileManager, new MultipartConfiguration().withFileUploadPolicy(MultipartFileUploadPolicy.Allow)).process(new HashMap(), new LinkedList());
    }

    @BeforeTest
    public void beforeTest() {
        MultipartConfiguration multipartConfiguration = new MultipartConfiguration();
        Path path = Paths.get(multipartConfiguration.getTemporaryFileLocation(), new String[0]);
        this.fileManager = new DefaultMultipartFileManager(path, multipartConfiguration.getTemporaryFilenamePrefix(), multipartConfiguration.getTemporaryFilenameSuffix());
    }

    @Test
    public void boundaryInParameter() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("------WebKitFormBoundaryTWfMVJErBoLURJIe\r\nContent-Disposition: form-data; name=\"foo\"\r\n\r\nbar------WebKitFormBoundaryTWfMVJErBoLURJIe\r\n------WebKitFormBoundaryTWfMVJErBoLURJIe--".getBytes());
        HashMap hashMap = new HashMap();
        LinkedList linkedList = new LinkedList();
        MultipartStream multipartStream = new MultipartStream((InputStream)byteArrayInputStream, "----WebKitFormBoundaryTWfMVJErBoLURJIe".getBytes(), this.fileManager, new MultipartConfiguration().withFileUploadPolicy(MultipartFileUploadPolicy.Allow));
        multipartStream.process(hashMap, linkedList);
        Assert.assertEquals((Collection)((Collection)hashMap.get("foo")), List.of("bar------WebKitFormBoundaryTWfMVJErBoLURJIe"));
    }

    @Test
    public void file() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("------WebKitFormBoundaryTWfMVJErBoLURJIe\r\nContent-Disposition: form-data; name=\"foo\"; filename=\"foo.jpg\"\r\n\r\nfilecontents\r\n------WebKitFormBoundaryTWfMVJErBoLURJIe--".getBytes());
        HashMap hashMap = new HashMap();
        LinkedList linkedList = new LinkedList();
        MultipartStream multipartStream = new MultipartStream((InputStream)byteArrayInputStream, "----WebKitFormBoundaryTWfMVJErBoLURJIe".getBytes(), this.fileManager, new MultipartConfiguration().withFileUploadPolicy(MultipartFileUploadPolicy.Allow));
        multipartStream.process(hashMap, linkedList);
        Assert.assertEquals((int)linkedList.size(), (int)1);
        Assert.assertEquals((String)((FileInfo)linkedList.get((int)0)).contentType, (String)"application/octet-stream");
        Assert.assertEquals((String)Files.readString(((FileInfo)linkedList.get((int)0)).file), (String)"filecontents");
        Assert.assertEquals((String)((FileInfo)linkedList.get((int)0)).fileName, (String)"foo.jpg");
        Assert.assertEquals((String)((FileInfo)linkedList.get((int)0)).name, (String)"foo");
        Files.delete(((FileInfo)linkedList.get((int)0)).file);
    }

    @Test
    public void mixed() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("------WebKitFormBoundaryTWfMVJErBoLURJIe\r\nContent-Disposition: form-data; name=\"foo\"\r\n\r\nbar\r\n------WebKitFormBoundaryTWfMVJErBoLURJIe\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.jpg\"\r\n\r\nfilecontents\r\n------WebKitFormBoundaryTWfMVJErBoLURJIe--".getBytes());
        HashMap hashMap = new HashMap();
        LinkedList linkedList = new LinkedList();
        MultipartStream multipartStream = new MultipartStream((InputStream)byteArrayInputStream, "----WebKitFormBoundaryTWfMVJErBoLURJIe".getBytes(), this.fileManager, new MultipartConfiguration().withFileUploadPolicy(MultipartFileUploadPolicy.Allow));
        multipartStream.process(hashMap, linkedList);
        Assert.assertEquals((Collection)((Collection)hashMap.get("foo")), List.of("bar"));
        Assert.assertEquals((int)linkedList.size(), (int)1);
        Assert.assertEquals((String)((FileInfo)linkedList.get((int)0)).contentType, (String)"application/octet-stream");
        Assert.assertEquals((String)Files.readString(((FileInfo)linkedList.get((int)0)).file), (String)"filecontents");
        Assert.assertEquals((String)((FileInfo)linkedList.get((int)0)).fileName, (String)"foo.jpg");
        Assert.assertEquals((String)((FileInfo)linkedList.get((int)0)).name, (String)"file");
        Files.delete(((FileInfo)linkedList.get((int)0)).file);
    }

    @Test
    public void parameter() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("------WebKitFormBoundaryTWfMVJErBoLURJIe\r\nContent-Disposition: form-data; name=\"foo\"\r\n\r\nbar\r\n------WebKitFormBoundaryTWfMVJErBoLURJIe--".getBytes());
        HashMap hashMap = new HashMap();
        LinkedList linkedList = new LinkedList();
        MultipartStream multipartStream = new MultipartStream((InputStream)byteArrayInputStream, "----WebKitFormBoundaryTWfMVJErBoLURJIe".getBytes(), this.fileManager, new MultipartConfiguration().withFileUploadPolicy(MultipartFileUploadPolicy.Allow));
        multipartStream.process(hashMap, linkedList);
        Assert.assertEquals((Collection)((Collection)hashMap.get("foo")), List.of("bar"));
    }

    @Test
    public void partialBoundaryInParameter() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("------WebKitFormBoundaryTWfMVJErBoLURJIe\r\nContent-Disposition: form-data; name=\"foo\"\r\n\r\n------WebKitFormBoundaryTWfMVJErBoLURJI\r\n------WebKitFormBoundaryTWfMVJErBoLURJIe--".getBytes());
        HashMap hashMap = new HashMap();
        LinkedList linkedList = new LinkedList();
        MultipartStream multipartStream = new MultipartStream((InputStream)byteArrayInputStream, "----WebKitFormBoundaryTWfMVJErBoLURJIe".getBytes(), this.fileManager, new MultipartConfiguration().withFileUploadPolicy(MultipartFileUploadPolicy.Allow));
        multipartStream.process(hashMap, linkedList);
        Assert.assertEquals((Collection)((Collection)hashMap.get("foo")), List.of("------WebKitFormBoundaryTWfMVJErBoLURJI"));
    }

    @DataProvider(name="parts")
    public Object[][] parts() {
        String string = "------WebKitFormBoundaryTWfMVJErBoLURJIe\r\nContent-Disposition: form-data; name=\"foo\"\r\n\r\nbar\r\n------WebKitFormBoundaryTWfMVJErBoLURJIe\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.jpg\"\r\n\r\nfilecontents\r\n------WebKitFormBoundaryTWfMVJErBoLURJIe--";
        Object[][] objectArray = new Object[string.length() - 1][];
        for (int i = 1; i < string.length(); ++i) {
            objectArray[i - 1] = new Object[]{i, new Parts(new byte[][]{string.substring(0, i).getBytes(), string.substring(i).getBytes()})};
        }
        return objectArray;
    }

    @Test(dataProvider="parts")
    public void separateParts(int n, Parts parts) throws IOException {
        PartInputStream partInputStream = new PartInputStream(parts.parts);
        HashMap hashMap = new HashMap();
        LinkedList linkedList = new LinkedList();
        MultipartStream multipartStream = new MultipartStream((InputStream)partInputStream, "----WebKitFormBoundaryTWfMVJErBoLURJIe".getBytes(), this.fileManager, new MultipartConfiguration().withFileUploadPolicy(MultipartFileUploadPolicy.Allow));
        multipartStream.process(hashMap, linkedList);
        Assert.assertEquals((Collection)((Collection)hashMap.get("foo")), List.of("bar"));
        Assert.assertEquals((int)linkedList.size(), (int)1);
        Assert.assertEquals((String)((FileInfo)linkedList.get((int)0)).contentType, (String)"application/octet-stream");
        Assert.assertEquals((String)Files.readString(((FileInfo)linkedList.get((int)0)).file), (String)"filecontents");
        Assert.assertEquals((String)((FileInfo)linkedList.get((int)0)).fileName, (String)"foo.jpg");
        Assert.assertEquals((String)((FileInfo)linkedList.get((int)0)).name, (String)"file");
        Files.delete(((FileInfo)linkedList.get((int)0)).file);
    }

    @Test
    public void truncated() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("------WebKitFormBoundaryTWfMVJErBoLURJIe\r\n".getBytes());
        HashMap hashMap = new HashMap();
        LinkedList linkedList = new LinkedList();
        MultipartStream multipartStream = new MultipartStream((InputStream)byteArrayInputStream, "----WebKitFormBoundaryTWfMVJErBoLURJIe".getBytes(), this.fileManager, new MultipartConfiguration().withFileUploadPolicy(MultipartFileUploadPolicy.Allow));
        try {
            multipartStream.process(hashMap, linkedList);
            FileAssert.fail((String)"Expected to fail with a ParseException");
        }
        catch (ParseException parseException) {
            Assert.assertEquals((String)parseException.getMessage(), (String)"Invalid multipart body. Ran out of data while processing.");
        }
    }

    public static class Parts {
        public byte[][] parts;

        public Parts(byte[][] byArray) {
            this.parts = byArray;
        }

        public String toString() {
            ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
            for (byte[] byArray : this.parts) {
                arrayList.add((CallSite)((Object)("" + byArray.length)));
            }
            return "{" + String.join((CharSequence)",", arrayList) + "}";
        }
    }

    public static class PartInputStream
    extends InputStream {
        private final byte[][] parts;
        private int index;
        private int partIndex;

        public PartInputStream(byte[] ... byArray) {
            this.parts = byArray;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) {
            if (this.index > this.parts.length) {
                return -1;
            }
            int n3 = Math.min(n2, this.parts[this.index].length - this.partIndex);
            System.arraycopy(this.parts[this.index], this.partIndex, byArray, n, n3);
            this.partIndex += n3;
            if (this.partIndex >= this.parts[this.index].length) {
                this.partIndex = 0;
                ++this.index;
            }
            return n3;
        }

        @Override
        public int read() {
            throw new UnsupportedOperationException();
        }
    }
}

