/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.io.ChunkedInputStream;
import io.fusionauth.http.io.PushbackInputStream;
import io.fusionauth.http.util.ThrowingFunction;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class ChunkedInputStreamTest {
    @Test
    public void chunkExtensions() throws Exception {
        this.withBody("3;foo=bar\r\nHi \r\n4;foo=\r\nmom!\r\n3;foo\r\n Lo\r\n2;foo;bar\r\nok\r\n1;foo;bar=\r\n \r\n1;foo;bar=baz\r\nn\r\n2;foo=bar;baz\r\no \r\n3;foo=bar;bar=baz\r\next\r\n2;\r\nen\r\n4\r\nsion\r\n2;\r\ns!\r\n0;foo=bar;bar\r\n\r\n").assertResult("Hi mom! Look no extensions!").assertLeftOverBytes(0);
    }

    @Test
    public void multipleChunks() throws Exception {
        this.withBody("A\r\n1234567890\r\n14\r\n12345678901234567890\r\n1E\r\n123456789012345678901234567890\r\n0\r\n\r\n").assertResult("123456789012345678901234567890123456789012345678901234567890").assertLeftOverBytes(0).assertNextRead(ChunkedInputStream::read, -1);
    }

    @Test
    public void ok() throws Exception {
        this.withBody("3\r\nHi \r\n4\r\nmom!\r\n0\r\n\r\n").assertResult("Hi mom!").assertLeftOverBytes(0);
    }

    @Test
    public void partialChunks() throws IOException {
        byte[] byArray = new byte[1024];
        ChunkedInputStream chunkedInputStream = new ChunkedInputStream(this.withParts("A\r\n12345678", "90\r\n14\r\n12345678901234567890\r\n1E\r\n123456789012345678901234567890\r\n0\r\n\r\n"), 1024);
        Assert.assertEquals((int)chunkedInputStream.read(byArray), (int)60);
        String string = new String(byArray, 0, 60);
        Assert.assertEquals((String)string, (String)"123456789012345678901234567890123456789012345678901234567890");
        Assert.assertEquals((int)chunkedInputStream.read(), (int)-1);
    }

    @Test
    public void partialHeader() throws IOException {
        byte[] byArray = new byte[1024];
        ChunkedInputStream chunkedInputStream = new ChunkedInputStream(this.withParts("A\r\n1234567890\r\n14", "\r\n12345678901234567890\r\n0\r\n\r\n"), 1024);
        Assert.assertEquals((int)chunkedInputStream.read(byArray), (int)30);
        String string = new String(byArray, 0, 30);
        Assert.assertEquals((String)string, (String)"123456789012345678901234567890");
        Assert.assertEquals((int)chunkedInputStream.read(byArray), (int)-1);
    }

    @Test
    public void trailers() throws Exception {
        this.withBody("30\r\nThere is no fate but what we make for ourselves.\r\n12\r\n\n  - Sarah Connor\n\r\n0\r\nJudgement-Day: August 29, 1997 2:14 AM EDT\r\n\r\n").assertResult("There is no fate but what we make for ourselves.\n  - Sarah Connor\n").assertLeftOverBytes(0);
    }

    private Builder withBody(String string) {
        return new Builder().withBody(string);
    }

    private PushbackInputStream withParts(String ... stringArray) {
        return new PushbackInputStream((InputStream)new PieceMealInputStream(stringArray), null);
    }

    private static class Builder {
        public String body;
        public ChunkedInputStream chunkedInputStream;
        public PushbackInputStream pushbackInputStream;

        private Builder() {
        }

        public Builder assertLeftOverBytes(int n) throws IOException {
            int n2 = this.pushbackInputStream.getAvailableBufferedBytesRemaining();
            if (n2 != n && n2 > 0) {
                byte[] byArray = new byte[n2];
                int n3 = this.pushbackInputStream.read(byArray);
                Assert.assertEquals((int)byArray.length, (int)n3);
                Assert.assertEquals((int)n2, (int)n, (String)("\nHere is what was left over in the buffer\n[" + new String(byArray) + "]"));
            }
            return this;
        }

        public Builder assertNextRead(ThrowingFunction<ChunkedInputStream, Integer> throwingFunction, int n) throws Exception {
            Integer n2 = throwingFunction.apply(this.chunkedInputStream);
            Assert.assertEquals((Integer)n2, (int)n);
            return this;
        }

        public Builder assertResult(String string) throws IOException {
            this.pushbackInputStream = new PushbackInputStream((InputStream)new ByteArrayInputStream(this.body.getBytes(StandardCharsets.UTF_8)), null);
            this.chunkedInputStream = new ChunkedInputStream(this.pushbackInputStream, 2048);
            String string2 = new String(this.chunkedInputStream.readAllBytes(), StandardCharsets.UTF_8);
            Assert.assertEquals((String)string2, (String)string);
            return this;
        }

        public Builder withBody(String string) {
            this.body = string;
            return this;
        }
    }

    private static class PieceMealInputStream
    extends InputStream {
        private final byte[][] parts;
        private int partsIndex;
        private int subPartIndex = 0;

        public PieceMealInputStream(String ... stringArray) {
            this.parts = new byte[stringArray.length][];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                this.parts[i] = string.getBytes();
            }
        }

        @Override
        public int read() {
            throw new IllegalStateException("Unexpected call to read()");
        }

        @Override
        public int read(byte[] byArray, int n, int n2) {
            if (this.partsIndex >= this.parts.length) {
                return -1;
            }
            int n3 = Math.min(this.parts[this.partsIndex].length - this.subPartIndex, byArray.length);
            System.arraycopy(this.parts[this.partsIndex], 0, byArray, 0, n3);
            if (n3 < this.parts[this.partsIndex].length - this.subPartIndex) {
                this.subPartIndex = n3;
            } else {
                ++this.partsIndex;
            }
            return n3;
        }

        @Override
        public int read(byte[] byArray) {
            throw new IllegalStateException("Unexpected call to read(byte[] b)");
        }
    }
}

