/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import io.fusionauth.http.BaseTest;
import io.fusionauth.http.server.AlwaysContinueExpectValidator;
import io.fusionauth.http.server.CountingInstrumenter;
import io.fusionauth.http.server.ExpectValidator;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPServer;
import io.fusionauth.http.server.Instrumenter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ExpectTest
extends BaseTest {
    public static final String ExpectedResponse = "{\"version\":\"42\"}";
    public static final String RequestBody = "{\"message\":\"Hello World\"";

    @Test(dataProvider="schemes")
    public void expect(String string) throws Exception {
        boolean[] blArray;
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            Object object;
            this.println("Handling");
            Assert.assertEquals((String)hTTPRequest.getHeader("Content-Type"), (String)"application/json");
            try {
                this.println("Reading");
                object = hTTPRequest.getInputStream().readAllBytes();
                Assert.assertEquals((String)new String((byte[])object), (String)RequestBody);
            }
            catch (IOException iOException) {
                Assert.fail((String)"Unable to parse body", (Throwable)iOException);
            }
            this.println("Done");
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setHeader("Content-Length", "16");
            hTTPResponse.setStatus(200);
            try {
                this.println("Writing");
                object = hTTPResponse.getOutputStream();
                ((OutputStream)object).write(ExpectedResponse.getBytes());
                ((OutputStream)object).close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        ExpectValidator expectValidator = (hTTPRequest, hTTPResponse) -> {
            this.println("Validating");
            atomicBoolean.set(true);
            Assert.assertEquals((String)hTTPRequest.getContentType(), (String)"application/json");
            Assert.assertEquals((long)hTTPRequest.getContentLength(), (long)RequestBody.length());
            hTTPResponse.setStatus(100);
            hTTPResponse.setStatusMessage("Continue");
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        for (boolean bl : blArray = new boolean[]{true, false}) {
            ExpectValidator expectValidator2 = bl ? expectValidator : new AlwaysContinueExpectValidator();
            try (HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter, expectValidator2).start();
                 HttpClient httpClient = this.makeClient(string, null);){
                URI uRI = this.makeURI(string, "");
                HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Content-Type", "application/json").expectContinue(true).POST(HttpRequest.BodyPublishers.ofString(RequestBody)).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
                Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
                Assert.assertEquals((String)((String)httpResponse.body()), (String)ExpectedResponse);
                Assert.assertTrue((boolean)atomicBoolean.get());
            }
        }
    }

    @Test(dataProvider="schemes")
    public void expectReject(String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> Assert.fail((String)"Should not have been called");
        ExpectValidator expectValidator = (hTTPRequest, hTTPResponse) -> {
            this.println("Validating");
            Assert.assertEquals((String)hTTPRequest.getContentType(), (String)"application/json");
            Assert.assertEquals((long)hTTPRequest.getContentLength(), (long)RequestBody.length());
            hTTPResponse.setStatus(417);
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter, expectValidator).start();
             HttpClient httpClient = this.makeClient(string, null);){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).header("Content-Type", "application/json").expectContinue(true).POST(HttpRequest.BodyPublishers.ofString(RequestBody)).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)417);
            Assert.assertEquals((String)((String)httpResponse.body()), (String)"");
        }
    }
}

