/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import io.fusionauth.http.BaseTest;
import io.fusionauth.http.server.CountingInstrumenter;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPServer;
import io.fusionauth.http.server.Instrumenter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class CompressionTest
extends BaseTest {
    private final Path file = Paths.get("src/test/java/io/fusionauth/http/ChunkedTest.java", new String[0]);

    @DataProvider(name="chunkedSchemes")
    public Object[][] chunkedSchemes() {
        return new Object[][]{{true, "http"}, {true, "https"}, {false, "http"}, {false, "https"}};
    }

    @Test(dataProvider="compressedChunkedSchemes")
    public void compress(String string, boolean bl, String string2) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setCompress(true);
            hTTPResponse.setCompress(false);
            hTTPResponse.setCompress(true);
            hTTPResponse.setCompress(false);
            hTTPResponse.setCompress(true);
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
            if (!bl) {
                hTTPResponse.setContentLength(Files.size(this.file));
            }
            try (InputStream inputStream = Files.newInputStream(this.file, new OpenOption[0]);){
                OutputStream outputStream = hTTPResponse.getOutputStream();
                inputStream.transferTo(outputStream);
                try {
                    hTTPResponse.setCompress(false);
                    AssertJUnit.fail((String)"Expected setCompress(false) to fail hard!");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HttpClient httpClient = this.makeClient(string2, null);
             HTTPServer hTTPServer = this.makeServer(string2, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            URI uRI = this.makeURI(string2, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().header("Accept-Encoding", string).uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofInputStream());
            String string3 = new String(string.equals("deflate") ? new InflaterInputStream((InputStream)httpResponse.body()).readAllBytes() : new GZIPInputStream((InputStream)httpResponse.body()).readAllBytes(), StandardCharsets.UTF_8);
            Assert.assertEquals((String)httpResponse.headers().firstValue("Content-Encoding").orElse(null), (String)string);
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)string3, (String)Files.readString(this.file));
        }
    }

    @Test
    public void compressBadContentLength() throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setCompress(true);
            hTTPResponse.setContentLength(1000000L);
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
            try (InputStream inputStream = Files.newInputStream(this.file, new OpenOption[0]);){
                OutputStream outputStream = hTTPResponse.getOutputStream();
                inputStream.transferTo(outputStream);
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        try (HttpClient httpClient = this.makeClient("http", null);
             HTTPServer hTTPServer = ((HTTPServer)this.makeServer("http", hTTPHandler).withCompressByDefault(false)).start();){
            URI uRI = this.makeURI("http", "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().header("Accept-Encoding", "gzip").uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofInputStream());
            Assert.assertEquals((String)httpResponse.headers().firstValue("Content-Encoding").orElse(null), (String)"gzip");
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)new String(new GZIPInputStream((InputStream)httpResponse.body()).readAllBytes(), StandardCharsets.UTF_8), (String)Files.readString(this.file));
        }
    }

    @Test(groups={"performance"})
    public void compressPerformance() throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
            try (InputStream inputStream = Files.newInputStream(this.file, new OpenOption[0]);){
                OutputStream outputStream = hTTPResponse.getOutputStream();
                inputStream.transferTo(outputStream);
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        for (boolean bl : List.of(Boolean.valueOf(true), Boolean.valueOf(false))) {
            CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
            HttpClient httpClient = this.makeClient("http", null);
            try {
                HTTPServer hTTPServer = ((HTTPServer)this.makeServer("http", hTTPHandler, (Instrumenter)countingInstrumenter).withCompressByDefault(bl)).start();
                try {
                    URI uRI = this.makeURI("http", "");
                    int n = 25000;
                    long l = System.currentTimeMillis();
                    for (int i = 0; i < n; ++i) {
                        HttpResponse httpResponse = bl ? httpClient.send(HttpRequest.newBuilder().header("Accept-Encoding", "gzip").uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofInputStream()) : httpClient.send(HttpRequest.newBuilder().header("Accept-Encoding", "gzip").uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
                        String string = bl ? new String(new GZIPInputStream((InputStream)httpResponse.body()).readAllBytes(), StandardCharsets.UTF_8) : httpResponse.body();
                        Assert.assertEquals((String)httpResponse.headers().firstValue("Content-Encoding").orElse(null), (String)(bl ? "gzip" : null));
                        Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
                        Assert.assertEquals((Object)string, (Object)Files.readString(this.file));
                    }
                    long l2 = System.currentTimeMillis();
                    long l3 = l2 - l;
                    BigDecimal bigDecimal = new BigDecimal(l3).divide(new BigDecimal(n));
                    DecimalFormat decimalFormat = new DecimalFormat("#,###");
                    String string = bl ? bl + " " : "" + bl;
                    this.println("[compression: " + string + "][" + decimalFormat.format(n) + "] requests. Total time [" + decimalFormat.format(l3) + "] ms, Avg [" + String.valueOf(bigDecimal) + "] ms");
                }
                finally {
                    if (hTTPServer == null) continue;
                    hTTPServer.close();
                }
            }
            finally {
                if (httpClient == null) continue;
                httpClient.close();
            }
        }
    }

    @Test(dataProvider="compressedChunkedSchemes")
    public void compress_onByDefault(String string, boolean bl, String string2) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
            if (!bl) {
                hTTPResponse.setContentLength(Files.size(this.file));
            }
            try (InputStream inputStream = Files.newInputStream(this.file, new OpenOption[0]);){
                OutputStream outputStream = hTTPResponse.getOutputStream();
                inputStream.transferTo(outputStream);
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HttpClient httpClient = this.makeClient(string2, null);
             HTTPServer hTTPServer = this.makeServer(string2, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            URI uRI = this.makeURI(string2, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().header("Accept-Encoding", string).uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofInputStream());
            String string3 = new String(string.equals("deflate") ? new InflaterInputStream((InputStream)httpResponse.body()).readAllBytes() : new GZIPInputStream((InputStream)httpResponse.body()).readAllBytes(), StandardCharsets.UTF_8);
            Assert.assertEquals((String)httpResponse.headers().firstValue("Content-Encoding").orElse(null), (String)string);
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)string3, (String)Files.readString(this.file));
        }
    }

    @DataProvider(name="compressedChunkedSchemes")
    public Object[][] compressedChunkedSchemes() {
        return new Object[][]{{"deflate", true, "http"}, {"gzip", true, "http"}, {"deflate", true, "https"}, {"gzip", true, "https"}, {"deflate", false, "http"}, {"gzip", false, "http"}, {"deflate", false, "https"}, {"gzip", false, "https"}};
    }

    @Test(dataProvider="chunkedSchemes")
    public void requestedButNotAccepted(boolean bl, String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setCompress(true);
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
            if (!bl) {
                hTTPResponse.setContentLength(Files.size(this.file));
            }
            try (InputStream inputStream = Files.newInputStream(this.file, new OpenOption[0]);){
                OutputStream outputStream = hTTPResponse.getOutputStream();
                inputStream.transferTo(outputStream);
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertNull(httpResponse.headers().firstValue("Content-Encoding").orElse(null));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)((String)httpResponse.body()), (String)Files.readString(this.file));
        }
    }

    @Test(dataProvider="chunkedSchemes")
    public void requestedButNotAccepted_unSupportedEncoding(boolean bl, String string) throws Exception {
        HTTPHandler hTTPHandler = (hTTPRequest, hTTPResponse) -> {
            hTTPResponse.setCompress(true);
            hTTPResponse.setHeader("Content-Type", "text/plain");
            hTTPResponse.setStatus(200);
            if (!bl) {
                hTTPResponse.setContentLength(Files.size(this.file));
            }
            try (InputStream inputStream = Files.newInputStream(this.file, new OpenOption[0]);){
                OutputStream outputStream = hTTPResponse.getOutputStream();
                inputStream.transferTo(outputStream);
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        };
        CountingInstrumenter countingInstrumenter = new CountingInstrumenter();
        try (HttpClient httpClient = this.makeClient(string, null);
             HTTPServer hTTPServer = this.makeServer(string, hTTPHandler, (Instrumenter)countingInstrumenter).start();){
            URI uRI = this.makeURI(string, "");
            HttpResponse httpResponse = httpClient.send(HttpRequest.newBuilder().header("Accept-Encoding", "br").uri(uRI).GET().build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
            Assert.assertNull(httpResponse.headers().firstValue("Content-Encoding").orElse(null));
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertEquals((String)((String)httpResponse.body()), (String)Files.readString(this.file));
        }
    }
}

