/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import io.fusionauth.http.log.FileLogger;
import io.fusionauth.http.log.FileLoggerFactory;
import io.fusionauth.http.log.Level;
import io.fusionauth.http.log.LoggerFactory;
import io.fusionauth.http.security.SecurityTools;
import io.fusionauth.http.server.AlwaysContinueExpectValidator;
import io.fusionauth.http.server.ExpectValidator;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPServer;
import io.fusionauth.http.server.Instrumenter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.CookieHandler;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.http.HttpClient;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.testng.Assert;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.DataProvider;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.DNSName;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNames;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public abstract class BaseTest {
    public static final Duration ClientTimeout = Duration.ofSeconds(30L);
    public static final Duration ServerTimeout = Duration.ofSeconds(30L);
    private static final ZonedDateTime TestStarted = ZonedDateTime.now();
    private static final DateTimeFormatter hh_mm_ss_SSS = DateTimeFormatter.ofPattern("hh:mm:ss.SSS");
    public static String SystemOutPrefix = "     | ";
    public static Certificate certificate;
    public static Certificate intermediateCertificate;
    public static KeyPair intermediateKeyPair;
    public static KeyPair keyPair;
    public static Certificate rootCertificate;
    public static KeyPair rootKeyPair;
    protected boolean verbose;

    @BeforeSuite
    public static void setupCertificates() {
        rootKeyPair = BaseTest.generateNewRSAKeyPair();
        intermediateKeyPair = BaseTest.generateNewRSAKeyPair();
        keyPair = BaseTest.generateNewRSAKeyPair();
        rootCertificate = BaseTest.generateRootCA(rootKeyPair.getPublic(), rootKeyPair.getPrivate());
        X509CertInfo x509CertInfo = BaseTest.generateCertInfo(intermediateKeyPair.getPublic(), "intermediate.fusionauth.io");
        intermediateCertificate = BaseTest.signCertificate((X509Certificate)rootCertificate, rootKeyPair.getPrivate(), x509CertInfo, true);
        X509CertInfo x509CertInfo2 = BaseTest.generateCertInfo(keyPair.getPublic(), "local.fusionauth.io");
        certificate = BaseTest.signCertificate((X509Certificate)intermediateCertificate, intermediateKeyPair.getPrivate(), x509CertInfo2, false);
    }

    protected static X509CertInfo generateCertInfo(PublicKey publicKey, String string) {
        try {
            X509CertInfo x509CertInfo = new X509CertInfo();
            CertificateX509Key certificateX509Key = new CertificateX509Key(publicKey);
            x509CertInfo.setKey(certificateX509Key);
            x509CertInfo.setVersion(new CertificateVersion(2));
            x509CertInfo.setAlgorithmId(new CertificateAlgorithmId(new AlgorithmId(ObjectIdentifier.of(KnownOIDs.SHA256withRSA))));
            x509CertInfo.setSubject(new X500Name("CN=" + string));
            x509CertInfo.setValidity(new CertificateValidity(Date.from(Instant.now().minusSeconds(30L)), Date.from(Instant.now().plusSeconds(10000L))));
            x509CertInfo.setSerialNumber(new CertificateSerialNumber(new BigInteger(UUID.randomUUID().toString().replace("-", ""), 16)));
            return x509CertInfo;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    protected static KeyPair generateNewRSAKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(4096);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    protected static Certificate generateRootCA(PublicKey publicKey, PrivateKey privateKey) throws IllegalArgumentException {
        try {
            X509CertInfo x509CertInfo = BaseTest.generateCertInfo(publicKey, "root-ca.fusionauth.io");
            x509CertInfo.setIssuer(new X500Name("CN=root-ca.fusionauth.io"));
            return X509CertImpl.newSigned(x509CertInfo, privateKey, "SHA256withRSA");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    protected static X509Certificate signCertificate(X509Certificate x509Certificate, PrivateKey privateKey, X509CertInfo x509CertInfo, boolean bl) throws IllegalArgumentException {
        try {
            X509CertInfo x509CertInfo2 = new X509CertInfo(x509Certificate.getTBSCertificate());
            x509CertInfo.setIssuer(x509CertInfo2.getSubject());
            CertificateExtensions certificateExtensions = new CertificateExtensions();
            if (bl) {
                certificateExtensions.setExtension("BasicConstraints", new BasicConstraintsExtension(true, true, 1));
            }
            X500Name x500Name = x509CertInfo.getSubject();
            String string = x500Name.getCommonName();
            GeneralNames generalNames = new GeneralNames();
            generalNames.add(new GeneralName(new DNSName(string)));
            certificateExtensions.setExtension("SubjectAlternativeName", new SubjectAlternativeNameExtension((Boolean)false, generalNames));
            x509CertInfo.setExtensions(certificateExtensions);
            return X509CertImpl.newSigned(x509CertInfo, privateKey, "SHA256withRSA");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    @BeforeMethod
    public void beforeMethod() {
        this.verbose = false;
    }

    @DataProvider
    public Object[][] connections() {
        return new Object[][]{{"close"}, {"keep-alive"}};
    }

    @AfterMethod
    public void flush() {
        FileLogger fileLogger = (FileLogger)FileLoggerFactory.FACTORY.getLogger(BaseTest.class);
        if (fileLogger != null) {
            fileLogger.flush();
        }
    }

    public HttpClient makeClient(String string, CookieHandler cookieHandler) throws GeneralSecurityException, IOException {
        HttpClient.Builder builder = HttpClient.newBuilder();
        if (string.equals("https")) {
            builder.sslContext(SecurityTools.clientContext((Certificate)rootCertificate));
        }
        if (cookieHandler != null) {
            builder.cookieHandler(cookieHandler);
        }
        return builder.connectTimeout(ClientTimeout).build();
    }

    public Socket makeClientSocket(String string) throws GeneralSecurityException, IOException {
        Socket socket;
        if (string.equals("https")) {
            SSLContext sSLContext = SecurityTools.clientContext((Certificate)rootCertificate);
            socket = sSLContext.getSocketFactory().createSocket("127.0.0.1", 4242);
        } else {
            socket = new Socket("127.0.0.1", 4242);
        }
        return socket;
    }

    public HTTPServer makeServer(String string, HTTPHandler hTTPHandler, Instrumenter instrumenter) {
        return this.makeServer(string, hTTPHandler, instrumenter, null);
    }

    public HTTPServer makeServer(String string, HTTPHandler hTTPHandler) {
        return this.makeServer(string, hTTPHandler, null);
    }

    public HTTPServer makeServer(String string, HTTPHandler hTTPHandler, Instrumenter instrumenter, ExpectValidator expectValidator) {
        HTTPListenerConfiguration hTTPListenerConfiguration;
        Certificate[] certificateArray;
        boolean bl = string.equals("https");
        if (bl) {
            certificateArray = new Certificate[]{certificate, intermediateCertificate};
            hTTPListenerConfiguration = new HTTPListenerConfiguration(4242, certificateArray, keyPair.getPrivate());
        } else {
            hTTPListenerConfiguration = new HTTPListenerConfiguration(4242);
        }
        certificateArray = FileLoggerFactory.FACTORY;
        return (HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)((HTTPServer)new HTTPServer().withHandler(hTTPHandler)).withKeepAliveTimeoutDuration(ServerTimeout)).withInitialReadTimeout(ServerTimeout)).withProcessingTimeoutDuration(ServerTimeout)).withExpectValidator((ExpectValidator)(expectValidator != null ? expectValidator : new AlwaysContinueExpectValidator()))).withInstrumenter(instrumenter)).withLoggerFactory((LoggerFactory)certificateArray)).withMinimumReadThroughput(204800L)).withMinimumWriteThroughput(204800L)).withListener(hTTPListenerConfiguration)).withReadThroughputCalculationDelayDuration(Duration.ofSeconds(1L))).withWriteThroughputCalculationDelayDuration(Duration.ofSeconds(1L));
    }

    public URI makeURI(String string, String string2) {
        if (string.equals("https")) {
            return URI.create("https://local.fusionauth.io:4242/api/system/version" + string2);
        }
        return URI.create("http://localhost:4242/api/system/version" + string2);
    }

    @DataProvider
    public Object[][] schemes() {
        return new Object[][]{{"http"}, {"https"}};
    }

    @DataProvider
    public Object[][] schemesAndChunked() {
        return new Object[][]{{"http", true}, {"http", false}, {"https", true}, {"https", false}};
    }

    @DataProvider
    public Object[][] schemesAndResponseBufferSizes() {
        return new Object[][]{{"http", 65536}, {"https", 65536}, {"http", 512}, {"https", 512}, {"http", -1}, {"https", -1}};
    }

    public void sendBadRequest(String string) {
        try (Socket socket = new Socket("127.0.0.1", 4242);
             OutputStream outputStream = socket.getOutputStream();
             InputStream inputStream = socket.getInputStream();){
            outputStream.write(string.getBytes());
            outputStream.flush();
            byte[] byArray = inputStream.readAllBytes();
            Assert.assertEquals((String)new String(byArray), (String)"HTTP/1.1 400 \r\nconnection: close\r\ncontent-length: 0\r\n\r\n");
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    @AfterSuite
    public void tearDown() {
        System.out.println("\nTests began : " + hh_mm_ss_SSS.format(TestStarted));
        System.out.println("Tests ended : " + hh_mm_ss_SSS.format(ZonedDateTime.now()));
        System.out.println("Total test time in minutes : " + Duration.between(TestStarted, ZonedDateTime.now()).toMinutes());
    }

    protected void assertHTTPResponseEquals(Socket socket, String string) throws Exception {
        block5: {
            int n;
            InputStream inputStream = socket.getInputStream();
            int n2 = string.getBytes(StandardCharsets.UTF_8).length;
            byte[] byArray = new byte[n2 * 2];
            String string2 = new String(byArray, 0, n = inputStream.read(byArray), StandardCharsets.UTF_8);
            if (!string2.equals(string)) {
                try {
                    this.assertResponseEquals(inputStream, string2, string);
                }
                catch (SocketException socketException) {
                    if (!socketException.getMessage().equals("Connection reset")) break block5;
                    SocketAddress socketAddress = socket.getRemoteSocketAddress();
                    socket.close();
                    try {
                        socket.connect(socketAddress);
                        this.assertResponseEquals(socket.getInputStream(), string2, string);
                    }
                    catch (Exception exception) {
                        Assert.assertEquals((String)string2, (String)string, (String)("[" + exception.getClass().getSimpleName() + "] was thrown trying to read. We are going to assert on what we have.\n"));
                    }
                }
            }
        }
    }

    protected String chunkItUp(String string, String string2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 100;
        for (int i = 0; i < string.length(); i += n) {
            int n2 = Math.min(i + n, string.length());
            String string3 = string.substring(i, n2);
            int n3 = string3.getBytes(StandardCharsets.UTF_8).length;
            String string4 = Integer.toHexString(n3);
            arrayList.add(string4);
            if (string2 != null) {
                arrayList.add(string2);
            }
            arrayList.add("\r\n" + string3 + "\r\n");
        }
        arrayList.add("0\r\n\r\n");
        return String.join((CharSequence)"", arrayList);
    }

    protected void printf(String string, Object ... objectArray) {
        if (this.verbose) {
            System.out.printf(SystemOutPrefix + string, objectArray);
        }
    }

    protected void println(Object object) {
        if (this.verbose) {
            System.out.println(object);
        }
    }

    protected void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void validateCertPath(Certificate certificate, Certificate[] certificateArray) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        CertPathValidator certPathValidator;
        PKIXParameters pKIXParameters;
        CertPath certPath;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            certPath = certificateFactory.generateCertPath(Arrays.asList(certificateArray));
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null);
            keyStore.setCertificateEntry("root-ca", certificate);
            pKIXParameters = new PKIXParameters(keyStore);
            pKIXParameters.setRevocationEnabled(false);
            certPathValidator = CertPathValidator.getInstance("PKIX");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        certPathValidator.validate(certPath, pKIXParameters);
    }

    private void assertResponseEquals(InputStream inputStream, String string, String string2) throws IOException {
        try {
            byte[] byArray = inputStream.readAllBytes();
            String string3 = string + new String(byArray, StandardCharsets.UTF_8);
            Assert.assertEquals((String)string3, (String)string2, (String)("An additional [" + byArray.length + "] was read from the InputStream to complete the message.\nInitial expected response\n[" + string2 + "]\nInitial actual response\n[" + string + "]\n"));
        }
        catch (SocketTimeoutException socketTimeoutException) {
            Assert.assertEquals((String)string, (String)string2, (String)"[SocketTimeoutException] was thrown trying to read. We are going to assert on what we have.\n");
        }
    }

    static {
        System.setProperty("sun.net.http.retryPost", "false");
        System.setProperty("jdk.httpclient.allowRestrictedHeaders", "connection");
    }

    public static class TestListener
    implements ITestListener {
        private int counter = 0;
        private String lastTestMethod;
        private int lastTestMethodCounter = 0;

        public void onTestFailure(ITestResult iTestResult) {
            Throwable throwable = iTestResult.getThrowable();
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
                stringBuilder.append(entry.getKey()).append(" ").append((Object)entry.getKey().getState()).append("\n");
                for (StackTraceElement stackTraceElement : entry.getValue()) {
                    stringBuilder.append("\tat ").append(stackTraceElement).append("\n");
                }
                stringBuilder.append("\n");
            }
            System.out.println("\nTest failure\n-----------------\nException: {{exception}}\nMessage: {{message}}\n\nStack traces (client side):\n{{threadDump}}\n-----------------\n".replace("{{exception}}", throwable != null ? throwable.getClass().getSimpleName() : "-").replace("{{message}}", throwable != null ? (throwable.getMessage() != null ? throwable.getMessage() : "-") : "-").replace("{{threadDump}}", stringBuilder));
        }

        public void onTestStart(ITestResult iTestResult) {
            Object[] objectArray = iTestResult.getParameters();
            Object object = objectArray != null && objectArray.length > 0 ? " [" + this.serializeDataProviderArgs(objectArray) + "]" : "";
            String string = iTestResult.getTestClass().getName() + "." + iTestResult.getName();
            if (this.lastTestMethod != null && !this.lastTestMethod.equals(string)) {
                this.lastTestMethodCounter = 0;
            }
            if (!((String)object).isEmpty()) {
                object = (String)object + " (" + ++this.lastTestMethodCounter + ")";
            }
            this.lastTestMethod = string;
            System.out.println("[" + ++this.counter + "] " + hh_mm_ss_SSS.format(ZonedDateTime.now()) + " " + string + (String)object);
            FileLogger fileLogger = new FileLogger(Paths.get("build/test/logs/" + iTestResult.getTestClass().getName() + (String)object + ".txt", new String[0]));
            fileLogger.setLevel(Level.Trace);
            FileLoggerFactory.setLogger((FileLogger)fileLogger);
        }

        private String serializeDataProviderArgs(Object[] objectArray) {
            Object object2 = Arrays.stream(objectArray).map(object -> (object == null ? "null" : object.toString()).replace("\n", "\\n").replace("\r", "\\r")).collect(Collectors.joining(", "));
            int n = 128;
            if (((String)object2).length() > n) {
                if (((String)object2).charAt(n) == ',') {
                    --n;
                }
                object2 = ((String)object2).substring(0, n) + "\u2026";
            }
            return object2;
        }
    }
}

