/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HTTPContext {
    public Map<String, Object> attributes = Collections.synchronizedMap(new HashMap());
    public Path baseDir;

    public HTTPContext(Path path) {
        this.baseDir = path;
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public URL getResource(String string) throws IllegalStateException {
        String string2 = string;
        if (string.startsWith("/")) {
            string2 = string.substring(1);
        }
        try {
            Path path = this.baseDir.resolve(string2);
            if (Files.exists(path, new LinkOption[0])) {
                return path.toUri().toURL();
            }
            return HTTPContext.class.getResource(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(malformedURLException);
        }
    }

    public Object removeAttribute(String string) {
        return this.attributes.remove(string);
    }

    public Path resolve(String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        return this.baseDir.resolve(string);
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }
}

