/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.io.MultipartConfiguration;
import io.fusionauth.http.log.LoggerFactory;
import io.fusionauth.http.server.ExpectValidator;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.HTTPUnexpectedExceptionHandler;
import io.fusionauth.http.server.Instrumenter;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;

public interface Configurable<T extends Configurable<T>> {
    public HTTPServerConfiguration configuration();

    default public T withBaseDir(Path path) {
        this.configuration().withBaseDir(path);
        return (T)this;
    }

    default public T withChunkedBufferSize(int n) {
        this.configuration().withChunkedBufferSize(n);
        return (T)this;
    }

    default public T withCompressByDefault(boolean bl) {
        this.configuration().withCompressByDefault(bl);
        return (T)this;
    }

    default public T withContextPath(String string) {
        this.configuration().withContextPath(string);
        return (T)this;
    }

    default public T withExpectValidator(ExpectValidator expectValidator) {
        this.configuration().withExpectValidator(expectValidator);
        return (T)this;
    }

    default public T withHandler(HTTPHandler hTTPHandler) {
        this.configuration().withHandler(hTTPHandler);
        return (T)this;
    }

    default public T withInitialReadTimeout(Duration duration) {
        this.configuration().withInitialReadTimeout(duration);
        return (T)this;
    }

    default public T withInstrumenter(Instrumenter instrumenter) {
        this.configuration().withInstrumenter(instrumenter);
        return (T)this;
    }

    default public T withKeepAliveTimeoutDuration(Duration duration) {
        this.configuration().withKeepAliveTimeoutDuration(duration);
        return (T)this;
    }

    default public T withListener(HTTPListenerConfiguration hTTPListenerConfiguration) {
        this.configuration().withListener(hTTPListenerConfiguration);
        return (T)this;
    }

    default public T withLoggerFactory(LoggerFactory loggerFactory) {
        this.configuration().withLoggerFactory(loggerFactory);
        return (T)this;
    }

    default public T withMaxPendingSocketConnections(int n) {
        this.configuration().withMaxPendingSocketConnections(n);
        return (T)this;
    }

    default public T withMaxRequestBodySize(Map<String, Integer> map) {
        this.configuration().withMaxRequestBodySize((Map)map);
        return (T)this;
    }

    default public T withMaxRequestHeaderSize(int n) {
        this.configuration().withMaxRequestHeaderSize(n);
        return (T)this;
    }

    default public T withMaxRequestsPerConnection(int n) {
        this.configuration().withMaxRequestsPerConnection(n);
        return (T)this;
    }

    default public T withMaxResponseChunkSize(int n) {
        this.configuration().withMaxResponseChunkSize(n);
        return (T)this;
    }

    default public T withMaximumBytesToDrain(int n) {
        this.configuration().withMaximumBytesToDrain(n);
        return (T)this;
    }

    default public T withMinimumReadThroughput(long l) {
        this.configuration().withMinimumReadThroughput(l);
        return (T)this;
    }

    default public T withMinimumWriteThroughput(long l) {
        this.configuration().withMinimumWriteThroughput(l);
        return (T)this;
    }

    @Deprecated
    default public T withMultipartBufferSize(int n) {
        this.configuration().withMultipartBufferSize(n);
        return (T)this;
    }

    default public T withMultipartConfiguration(MultipartConfiguration multipartConfiguration) {
        this.configuration().withMultipartConfiguration(multipartConfiguration);
        return (T)this;
    }

    default public T withProcessingTimeoutDuration(Duration duration) {
        this.configuration().withProcessingTimeoutDuration(duration);
        return (T)this;
    }

    default public T withReadThroughputCalculationDelayDuration(Duration duration) {
        this.configuration().withReadThroughputCalculationDelayDuration(duration);
        return (T)this;
    }

    default public T withRequestBufferSize(int n) {
        this.configuration().withRequestBufferSize(n);
        return (T)this;
    }

    default public T withResponseBufferSize(int n) {
        this.configuration().withResponseBufferSize(n);
        return (T)this;
    }

    default public T withShutdownDuration(Duration duration) {
        this.configuration().withShutdownDuration(duration);
        return (T)this;
    }

    default public T withUnexpectedExceptionHandler(HTTPUnexpectedExceptionHandler hTTPUnexpectedExceptionHandler) {
        this.configuration().withUnexpectedExceptionHandler(hTTPUnexpectedExceptionHandler);
        return (T)this;
    }

    default public T withWriteThroughputCalculationDelayDuration(Duration duration) {
        this.configuration().withWriteThroughputCalculationDelayDuration(duration);
        return (T)this;
    }
}

