/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.HTTPValues;
import io.fusionauth.http.io.FastByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends OutputStream {
    private final byte[] buffer;
    private final FastByteArrayOutputStream chunkOutputStream;
    private final OutputStream delegate;
    private int bufferIndex;
    private boolean closed;

    public ChunkedOutputStream(OutputStream outputStream, byte[] byArray, FastByteArrayOutputStream fastByteArrayOutputStream) {
        this.delegate = outputStream;
        this.buffer = byArray;
        this.chunkOutputStream = fastByteArrayOutputStream;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.flush();
            this.delegate.write(HTTPValues.ControlBytes.ChunkedTerminator);
            this.delegate.flush();
            this.delegate.close();
        }
        this.closed = true;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.bufferIndex > 0) {
            String string = Integer.toHexString(this.bufferIndex) + "\r\n";
            this.chunkOutputStream.write(string.getBytes());
            this.chunkOutputStream.write(this.buffer, 0, this.bufferIndex);
            this.chunkOutputStream.write(HTTPValues.ControlBytes.CRLF);
            this.delegate.write(this.chunkOutputStream.bytes(), 0, this.chunkOutputStream.size());
            this.chunkOutputStream.reset();
            this.bufferIndex = 0;
        }
        this.delegate.flush();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = n; i < n2; i += n3) {
            n3 = Math.min(this.buffer.length - this.bufferIndex, n2 - i);
            System.arraycopy(byArray, i, this.buffer, this.bufferIndex, n3);
            this.bufferIndex += n3;
            if (this.bufferIndex < this.buffer.length) continue;
            this.flush();
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.bufferIndex < this.buffer.length) {
            this.buffer[this.bufferIndex++] = (byte)n;
        }
    }
}

