/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import io.fusionauth.http.Buildable;
import io.fusionauth.http.util.DateTools;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class Cookie
implements Buildable<Cookie> {
    public static final String DomainPrefix = "; Domain=";
    public static final String ExpiresPrefix = "; Expires=";
    public static final String HTTPOnlyPrefix = "; HttpOnly";
    public static final String MaxAgePrefix = "; Max-Age=";
    public static final String PathPrefix = "; Path=";
    public static final String SameSitePrefix = "; SameSite=";
    public static final String SecurePrefix = "; Secure";
    public Map<String, String> attributes = new HashMap<String, String>(0);
    public String domain;
    public ZonedDateTime expires;
    public boolean httpOnly;
    public Long maxAge;
    public String name;
    public String path;
    public SameSite sameSite;
    public boolean secure;
    public String value;

    public Cookie() {
    }

    public Cookie(String string, String string2) {
        this.name = string;
        this.value = string2;
    }

    public Cookie(Cookie cookie) {
        if (cookie == null) {
            return;
        }
        this.attributes.putAll(cookie.attributes);
        this.domain = cookie.domain;
        this.expires = cookie.expires;
        this.httpOnly = cookie.httpOnly;
        this.maxAge = cookie.maxAge;
        this.name = cookie.name;
        this.path = cookie.path;
        this.sameSite = cookie.sameSite;
        this.secure = cookie.secure;
        this.value = cookie.value;
    }

    public static List<Cookie> fromRequestHeader(String string) {
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        boolean bl = false;
        boolean bl2 = false;
        char[] cArray = string.toCharArray();
        int n = 0;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (!(bl || bl2 || !Character.isWhitespace(c) && c != ';')) {
                ++n;
                continue;
            }
            if (c == '=' && bl) {
                string2 = new String(cArray, n, i - n);
                string3 = "";
                bl2 = true;
                bl = false;
                n = i + 1;
                continue;
            }
            if (c == ';' && bl2) {
                string3 = new String(cArray, n, i - n);
                if (!string2.trim().isEmpty() && !string3.trim().isEmpty()) {
                    arrayList.add(new Cookie(string2, string3));
                }
                bl2 = false;
                string2 = null;
                string3 = null;
                n = 0;
                continue;
            }
            if (bl || bl2) continue;
            bl = true;
            n = i;
        }
        if (bl && n > 0) {
            string2 = string.substring(n);
        }
        if (bl2 && n > 0) {
            string3 = string.substring(n);
        }
        if (string2 != null && string3 != null && !string2.trim().isEmpty() && !string3.trim().isEmpty()) {
            arrayList.add(new Cookie(string2, string3));
        }
        return arrayList;
    }

    public static Cookie fromResponseHeader(String string) {
        Cookie cookie = new Cookie();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        char[] cArray = string.toCharArray();
        int n = 0;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = cArray[i];
            if (!(bl || bl2 || !Character.isWhitespace(c) && c != ';')) {
                ++n;
                continue;
            }
            if (c == '=' && bl) {
                string2 = string.substring(n, i);
                if (!bl3 && string2.trim().isEmpty()) {
                    return null;
                }
                string3 = "";
                bl2 = true;
                bl = false;
                n = i < string.length() - 1 && cArray[i + 1] == '\"' ? i + 2 : i + 1;
                continue;
            }
            if (c == ';') {
                if (bl) {
                    if (!bl3) {
                        return null;
                    }
                    string2 = string.substring(n, i);
                    string3 = null;
                } else {
                    int n2 = cArray[i - 1] == '\"' ? i - 1 : i;
                    string3 = string.substring(n, n2);
                }
                if (bl3) {
                    cookie.addAttribute(string2, string3);
                } else {
                    cookie.name = string2;
                    cookie.value = string3;
                }
                bl = false;
                bl2 = false;
                bl3 = true;
                string2 = null;
                string3 = null;
                continue;
            }
            if (bl || bl2) continue;
            bl = true;
            n = i;
        }
        if (bl && n > 0) {
            string2 = string.substring(n);
        }
        if (bl2 && n > 0) {
            string3 = string.substring(n);
        }
        if (bl3) {
            cookie.addAttribute(string2, string3);
        } else {
            if (string2 == null || string3 == null || string2.trim().isEmpty()) {
                return null;
            }
            cookie.name = string2;
            cookie.value = string3;
        }
        return cookie;
    }

    public void addAttribute(String string, String string2) {
        if (string == null) {
            return;
        }
        switch (string.toLowerCase(Locale.ROOT)) {
            case "domain": {
                this.domain = string2;
                break;
            }
            case "expires": {
                this.expires = DateTools.parse(string2);
                break;
            }
            case "httponly": {
                this.httpOnly = true;
                break;
            }
            case "max-age": {
                try {
                    this.maxAge = Long.parseLong(string2);
                }
                catch (Exception exception) {}
                break;
            }
            case "path": {
                this.path = string2;
                break;
            }
            case "samesite": {
                try {
                    this.sameSite = SameSite.valueOf(string2);
                }
                catch (Exception exception) {}
                break;
            }
            case "secure": {
                this.secure = true;
            }
            default: {
                this.attributes.put(string, string2 == null ? "" : string2);
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Cookie)) {
            return false;
        }
        Cookie cookie = (Cookie)object;
        return this.httpOnly == cookie.httpOnly && this.secure == cookie.secure && Objects.equals(this.attributes, cookie.attributes) && Objects.equals(this.domain, cookie.domain) && Objects.equals(this.expires, cookie.expires) && Objects.equals(this.maxAge, cookie.maxAge) && Objects.equals(this.name, cookie.name) && Objects.equals(this.path, cookie.path) && this.sameSite == cookie.sameSite && Objects.equals(this.value, cookie.value);
    }

    public String getAttribute(String string) {
        return this.attributes.get(string);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public ZonedDateTime getExpires() {
        return this.expires;
    }

    public void setExpires(ZonedDateTime zonedDateTime) {
        this.expires = zonedDateTime;
    }

    public Long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Long l) {
        this.maxAge = l;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public SameSite getSameSite() {
        return this.sameSite;
    }

    public void setSameSite(SameSite sameSite) {
        this.sameSite = sameSite;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public boolean hasAttribute(String string) {
        return this.attributes.containsKey(string);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributes, this.domain, this.expires, this.httpOnly, this.maxAge, this.name, this.path, this.sameSite, this.secure, this.value});
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean bl) {
        this.httpOnly = bl;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public String toRequestHeader() {
        return this.name + "=" + this.value;
    }

    public String toResponseHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name).append("=");
        if (this.value != null) {
            stringBuilder.append(this.value);
        }
        if (this.domain != null) {
            stringBuilder.append(DomainPrefix).append(this.domain);
        }
        if (this.expires != null) {
            stringBuilder.append(ExpiresPrefix).append(DateTools.format(this.expires));
        }
        if (this.httpOnly) {
            stringBuilder.append(HTTPOnlyPrefix);
        }
        if (this.maxAge != null) {
            stringBuilder.append(MaxAgePrefix).append(this.maxAge);
        }
        if (this.path != null) {
            stringBuilder.append(PathPrefix).append(this.path);
        }
        if (this.sameSite != null) {
            stringBuilder.append(SameSitePrefix).append(this.sameSite.name());
        }
        if (this.secure) {
            stringBuilder.append(SecurePrefix);
        }
        return stringBuilder.toString();
    }

    public static enum SameSite {
        Lax,
        None,
        Strict;

    }
}

