/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.samlv2.util;

import io.fusionauth.samlv2.domain.NameID;
import io.fusionauth.samlv2.domain.SAMLException;
import io.fusionauth.samlv2.domain.jaxb.oasis.assertion.NameIDType;
import io.fusionauth.samlv2.domain.jaxb.oasis.metadata.KeyDescriptorType;
import io.fusionauth.samlv2.domain.jaxb.w3c.xmldsig.X509DataType;
import io.fusionauth.samlv2.util.SAMLRequestParameters;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class SAMLTools {
    private static final Map<String, Boolean> FactoryFeatures = new HashMap<String, Boolean>();
    private static final Map<Class<?>, Unmarshaller> UnmarshallerCache = new ConcurrentHashMap();
    private static final Logger logger = LoggerFactory.getLogger(SAMLTools.class);

    public static String attributeToString(Object attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute instanceof Number) {
            return attribute.toString();
        }
        if (attribute instanceof String) {
            return (String)attribute;
        }
        if (attribute instanceof Element) {
            return ((Element)attribute).getTextContent();
        }
        logger.warn("This library currently doesn't handle attributes of type [" + attribute.getClass() + "]");
        return null;
    }

    public static ZonedDateTime convertToZonedDateTime(XMLGregorianCalendar cal) {
        return cal != null ? cal.toGregorianCalendar().toZonedDateTime() : null;
    }

    public static byte[] decode(String base64Encoded) {
        return Base64.getMimeDecoder().decode(base64Encoded);
    }

    public static byte[] decodeAndInflate(String encodedRequest) throws SAMLException {
        byte[] bytes = Base64.getMimeDecoder().decode(encodedRequest);
        Inflater inflater = new Inflater(true);
        inflater.setInput(bytes);
        try {
            int length;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while (inflater.getRemaining() > 0 && (length = inflater.inflate(buf)) > 0) {
                os.write(buf, 0, length);
            }
            return os.toByteArray();
        }
        catch (DataFormatException e) {
            throw new SAMLException("Invalid AuthnRequest. Inflating the bytes failed.", e);
        }
    }

    public static String decodeToString(String base64Encoded) {
        return new String(Base64.getMimeDecoder().decode(base64Encoded), StandardCharsets.UTF_8);
    }

    public static String deflateAndEncode(byte[] bytes) {
        Deflater deflater = new Deflater(8, true);
        deflater.setInput(bytes);
        deflater.finish();
        byte[] deflatedResult = new byte[bytes.length];
        int length = deflater.deflate(deflatedResult);
        deflater.end();
        byte[] src = Arrays.copyOf(deflatedResult, length);
        return new String(Base64.getEncoder().encode(src), StandardCharsets.UTF_8);
    }

    public static String encode(byte[] bytes) {
        return new String(Base64.getEncoder().encode(bytes), StandardCharsets.UTF_8);
    }

    public static <T> byte[] marshallToBytes(JAXBElement<T> object, Class<T> type) throws SAMLException {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{type});
            Marshaller marshaller = context.createMarshaller();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            marshaller.marshal(object, (OutputStream)os);
            return os.toByteArray();
        }
        catch (JAXBException e) {
            throw new SAMLException("Unable to marshallRequest JAXB SAML object to bytes.", e);
        }
    }

    public static <T> Document marshallToDocument(JAXBElement<T> object, Class<T> type) throws SAMLException {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{type});
            Marshaller marshaller = context.createMarshaller();
            Document document = SAMLTools.newDocumentBuilder().newDocument();
            marshaller.marshal(object, (Node)document);
            return document;
        }
        catch (SAMLException | JAXBException e) {
            throw new SAMLException("Unable to marshallRequest JAXB SAML object to DOM.", e);
        }
    }

    public static String marshallToString(Document document) throws TransformerException {
        return SAMLTools.marshallNodeToString(document, false);
    }

    public static String marshallToString(Element element) throws TransformerException {
        return SAMLTools.marshallNodeToString(element, true);
    }

    public static DocumentBuilder newDocumentBuilder() throws SAMLException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setExpandEntityReferences(false);
            for (String key : FactoryFeatures.keySet()) {
                try {
                    dbf.setFeature(key, FactoryFeatures.get(key));
                }
                catch (IllegalArgumentException e) {
                    logger.debug("Failed to set feature [" + key + "=" + FactoryFeatures.get(key) + "]. This may be expected if the parser does not recognize this feature.", (Throwable)e);
                }
            }
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SAMLException("Unable to configure the DocumentBuilderFactory with feature [http://javax.xml.XMLConstants/feature/secure-processing].", e);
        }
    }

    public static Document newDocumentFromBytes(byte[] bytes) throws SAMLException {
        try {
            return SAMLTools.newDocumentBuilder().parse(new ByteArrayInputStream(bytes));
        }
        catch (IOException | SAXException e) {
            throw new SAMLException("Unable to parse SAML v2.0 document.", e);
        }
    }

    public static NameID parseNameId(NameIDType element) {
        NameID nameId = new NameID();
        nameId.format = element.getFormat();
        nameId.id = element.getValue();
        return nameId;
    }

    public static SAMLRequestParameters parseQueryString(String queryString) {
        String[] parts;
        SAMLRequestParameters result = new SAMLRequestParameters();
        if (queryString == null) {
            return result;
        }
        block12: for (String part : parts = queryString.split("&")) {
            String[] param = part.split("=");
            if (param.length != 2) continue;
            switch (param[0]) {
                case "RelayState": {
                    result.RelayState = param[1];
                    continue block12;
                }
                case "SAMLRequest": {
                    result.SAMLRequest = param[1];
                    continue block12;
                }
                case "SigAlg": {
                    result.SigAlg = param[1];
                    continue block12;
                }
                case "Signature": {
                    result.Signature = param[1];
                }
            }
        }
        return result;
    }

    public static Certificate toCertificate(KeyDescriptorType keyDescriptorType) {
        try {
            List<Object> keyData = keyDescriptorType.getKeyInfo().getContent();
            for (Object keyDatum : keyData) {
                JAXBElement element;
                if (!(keyDatum instanceof JAXBElement) || (element = (JAXBElement)keyDatum).getDeclaredType() != X509DataType.class) continue;
                X509DataType cert = (X509DataType)element.getValue();
                List<Object> certData = cert.getX509IssuerSerialOrX509SKIOrX509SubjectName();
                for (Object certDatum : certData) {
                    element = (JAXBElement)certDatum;
                    if (!element.getName().getLocalPart().equals("X509Certificate")) continue;
                    byte[] certBytes = (byte[])element.getValue();
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    return cf.generateCertificate(new ByteArrayInputStream(certBytes));
                }
            }
            return null;
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(ZonedDateTime instant) throws SAMLException {
        if (instant == null) {
            return null;
        }
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(GregorianCalendar.from(instant));
        }
        catch (DatatypeConfigurationException e) {
            throw new SAMLException("Unable to initiate DataTypeFactor.", e);
        }
    }

    public static ZonedDateTime toZonedDateTime(XMLGregorianCalendar instant) {
        if (instant == null) {
            return null;
        }
        return instant.toGregorianCalendar().toZonedDateTime();
    }

    public static <T> T unmarshallFromDocument(Document document, Class<T> type) throws SAMLException {
        try {
            Unmarshaller unmarshaller = SAMLTools.getUnmarshaller(type);
            JAXBElement element = unmarshaller.unmarshal((Node)document, type);
            return (T)element.getValue();
        }
        catch (JAXBException e) {
            throw new SAMLException("Unable to unmarshall SAML response", e);
        }
    }

    public static boolean validate(Document document, URL schemaURI, SchemaValidationErrors errors) throws SAMLException {
        Schema schema;
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            schema = schemaFactory.newSchema(schemaURI);
        }
        catch (SAXException e) {
            throw new SAMLException("An invalid schema was requested. Schema [" + schemaURI + "].", e);
        }
        Validator validator = schema.newValidator();
        validator.setErrorHandler(errors);
        try {
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
        try {
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
        DOMSource source = new DOMSource(document);
        try {
            validator.validate(source);
        }
        catch (IOException | SAXException e) {
            throw new SAMLException("Failed to validate the document source.", e);
        }
        return errors.error.isEmpty() && errors.fatal.isEmpty() && errors.warning.isEmpty();
    }

    private static <T> Unmarshaller getUnmarshaller(Class<T> type) throws SAMLException {
        Unmarshaller result = UnmarshallerCache.get(type);
        if (result == null) {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{type});
                result = context.createUnmarshaller();
            }
            catch (Exception e) {
                throw new SAMLException(e.getCause());
            }
            UnmarshallerCache.put(type, result);
        }
        return result;
    }

    private static String marshallNodeToString(Node node, boolean omitXMLDeclaration) throws TransformerException {
        StringWriter sw = new StringWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", omitXMLDeclaration ? "yes" : "no");
        transformer.transform(new DOMSource(node), new StreamResult(sw));
        return sw.toString();
    }

    static {
        FactoryFeatures.put("http://apache.org/xml/features/disallow-doctype-decl", true);
        FactoryFeatures.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        FactoryFeatures.put("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        FactoryFeatures.put("http://xml.org/sax/features/external-general-entities", false);
        FactoryFeatures.put("http://xml.org/sax/features/external-parameter-entities", false);
    }

    public static class SchemaValidationErrors
    implements ErrorHandler {
        public final List<SAXParseException> error = new ArrayList<SAXParseException>();
        public final List<SAXParseException> fatal = new ArrayList<SAXParseException>();
        public final List<SAXParseException> warning = new ArrayList<SAXParseException>();

        @Override
        public void error(SAXParseException exception) {
            this.error.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) {
            this.fatal.add(exception);
        }

        @Override
        public void warning(SAXParseException exception) {
            this.warning.add(exception);
        }
    }
}

