/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.samlv2.domain;

public enum ResponseStatus {
    AuthenticationFailed("urn:oasis:names:tc:SAML:2.0:status:AuthnFailed"),
    InvalidAttribute("urn:oasis:names:tc:SAML:2.0:status:InvalidAttrNameOrValue"),
    InvalidNameIDPolicy("urn:oasis:names:tc:SAML:2.0:status:InvalidNameIDPolicy"),
    NoAuthenticationContext("urn:oasis:names:tc:SAML:2.0:status:NoAuthnContext"),
    NoAvailableIDP("urn:oasis:names:tc:SAML:2.0:status:NoAvailableIDP"),
    NoPassive("urn:oasis:names:tc:SAML:2.0:status:NoPassive"),
    NoSupportedIDP("urn:oasis:names:tc:SAML:2.0:status:NoSupportedIDP"),
    PartialLogout("urn:oasis:names:tc:SAML:2.0:status:PartialLogout"),
    ProxyCountExceeded("urn:oasis:names:tc:SAML:2.0:status:ProxyCountExceeded"),
    Requester("urn:oasis:names:tc:SAML:2.0:status:Requester"),
    RequestDenied("urn:oasis:names:tc:SAML:2.0:status:RequestDenied"),
    RequestUnsupported("urn:oasis:names:tc:SAML:2.0:status:RequestUnsupported"),
    RequestVersionDeprecated("urn:oasis:names:tc:SAML:2.0:status:RequestVersionDeprecated"),
    RequestVersionTooHigh("urn:oasis:names:tc:SAML:2.0:status:RequestVersionTooHigh"),
    RequestVersionTooLow("urn:oasis:names:tc:SAML:2.0:status:RequestVersionTooLow"),
    ResourceNotRecognized("urn:oasis:names:tc:SAML:2.0:status:ResourceNotRecognized"),
    Responder("urn:oasis:names:tc:SAML:2.0:status:Responder"),
    Success("urn:oasis:names:tc:SAML:2.0:status:Success"),
    TooManyResponses("urn:oasis:names:tc:SAML:2.0:status:TooManyResponses"),
    UnknownAttributeProfile("urn:oasis:names:tc:SAML:2.0:status:UnknownAttrProfile"),
    UnknownPrincipal("urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal"),
    UnsupportedBinding("urn:oasis:names:tc:SAML:2.0:status:UnsupportedBinding"),
    VersionMismatch("urn:oasis:names:tc:SAML:2.0:status:VersionMismatch");

    private final String samlFormat;

    private ResponseStatus(String string2) {
        this.samlFormat = string2;
    }

    public static ResponseStatus fromSAMLFormat(String string) {
        if (string == null) {
            return null;
        }
        for (ResponseStatus responseStatus : ResponseStatus.values()) {
            if (!responseStatus.toSAMLFormat().equals(string)) continue;
            return responseStatus;
        }
        throw new IllegalArgumentException("Invalid SAML v2.0 status value [" + string + "]");
    }

    public String toSAMLFormat() {
        return this.samlFormat;
    }
}

