/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.der;

import io.fusionauth.der.DerInputStream;
import io.fusionauth.der.DerOutputStream;
import io.fusionauth.der.ObjectIdentifier;
import io.fusionauth.der.Tag;
import io.fusionauth.der.TagClass;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;

public class DerValue {
    private final DerInputStream value;
    public Tag tag;

    public DerValue(Tag tag, byte[] byArray) {
        this.tag = tag;
        this.value = new DerInputStream(byArray);
    }

    public DerValue(int n, byte[] byArray) {
        this.tag = new Tag(n);
        this.value = new DerInputStream(byArray);
    }

    public DerValue(BigInteger bigInteger) {
        this.tag = new Tag(2);
        this.value = new DerInputStream(bigInteger.toByteArray());
    }

    public DerValue(int n, DerOutputStream derOutputStream) {
        this.tag = new Tag(n);
        this.value = new DerInputStream(derOutputStream.toByteArray());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DerValue)) {
            return false;
        }
        DerValue derValue = (DerValue)object;
        return this.tag == derValue.tag && Arrays.equals(this.value.toByteArray(), derValue.value.toByteArray());
    }

    public BigInteger getBigInteger(boolean bl) {
        return bl ? new BigInteger(this.value.toByteArray()) : new BigInteger(1, this.value.toByteArray());
    }

    public BigInteger getBigInteger() {
        return this.getBigInteger(true);
    }

    public String getBitString() {
        if (this.tag.value != 3) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = this.value.toByteArray();
        byte by = byArray[0];
        for (int i = 1; i < byArray.length; ++i) {
            if (i == byArray.length - 1 && by != 0) {
                int n = (byArray[i] & 0xFF) >> by;
                stringBuilder.append(String.format("%" + (8 - by) + "s", Integer.toBinaryString(n)).replace(' ', '0'));
                continue;
            }
            stringBuilder.append(String.format("%8s", Integer.toBinaryString(byArray[i] & 0xFF)).replace(' ', '0'));
        }
        return stringBuilder.toString();
    }

    public int getLength() {
        return this.value.length;
    }

    public ObjectIdentifier getOID() throws IOException {
        return this.value.getOID();
    }

    public BigInteger getPositiveBigInteger() {
        return this.getBigInteger(false);
    }

    public int hashCode() {
        int n = Objects.hash(this.tag);
        n = 31 * n + Arrays.hashCode(this.value.toByteArray());
        return n;
    }

    public byte[] toByteArray() {
        return this.value.toByteArray();
    }

    public String toString() {
        if (this.tag.tagClass == TagClass.ContextSpecific) {
            return this.tag.toString();
        }
        return this.tag.getName() + ", length=" + this.value.length;
    }
}

