/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.samlv2.service;

import io.fusionauth.samlv2.domain.Algorithm;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.Date;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class CertificateTools {
    public static X509Certificate fromKeyPair(KeyPair keyPair, Algorithm algorithm, String string) throws IllegalArgumentException {
        try {
            X509CertInfo x509CertInfo = new X509CertInfo();
            CertificateX509Key certificateX509Key = new CertificateX509Key(keyPair.getPublic());
            x509CertInfo.set("key", certificateX509Key);
            x509CertInfo.set("version", new CertificateVersion(1));
            x509CertInfo.set("algorithmID", new CertificateAlgorithmId(new AlgorithmId(ObjectIdentifier.of(KnownOIDs.SHA256withRSA))));
            x509CertInfo.set("issuer", new X500Name("cn=" + string));
            x509CertInfo.set("subject", new X500Name("cn=" + string));
            x509CertInfo.set("validity", new CertificateValidity(new Date(0L), new Date(ZonedDateTime.now().plusYears(99L).toInstant().toEpochMilli())));
            x509CertInfo.set("serialNumber", new CertificateSerialNumber(BigInteger.valueOf(System.currentTimeMillis())));
            X509CertImpl x509CertImpl = new X509CertImpl(x509CertInfo);
            x509CertImpl.sign(keyPair.getPrivate(), algorithm.name);
            return x509CertImpl;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }
}

