/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.samlv2.domain;

public enum EncryptionAlgorithm {
    TripleDES("Triple DES", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "DESede/CBC/ISO10126Padding", 8),
    AES128("AES-128", "http://www.w3.org/2001/04/xmlenc#aes128-cbc", "AES/CBC/ISO10126Padding", 16),
    AES192("AES-192", "http://www.w3.org/2001/04/xmlenc#aes192-cbc", "AES/CBC/ISO10126Padding", 16),
    AES256("AES-256", "http://www.w3.org/2001/04/xmlenc#aes256-cbc", "AES/CBC/ISO10126Padding", 16),
    AES128GCM("AES128-GCM", "http://www.w3.org/2009/xmlenc11#aes128-gcm", "AES/GCM/NoPadding", 12),
    AES192GCM("AES192-GCM", "http://www.w3.org/2009/xmlenc11#aes192-gcm", "AES/GCM/NoPadding", 12),
    AES256GCM("AES256-GCM", "http://www.w3.org/2009/xmlenc11#aes256-gcm", "AES/GCM/NoPadding", 12);

    public final int ivLength;
    public final String name;
    public final String transformation;
    public final String uri;

    private EncryptionAlgorithm(String string2, String string3, String string4, int n2) {
        this.name = string2;
        this.uri = string3;
        this.transformation = string4;
        this.ivLength = n2;
    }

    public static EncryptionAlgorithm fromURI(String string) {
        for (EncryptionAlgorithm encryptionAlgorithm : EncryptionAlgorithm.values()) {
            if (!encryptionAlgorithm.uri.equals(string)) continue;
            return encryptionAlgorithm;
        }
        return null;
    }
}

