/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.der;

import io.fusionauth.der.DerDecodingException;
import io.fusionauth.domain.Buildable;
import java.util.Arrays;
import java.util.Objects;

public class ObjectIdentifier
implements Buildable<ObjectIdentifier> {
    public static final String ECDSA_P256 = "1.2.840.10045.3.1.7";
    public static final String ECDSA_P384 = "1.3.132.0.34";
    public static final String ECDSA_P521 = "1.3.132.0.35";
    public static final String EC_ENCRYPTION = "1.2.840.10045.2.1";
    public static final String RSA_ENCRYPTION = "1.2.840.113549.1.1.1";
    public static final String RSA_SHA256 = "1.2.840.113549.1.1.11";
    public static final String RSA_SHA384 = "1.2.840.113549.1.1.12";
    public static final String RSA_SHA512 = "1.2.840.113549.1.1.13";
    public byte[] value;
    private String decoded;

    public ObjectIdentifier(byte[] byArray) {
        this.value = byArray;
    }

    public String decode() throws DerDecodingException {
        if (this.decoded == null) {
            this._decode();
        }
        return this.decoded;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectIdentifier)) {
            return false;
        }
        ObjectIdentifier objectIdentifier = (ObjectIdentifier)object;
        return Arrays.equals(this.value, objectIdentifier.value) && Objects.equals(this.decoded, objectIdentifier.decoded);
    }

    public int hashCode() {
        int n = Objects.hash(this.decoded);
        n = 31 * n + Arrays.hashCode(this.value);
        return n;
    }

    public String toString() {
        try {
            return this.decode();
        }
        catch (DerDecodingException derDecodingException) {
            return "Failed to _decode this object, unable to produce a string.";
        }
    }

    private void _decode() throws DerDecodingException {
        StringBuilder stringBuilder = new StringBuilder(this.value.length * 4);
        int n = 0;
        for (int i = 0; i < this.value.length; ++i) {
            if (i - n + 1 > 4) {
                throw new DerDecodingException("The object identifier contains a node that is larger than 4 bytes. This is not currently supported using this library.");
            }
            byte by = this.value[i];
            if ((by & 0x80) != 0) continue;
            if (n != 0) {
                stringBuilder.append('.');
            }
            int n2 = 0;
            for (int j = n; j <= i; ++j) {
                n2 <<= 7;
                n2 |= this.value[j] & 0x7F;
            }
            if (n == 0) {
                if (n2 < 80) {
                    stringBuilder.append(n2 / 40).append('.').append(n2 % 40);
                } else {
                    stringBuilder.append("2.").append(n2 - 80);
                }
            } else {
                stringBuilder.append(n2);
            }
            n = i + 1;
        }
        this.decoded = stringBuilder.toString();
    }
}

