/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.plugin.spi.security;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import java.util.regex.Pattern;

public interface PasswordEncryptor {
    public static final Pattern Base64SaltPattern = Pattern.compile("^[A-Za-z0-9+/]+=*$");

    public int defaultFactor();

    public String encrypt(String var1, String var2, int var3);

    default public String generateSalt() {
        ByteBuffer buf = ByteBuffer.allocate(32);
        UUID first = UUID.randomUUID();
        buf.putLong(first.getLeastSignificantBits());
        buf.putLong(first.getMostSignificantBits());
        UUID second = UUID.randomUUID();
        buf.putLong(second.getLeastSignificantBits());
        buf.putLong(second.getMostSignificantBits());
        return Base64.getEncoder().encodeToString(buf.array());
    }

    default public String pluginDisplayName() {
        return null;
    }

    default public boolean validateSalt(String salt) {
        try {
            Base64.getDecoder().decode(salt.getBytes(StandardCharsets.UTF_8));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

