/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load.reporters;

import io.fusionauth.load.CSVSampleListener;
import io.fusionauth.load.Configuration;
import io.fusionauth.load.ConfigurationInjected;
import io.fusionauth.load.Reporter;
import io.fusionauth.load.SampleListener;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class DefaultReporter
implements Reporter {
    public final List<SampleListener> listeners = new ArrayList<SampleListener>();
    private boolean csvOutput;
    private int interval;
    private Map<String, BufferedWriter> outputWriters = new HashMap<String, BufferedWriter>(1);
    private ScheduledExecutorService scheduler;

    @ConfigurationInjected
    public DefaultReporter(Configuration configuration) {
        this();
        this.csvOutput = configuration.getBoolean("csvOutput", true);
        this.interval = configuration.getInteger("interval", 5);
    }

    public DefaultReporter() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    @Override
    public void addSampleListeners(Collection<SampleListener> listeners) {
        this.listeners.addAll(listeners);
    }

    @Override
    public void report() {
        try {
            StringBuilder builder = new StringBuilder();
            this.buildReport(builder);
            System.out.println(builder.toString());
        }
        catch (Exception e) {
            System.out.println("Reporting failure \n  " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public void schedule() {
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.scheduler.scheduleAtFixedRate(this::report, this.interval, this.interval, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        try {
            System.out.println("\nStop was called. Wait up to 5 seconds for everything to wrap up.");
            this.scheduler.shutdown();
            this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            System.out.println("Tried to Wait 5 seconds for scheduler to shutdown and a InterruptedException was thrown. Call scheduler.shutdownNow()");
            this.scheduler.shutdownNow();
        }
        System.out.println("  --> Reporter Shutting down. Cleaning up...");
        this.shutdown();
    }

    private void buildReport(StringBuilder builder) throws Exception {
        for (SampleListener listener : this.listeners) {
            listener.report(builder);
            if (!this.csvOutput || !(listener instanceof CSVSampleListener)) continue;
            CSVSampleListener csvListener = (CSVSampleListener)((Object)listener);
            BufferedWriter bufferedWriter = this.getOutputWriter(csvListener);
            csvListener.report(bufferedWriter);
        }
    }

    private BufferedWriter getOutputWriter(CSVSampleListener csvListener) throws Exception {
        String fileName = csvListener.outputFileName();
        if (!this.outputWriters.containsKey(fileName)) {
            Path file = Paths.get("./" + fileName + ".csv", new String[0]);
            int count = 0;
            while (Files.exists(file, new LinkOption[0])) {
                file = Paths.get("./" + fileName + "." + ++count + ".csv", new String[0]);
            }
            Files.createFile(file, new FileAttribute[0]);
            this.outputWriters.put(fileName, new BufferedWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(file.getFileName().toString(), false)))));
            csvListener.reportHeader(this.outputWriters.get(fileName));
        }
        return this.outputWriters.get(fileName);
    }

    private void shutdown() {
        Iterator<Map.Entry<String, BufferedWriter>> iterator = this.outputWriters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, BufferedWriter> entry = iterator.next();
            try {
                System.out.println("  --> Closing writer [" + entry.getKey() + "]");
                entry.getValue().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            iterator.remove();
        }
    }
}

