/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fusionauth.load.Configuration;
import io.fusionauth.load.Foreman;
import io.fusionauth.load.LoadDefinition;
import io.fusionauth.load.Reporter;
import io.fusionauth.load.SampleListener;
import io.fusionauth.load.WorkerFactory;
import io.fusionauth.load.reporters.DefaultReporter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidParameterException;

public class JSONConfigurator {
    private final LoadDefinition definition;
    public Foreman foreman;

    public JSONConfigurator(URL configurationUrl) throws Exception {
        this(Paths.get(configurationUrl.toURI()));
    }

    public JSONConfigurator(Path configurationFile) throws Exception {
        if (!Files.exists(configurationFile, new LinkOption[0]) || !Files.isRegularFile(configurationFile, new LinkOption[0])) {
            throw new InvalidParameterException("Configuration file does not exist or is not a file.");
        }
        ObjectMapper objectMapper = new ObjectMapper();
        this.definition = (LoadDefinition)objectMapper.readValue(configurationFile.toFile(), LoadDefinition.class);
        this.foreman = new Foreman().with(f -> {
            f.loadDefinition = this.definition;
        });
        this.configureWorkerFactory();
        this.configureReporter();
        this.configureListeners();
    }

    private void configureListeners() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        for (Configuration configuration : this.definition.listeners) {
            Object instance = this.newInstance(configuration);
            if (instance instanceof SampleListener) {
                this.foreman.listeners.add((SampleListener)instance);
                continue;
            }
            throw new IllegalArgumentException("class in configuration does not extend SampleListener [" + configuration.className + "]");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureReporter() throws InvocationTargetException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        if (this.definition.reporter != null) {
            Object instance = this.newInstance(this.definition.reporter);
            if (!(instance instanceof Reporter)) throw new IllegalArgumentException("class in configuration is not a Reporter or subclass [" + this.definition.reporter.className + "]");
            this.foreman.reporter = (Reporter)instance;
            return;
        } else {
            this.foreman.reporter = new DefaultReporter();
        }
    }

    private void configureWorkerFactory() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Object instance = this.newInstance(this.definition.workerFactory);
        if (!(instance instanceof WorkerFactory)) {
            throw new IllegalArgumentException("class in configuration does not extend WorkerFactory [" + this.definition.workerFactory.className + "]");
        }
        this.foreman.with(f -> {
            f.workerFactory = (WorkerFactory)instance;
        }).with(f -> {
            f.workerCount = this.definition.workerCount;
        }).with(f -> {
            f.loopCount = this.definition.loopCount;
        }).with(f -> {
            f.rampWait = this.definition.rampWait;
        });
    }

    private Object newInstance(Configuration configuration) {
        try {
            try {
                return Class.forName(configuration.className).getConstructor(Configuration.class).newInstance(configuration);
            }
            catch (NoSuchMethodException e) {
                return Class.forName(configuration.className).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

