/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import com.inversoft.rest.ClientResponse;
import io.fusionauth.client.FusionAuthClient;
import io.fusionauth.domain.api.UserResponse;
import io.fusionauth.load.Configuration;
import io.fusionauth.load.FusionAuthBaseWorker;
import java.util.Map;
import java.util.Random;

public class FusionAuthUpdatePasswordWorker
extends FusionAuthBaseWorker {
    private final int loginLowerBound;
    private final int loginUpperBound;

    public FusionAuthUpdatePasswordWorker(FusionAuthClient client, Configuration configuration) {
        super(client, configuration);
        this.loginLowerBound = configuration.getInteger("loginLowerBound", 0);
        this.loginUpperBound = configuration.getInteger("loginUpperBound", 1000000);
    }

    @Override
    public boolean execute() {
        int index = new Random().nextInt(this.loginUpperBound - this.loginLowerBound + 1) + this.loginLowerBound;
        this.setUserIndex(index);
        String email = "load_user_" + this.userIndex + "@fusionauth.io";
        String newPassword = "password_" + new Random().nextInt(1000000);
        ClientResponse result = this.tenantScopedClient.retrieveUserByEmail(email);
        if (result.wasSuccessful()) {
            ClientResponse patchResult = this.tenantScopedClient.patchUser(((UserResponse)result.successResponse).user.id, Map.of("user", Map.of("password", newPassword)));
            if (patchResult.wasSuccessful()) {
                return true;
            }
            System.err.println("Failed to update password for user: " + email);
            this.printErrors(patchResult);
        } else {
            System.err.println("Failed to retrieve user: " + email);
            this.printErrors(result);
        }
        return false;
    }
}

