/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import com.inversoft.rest.ClientResponse;
import io.fusionauth.client.FusionAuthClient;
import io.fusionauth.domain.api.LoginRequest;
import io.fusionauth.domain.api.LoginResponse;
import io.fusionauth.domain.api.jwt.RefreshRequest;
import io.fusionauth.load.BaseWorker;
import io.fusionauth.load.Configuration;
import java.util.Random;
import java.util.UUID;

public class FusionAuthRefreshWorker
extends BaseWorker {
    private final UUID applicationId;
    private final FusionAuthClient client;
    private final int loginLowerBound;
    private final int loginUpperBound;
    private String refreshToken;

    public FusionAuthRefreshWorker(FusionAuthClient client, Configuration configuration) {
        super(configuration);
        this.client = client;
        this.applicationId = UUID.fromString(configuration.getString("applicationId"));
        this.loginLowerBound = configuration.getInteger("loginLowerBound", 0);
        this.loginUpperBound = configuration.getInteger("loginUpperBound", 1000000);
    }

    @Override
    public boolean execute() {
        ClientResponse result;
        if (this.refreshToken == null) {
            int random = new Random().nextInt(this.loginUpperBound - this.loginLowerBound + 1) + this.loginLowerBound;
            String email = "load_user_" + random + "@fusionauth.io";
            ClientResponse result2 = this.client.login(new LoginRequest(this.applicationId, email, "11e7ea7b-784d-4687-bf2d-4f8ee479a4dd11e7ea7b-784d-4687-bf2d-4f8ee479a4dd"));
            if (result2.wasSuccessful()) {
                this.refreshToken = ((LoginResponse)result2.successResponse).refreshToken;
            } else {
                this.printErrors(result2);
                return false;
            }
        }
        if ((result = this.client.exchangeRefreshTokenForJWT(new RefreshRequest(this.refreshToken))).wasSuccessful()) {
            return true;
        }
        this.printErrors(result);
        return false;
    }
}

