/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import io.fusionauth.client.FusionAuthClient;
import io.fusionauth.load.BaseWorker;
import io.fusionauth.load.Configuration;
import java.util.UUID;

public abstract class FusionAuthBaseWorker
extends BaseWorker {
    protected final int applicationCount;
    protected final FusionAuthClient client;
    protected final int tenantCount;
    protected UUID applicationId;
    protected int applicationIndex;
    protected UUID tenantId;
    protected int tenantIndex;
    protected FusionAuthClient tenantScopedClient;
    protected int userIndex;

    public FusionAuthBaseWorker(FusionAuthClient client, Configuration configuration) {
        super(configuration);
        this.client = client;
        this.applicationCount = configuration.getInteger("applicationCount", 0);
        this.tenantCount = configuration.getInteger("tenantCount", 0);
        this.tenantScopedClient = client;
    }

    public static UUID applicationUUID(int index) {
        return new UUID(1L, index);
    }

    public static UUID tenantUUID(int index) {
        return new UUID(0L, index);
    }

    protected void setApplicationIndex(int index) {
        this.applicationIndex = index;
        if (this.tenantCount > 0) {
            int tenantIndex = this.applicationIndex % this.tenantCount;
            if (tenantIndex == 0) {
                tenantIndex = this.tenantCount;
            }
            this.applicationId = FusionAuthBaseWorker.applicationUUID(this.applicationIndex);
            this.setTenantIndex(tenantIndex);
        }
    }

    protected void setTenantIndex(int index) {
        this.tenantIndex = index;
        this.tenantId = FusionAuthBaseWorker.tenantUUID(this.tenantIndex);
        this.tenantScopedClient = this.client.setTenantId(this.tenantId);
    }

    protected void setUserIndex(int index) {
        this.userIndex = index;
        if (this.applicationCount > 0 && this.tenantCount > 0) {
            this.applicationIndex = this.userIndex % this.applicationCount;
            if (this.applicationIndex == 0) {
                this.applicationIndex = this.applicationCount;
            }
            this.setApplicationIndex(this.applicationIndex);
        }
    }
}

