/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import io.fusionauth.load.Buildable;
import io.fusionauth.load.FusionAuthOAuth2AuthorizeWorker;
import io.fusionauth.load.LoadDefinition;
import io.fusionauth.load.Reporter;
import io.fusionauth.load.SampleListener;
import io.fusionauth.load.Worker;
import io.fusionauth.load.WorkerExecutor;
import io.fusionauth.load.WorkerFactory;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;

public class Foreman
implements Buildable<Foreman> {
    public final List<SampleListener> listeners = new ArrayList<SampleListener>();
    public final List<Worker> workers = new ArrayList<Worker>();
    public boolean done;
    public LoadDefinition loadDefinition;
    public int loopCount;
    public int rampWait;
    public Reporter reporter;
    public int workerCount;
    public WorkerFactory workerFactory;
    private boolean initialized;

    public Foreman execute() throws InterruptedException {
        this.initialize();
        try (ExecutorService pool = Executors.newVirtualThreadPerTaskExecutor();){
            for (Worker worker : this.workers) {
                WorkerExecutor executor = new WorkerExecutor(worker, this.loopCount, this.listeners);
                pool.execute(executor);
                try {
                    Thread.sleep(this.rampWait);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.reporter != null) {
                this.reporter.schedule();
            }
            pool.shutdown();
            pool.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            this.listeners.forEach(SampleListener::done);
            if (this.reporter != null) {
                this.reporter.report();
            }
            if (this.reporter != null) {
                this.reporter.stop();
            }
            if (this.workers.get(0) instanceof FusionAuthOAuth2AuthorizeWorker) {
                System.out.println("\n\n");
                long total = FusionAuthOAuth2AuthorizeWorker.timing.render + FusionAuthOAuth2AuthorizeWorker.timing.post + FusionAuthOAuth2AuthorizeWorker.timing.token;
                long iterationCount = (long)this.workers.size() * (long)this.loopCount;
                int renderPercent = (int)((double)FusionAuthOAuth2AuthorizeWorker.timing.render * 100.0 / (double)total + 0.5);
                int postPercent = (int)((double)FusionAuthOAuth2AuthorizeWorker.timing.post * 100.0 / (double)total + 0.5);
                int tokenPercent = (int)((double)FusionAuthOAuth2AuthorizeWorker.timing.token * 100.0 / (double)total + 0.5);
                System.out.println("Render: " + FusionAuthOAuth2AuthorizeWorker.timing.render + " ms, Average: " + FusionAuthOAuth2AuthorizeWorker.timing.render / iterationCount + " ms, " + renderPercent + "%");
                System.out.println("Post: " + FusionAuthOAuth2AuthorizeWorker.timing.post + " ms, Average: " + FusionAuthOAuth2AuthorizeWorker.timing.post / iterationCount + " ms, " + postPercent + "%");
                System.out.println("Token: " + FusionAuthOAuth2AuthorizeWorker.timing.token + " ms, Average: " + FusionAuthOAuth2AuthorizeWorker.timing.token / iterationCount + " ms, " + tokenPercent + "%");
                System.out.println("\n\n");
            }
            this.done = true;
            this.initialized = true;
            Foreman foreman = this;
            return foreman;
        }
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        DecimalFormat df = new DecimalFormat("#,###");
        System.out.println("Foreman Initialized");
        this.loopCount = Math.max(1, this.loopCount);
        System.out.println("  --> Loop count:\t" + df.format(this.loopCount));
        if (this.workerCount > 0 && this.workerFactory == null) {
            throw new IllegalStateException("Please provide a worker factory if you are going to specify a worker count");
        }
        System.out.println("  --> Worker count:\t" + df.format(this.workerCount));
        System.out.println("  --> Total iterations:\t" + df.format((long)this.workerCount * (long)this.loopCount));
        System.out.println("  --> Worker factory:\t" + this.workerFactory.getClass().getCanonicalName());
        System.out.println("  --> Prepare the factory for production....");
        this.workerFactory.prepare(this.loadDefinition);
        IntStream.range(0, this.workerCount).forEachOrdered(n -> this.workers.add(this.workerFactory.createWorker()));
        if (this.reporter != null) {
            this.reporter.addSampleListeners(this.listeners);
        }
    }
}

